/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.repository;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MConfigUpdateEntityType;
import org.apache.sqoop.model.MConnector;
import org.apache.sqoop.model.MDriver;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MLink;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.repository.JdbcRepositoryContext;
import org.apache.sqoop.repository.JdbcRepositoryHandler;
import org.apache.sqoop.repository.JdbcRepositoryTransaction;
import org.apache.sqoop.repository.Repository;
import org.apache.sqoop.repository.RepositoryError;
import org.apache.sqoop.repository.RepositoryTransaction;

public class JdbcRepository
extends Repository {
    private static final Logger LOG = Logger.getLogger(JdbcRepository.class);
    private final JdbcRepositoryHandler handler;
    private final JdbcRepositoryContext repoContext;

    protected JdbcRepository(JdbcRepositoryHandler handler, JdbcRepositoryContext repoContext) {
        this.handler = handler;
        this.repoContext = repoContext;
    }

    private Object doWithConnection(DoWithConnection delegator) {
        return this.doWithConnection(delegator, null);
    }

    private Object doWithConnection(DoWithConnection delegator, JdbcRepositoryTransaction tx) {
        boolean shouldCloseTxn = false;
        try {
            if (tx == null) {
                tx = this.getTransaction();
                shouldCloseTxn = true;
                tx.begin();
            }
            Connection conn = tx.getConnection();
            Object returnValue = delegator.doIt(conn);
            if (shouldCloseTxn) {
                tx.commit();
            }
            Object object = returnValue;
            return object;
        }
        catch (SqoopException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (tx != null && shouldCloseTxn) {
                tx.rollback();
            }
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0012, (Throwable)ex);
        }
        finally {
            if (tx != null && shouldCloseTxn) {
                tx.close();
            }
        }
    }

    @Override
    public JdbcRepositoryTransaction getTransaction() {
        return (JdbcRepositoryTransaction)this.repoContext.getTransactionFactory().get();
    }

    @Override
    public void createOrUpgradeRepository() {
        this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) throws Exception {
                LOG.info((Object)"Creating repository schema objects");
                JdbcRepository.this.handler.createOrUpgradeRepository(conn);
                return null;
            }
        });
    }

    @Override
    public boolean isRepositorySuitableForUse() {
        return (Boolean)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) throws Exception {
                return JdbcRepository.this.handler.isRepositorySuitableForUse(conn);
            }
        });
    }

    @Override
    public MConnector registerConnector(final MConnector mConnector, final boolean autoUpgrade) {
        return (MConnector)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) throws Exception {
                String connectorUniqueName = mConnector.getUniqueName();
                MConnector connectorResult = JdbcRepository.this.handler.findConnector(connectorUniqueName, conn);
                if (connectorResult == null) {
                    JdbcRepository.this.handler.registerConnector(mConnector, conn);
                    return mConnector;
                }
                if (connectorResult.getUniqueName().equals(mConnector.getUniqueName()) && mConnector.getVersion().compareTo(connectorResult.getVersion()) > 0) {
                    if (autoUpgrade) {
                        JdbcRepository.this.upgradeConnector(connectorResult, mConnector);
                        return mConnector;
                    }
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0026, "Connector: " + mConnector.getUniqueName());
                }
                if (!connectorResult.equals((Object)mConnector)) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0013, "Connector: " + mConnector.getUniqueName() + " given: " + mConnector + " found: " + connectorResult);
                }
                return connectorResult;
            }
        });
    }

    @Override
    public MConnector findConnector(final String shortName) {
        return (MConnector)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) throws Exception {
                return JdbcRepository.this.handler.findConnector(shortName, conn);
            }
        });
    }

    @Override
    public List<MConnector> findConnectors() {
        return (List)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                return JdbcRepository.this.handler.findConnectors(conn);
            }
        });
    }

    @Override
    public MDriver registerDriver(final MDriver mDriver, final boolean autoUpgrade) {
        return (MDriver)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                MDriver existingDriver = JdbcRepository.this.handler.findDriver(mDriver.getUniqueName(), conn);
                if (existingDriver == null) {
                    JdbcRepository.this.handler.registerDriver(mDriver, conn);
                    return mDriver;
                }
                if (!mDriver.equals((Object)existingDriver)) {
                    if (autoUpgrade) {
                        JdbcRepository.this.upgradeDriver(mDriver);
                        return mDriver;
                    }
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0026, "Driver: " + mDriver.getPersistenceId());
                }
                return existingDriver;
            }
        });
    }

    @Override
    public MDriver findDriver(final String shortName) {
        return (MDriver)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) throws Exception {
                return JdbcRepository.this.handler.findDriver(shortName, conn);
            }
        });
    }

    @Override
    public void createLink(final MLink link) {
        this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                if (link.hasPersistenceId()) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0015);
                }
                JdbcRepository.this.handler.createLink(link, conn);
                return null;
            }
        });
    }

    @Override
    public void updateLink(MLink link) {
        this.updateLink(link, null);
    }

    @Override
    public void updateLink(final MLink link, RepositoryTransaction tx) {
        this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                if (!link.hasPersistenceId()) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0016);
                }
                if (!JdbcRepository.this.handler.existsLink(link.getPersistenceId(), conn)) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0017, "Invalid id: " + link.getPersistenceId());
                }
                JdbcRepository.this.handler.updateLink(link, conn);
                return null;
            }
        }, (JdbcRepositoryTransaction)tx);
    }

    @Override
    public void enableLink(final long linkId, final boolean enabled) {
        this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                if (!JdbcRepository.this.handler.existsLink(linkId, conn)) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0017, "Invalid id: " + linkId);
                }
                JdbcRepository.this.handler.enableLink(linkId, enabled, conn);
                return null;
            }
        });
    }

    @Override
    public void deleteLink(final long linkId) {
        this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                if (!JdbcRepository.this.handler.existsLink(linkId, conn)) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0017, "Invalid id: " + linkId);
                }
                if (JdbcRepository.this.handler.inUseLink(linkId, conn)) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0021, "Id in use: " + linkId);
                }
                JdbcRepository.this.handler.deleteLink(linkId, conn);
                return null;
            }
        });
    }

    @Override
    public MLink findLink(final long id) {
        return (MLink)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                return JdbcRepository.this.handler.findLink(id, conn);
            }
        });
    }

    @Override
    public MLink findLink(final String name) {
        return (MLink)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                return JdbcRepository.this.handler.findLink(name, conn);
            }
        });
    }

    @Override
    public List<MLink> findLinks() {
        return (List)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                return JdbcRepository.this.handler.findLinks(conn);
            }
        });
    }

    @Override
    public List<MLink> findLinksForConnector(final long connectorId) {
        return (List)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) throws Exception {
                return JdbcRepository.this.handler.findLinksForConnector(connectorId, conn);
            }
        });
    }

    @Override
    public void createJob(final MJob job) {
        this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                if (job.hasPersistenceId()) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0018);
                }
                JdbcRepository.this.handler.createJob(job, conn);
                return null;
            }
        });
    }

    @Override
    public void updateJob(MJob job) {
        this.updateJob(job, null);
    }

    @Override
    public void updateJob(final MJob job, RepositoryTransaction tx) {
        this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                if (!job.hasPersistenceId()) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0019);
                }
                if (!JdbcRepository.this.handler.existsJob(job.getPersistenceId(), conn)) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0020, "Invalid id: " + job.getPersistenceId());
                }
                JdbcRepository.this.handler.updateJob(job, conn);
                return null;
            }
        }, (JdbcRepositoryTransaction)tx);
    }

    @Override
    public void enableJob(final long id, final boolean enabled) {
        this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                if (!JdbcRepository.this.handler.existsJob(id, conn)) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0020, "Invalid id: " + id);
                }
                JdbcRepository.this.handler.enableJob(id, enabled, conn);
                return null;
            }
        });
    }

    @Override
    public void deleteJob(final long id) {
        this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                if (!JdbcRepository.this.handler.existsJob(id, conn)) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0020, "Invalid id: " + id);
                }
                if (JdbcRepository.this.handler.inUseJob(id, conn)) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0022, "Id in use: " + id);
                }
                JdbcRepository.this.handler.deleteJob(id, conn);
                return null;
            }
        });
    }

    @Override
    public MJob findJob(final long id) {
        return (MJob)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                return JdbcRepository.this.handler.findJob(id, conn);
            }
        });
    }

    @Override
    public MJob findJob(final String name) {
        return (MJob)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                return JdbcRepository.this.handler.findJob(name, conn);
            }
        });
    }

    @Override
    public List<MJob> findJobs() {
        return (List)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                return JdbcRepository.this.handler.findJobs(conn);
            }
        });
    }

    @Override
    public List<MJob> findJobsForConnector(final long connectorId) {
        return (List)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) throws Exception {
                return JdbcRepository.this.handler.findJobsForConnector(connectorId, conn);
            }
        });
    }

    @Override
    public void createSubmission(final MSubmission submission) {
        this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                if (submission.hasPersistenceId()) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0023);
                }
                JdbcRepository.this.handler.createSubmission(submission, conn);
                return null;
            }
        });
    }

    @Override
    public void updateSubmission(final MSubmission submission) {
        this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                if (!submission.hasPersistenceId()) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0024);
                }
                if (!JdbcRepository.this.handler.existsSubmission(submission.getPersistenceId(), conn)) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0025, "Invalid id: " + submission.getPersistenceId());
                }
                JdbcRepository.this.handler.updateSubmission(submission, conn);
                return null;
            }
        });
    }

    @Override
    public void purgeSubmissions(final Date threshold) {
        this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                JdbcRepository.this.handler.purgeSubmissions(threshold, conn);
                return null;
            }
        });
    }

    @Override
    public List<MSubmission> findUnfinishedSubmissions() {
        return (List)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                return JdbcRepository.this.handler.findUnfinishedSubmissions(conn);
            }
        });
    }

    @Override
    public List<MSubmission> findSubmissions() {
        return (List)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) throws Exception {
                return JdbcRepository.this.handler.findSubmissions(conn);
            }
        });
    }

    @Override
    public List<MSubmission> findSubmissionsForJob(final long jobId) {
        return (List)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) throws Exception {
                if (!JdbcRepository.this.handler.existsJob(jobId, conn)) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0020, "Invalid id: " + jobId);
                }
                return JdbcRepository.this.handler.findSubmissionsForJob(jobId, conn);
            }
        });
    }

    @Override
    public MSubmission findLastSubmissionForJob(final long jobId) {
        return (MSubmission)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                if (!JdbcRepository.this.handler.existsJob(jobId, conn)) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0020, "Invalid id: " + jobId);
                }
                return JdbcRepository.this.handler.findLastSubmissionForJob(jobId, conn);
            }
        });
    }

    @Override
    public MConfig findFromJobConfig(final long jobId, final String configName) {
        return (MConfig)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                if (!JdbcRepository.this.handler.existsJob(jobId, conn)) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0020, "Invalid id: " + jobId);
                }
                return JdbcRepository.this.handler.findFromJobConfig(jobId, configName, conn);
            }
        });
    }

    @Override
    public MConfig findToJobConfig(final long jobId, final String configName) {
        return (MConfig)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                if (!JdbcRepository.this.handler.existsJob(jobId, conn)) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0020, "Invalid id: " + jobId);
                }
                return JdbcRepository.this.handler.findToJobConfig(jobId, configName, conn);
            }
        });
    }

    @Override
    public MConfig findDriverJobConfig(final long jobId, final String configName) {
        return (MConfig)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                if (!JdbcRepository.this.handler.existsJob(jobId, conn)) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0020, "Invalid id: " + jobId);
                }
                return JdbcRepository.this.handler.findDriverJobConfig(jobId, configName, conn);
            }
        });
    }

    @Override
    public MConfig findLinkConfig(final long linkId, final String configName) {
        return (MConfig)this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                if (!JdbcRepository.this.handler.existsLink(linkId, conn)) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0017, "Invalid id: " + linkId);
                }
                return JdbcRepository.this.handler.findLinkConfig(linkId, configName, conn);
            }
        });
    }

    @Override
    public void updateJobConfig(long jobId, MConfig config, MConfigUpdateEntityType type) {
        this.updateJobConfig(jobId, config, null);
    }

    @Override
    public void updateJobConfig(final long jobId, final MConfig config, final MConfigUpdateEntityType type, RepositoryTransaction tx) {
        this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                if (!JdbcRepository.this.handler.existsJob(jobId, conn)) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0020, "Invalid id: " + jobId);
                }
                JdbcRepository.this.handler.updateJobConfig(jobId, config, type, conn);
                return null;
            }
        }, (JdbcRepositoryTransaction)tx);
    }

    @Override
    public void updateLinkConfig(long linkId, MConfig config, MConfigUpdateEntityType type) {
        this.updateLinkConfig(linkId, config, type, null);
    }

    @Override
    public void updateLinkConfig(final long linkId, final MConfig config, final MConfigUpdateEntityType type, RepositoryTransaction tx) {
        this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) {
                if (!JdbcRepository.this.handler.existsLink(linkId, conn)) {
                    throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0017, "Invalid id: " + linkId);
                }
                JdbcRepository.this.handler.updateLinkConfig(linkId, config, type, conn);
                return null;
            }
        }, (JdbcRepositoryTransaction)tx);
    }

    @Override
    protected void deleteJobInputs(final long jobID, RepositoryTransaction tx) {
        this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) throws Exception {
                JdbcRepository.this.handler.deleteJobInputs(jobID, conn);
                return null;
            }
        }, (JdbcRepositoryTransaction)tx);
    }

    @Override
    protected void deleteLinkInputs(final long linkId, RepositoryTransaction tx) {
        this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) throws Exception {
                JdbcRepository.this.handler.deleteLinkInputs(linkId, conn);
                return null;
            }
        }, (JdbcRepositoryTransaction)tx);
    }

    @Override
    protected void upgradeConnectorAndConfigs(final MConnector newConnector, RepositoryTransaction tx) {
        this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) throws Exception {
                JdbcRepository.this.handler.upgradeConnectorAndConfigs(newConnector, conn);
                return null;
            }
        }, (JdbcRepositoryTransaction)tx);
    }

    @Override
    protected void upgradeDriverAndConfigs(final MDriver mDriver, RepositoryTransaction tx) {
        this.doWithConnection(new DoWithConnection(){

            @Override
            public Object doIt(Connection conn) throws Exception {
                JdbcRepository.this.handler.upgradeDriverAndConfigs(mDriver, conn);
                return null;
            }
        }, (JdbcRepositoryTransaction)tx);
    }

    private static interface DoWithConnection {
        public Object doIt(Connection var1) throws Exception;
    }
}

