/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.driver;

import java.util.HashSet;
import java.util.Set;
import org.apache.sqoop.common.Direction;
import org.apache.sqoop.common.DirectionError;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.MutableMapContext;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.connector.idf.IntermediateDataFormat;
import org.apache.sqoop.connector.spi.SqoopConnector;
import org.apache.sqoop.job.etl.Transferable;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.utils.ClassUtils;

public class JobRequest {
    MSubmission jobSubmission;
    String jobName;
    long jobId;
    SqoopConnector fromConnector = null;
    SqoopConnector toConnector = null;
    Set<String> jars = new HashSet<String>();
    Transferable from;
    Transferable to;
    Object fromConnectorLinkConfig = null;
    Object toConnectorLinkConfig = null;
    Object fromConfig = null;
    Object toConfig = null;
    Object driverConfig = null;
    MutableMapContext fromConnectorContext = new MutableMapContext();
    MutableMapContext toConnectorContext = new MutableMapContext();
    MutableMapContext driverContext = new MutableMapContext();
    String notificationUrl;
    Integer extractors;
    Integer loaders;
    Class<? extends IntermediateDataFormat<?>> fromIDF;
    Class<? extends IntermediateDataFormat<?>> toIDF;

    public MSubmission getJobSubmission() {
        return this.jobSubmission;
    }

    public void setJobSubmission(MSubmission submission) {
        this.jobSubmission = submission;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public long getJobId() {
        return this.jobId;
    }

    public void setJobId(long jobId) {
        this.jobId = jobId;
    }

    public SqoopConnector getConnector(Direction type) {
        switch (type) {
            case FROM: {
                return this.fromConnector;
            }
            case TO: {
                return this.toConnector;
            }
        }
        throw new SqoopException((ErrorCode)DirectionError.DIRECTION_0000, "Direction: " + type);
    }

    public void setConnector(Direction type, SqoopConnector connector) {
        switch (type) {
            case FROM: {
                this.fromConnector = connector;
                break;
            }
            case TO: {
                this.toConnector = connector;
                break;
            }
            default: {
                throw new SqoopException((ErrorCode)DirectionError.DIRECTION_0000, "Direction: " + type);
            }
        }
    }

    public Set<String> getJars() {
        return this.jars;
    }

    public void addJar(String jar) {
        if (!this.jars.contains(jar)) {
            this.jars.add(jar);
        }
    }

    public void addJarForClass(Class<?> klass) {
        this.addJar(ClassUtils.jarForClass(klass));
    }

    public void addJars(Set<String> jars) {
        for (String j : jars) {
            this.addJar(j);
        }
    }

    public Transferable getFrom() {
        return this.from;
    }

    public void setFrom(Transferable from) {
        this.from = from;
    }

    public Transferable getTo() {
        return this.to;
    }

    public void setTo(Transferable to) {
        this.to = to;
    }

    public Object getConnectorLinkConfig(Direction type) {
        switch (type) {
            case FROM: {
                return this.fromConnectorLinkConfig;
            }
            case TO: {
                return this.toConnectorLinkConfig;
            }
        }
        throw new SqoopException((ErrorCode)DirectionError.DIRECTION_0000, "Direction: " + type);
    }

    public void setConnectorLinkConfig(Direction type, Object config) {
        switch (type) {
            case FROM: {
                this.fromConnectorLinkConfig = config;
                break;
            }
            case TO: {
                this.toConnectorLinkConfig = config;
                break;
            }
            default: {
                throw new SqoopException((ErrorCode)DirectionError.DIRECTION_0000, "Direction: " + type);
            }
        }
    }

    public Object getJobConfig(Direction type) {
        switch (type) {
            case FROM: {
                return this.fromConfig;
            }
            case TO: {
                return this.toConfig;
            }
        }
        throw new SqoopException((ErrorCode)DirectionError.DIRECTION_0000, "Direction: " + type);
    }

    public void setJobConfig(Direction type, Object config) {
        switch (type) {
            case FROM: {
                this.fromConfig = config;
                break;
            }
            case TO: {
                this.toConfig = config;
                break;
            }
            default: {
                throw new SqoopException((ErrorCode)DirectionError.DIRECTION_0000, "Direction: " + type);
            }
        }
    }

    public Object getDriverConfig() {
        return this.driverConfig;
    }

    public void setDriverConfig(Object config) {
        this.driverConfig = config;
    }

    public MutableMapContext getConnectorContext(Direction type) {
        switch (type) {
            case FROM: {
                return this.fromConnectorContext;
            }
            case TO: {
                return this.toConnectorContext;
            }
        }
        throw new SqoopException((ErrorCode)DirectionError.DIRECTION_0000, "Direction: " + type);
    }

    public MutableMapContext getDriverContext() {
        return this.driverContext;
    }

    public String getNotificationUrl() {
        return this.notificationUrl;
    }

    public void setNotificationUrl(String url) {
        this.notificationUrl = url;
    }

    public Integer getExtractors() {
        return this.extractors;
    }

    public void setExtractors(Integer extractors) {
        this.extractors = extractors;
    }

    public Integer getLoaders() {
        return this.loaders;
    }

    public void setLoaders(Integer loaders) {
        this.loaders = loaders;
    }

    public Class<? extends IntermediateDataFormat<?>> getIntermediateDataFormat(Direction direction) {
        return direction.equals((Object)Direction.FROM) ? this.fromIDF : this.toIDF;
    }

    public void setIntermediateDataFormat(Class<? extends IntermediateDataFormat<? extends Object>> intermediateDataFormat, Direction direction) {
        if (direction.equals((Object)Direction.FROM)) {
            this.fromIDF = intermediateDataFormat;
        } else if (direction.equals((Object)Direction.TO)) {
            this.toIDF = intermediateDataFormat;
        }
    }
}

