/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.driver;

import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.Direction;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.ImmutableContext;
import org.apache.sqoop.common.MapContext;
import org.apache.sqoop.common.MutableContext;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.connector.ConnectorManager;
import org.apache.sqoop.connector.idf.IntermediateDataFormat;
import org.apache.sqoop.connector.spi.SqoopConnector;
import org.apache.sqoop.core.Reconfigurable;
import org.apache.sqoop.core.SqoopConfiguration;
import org.apache.sqoop.driver.Driver;
import org.apache.sqoop.driver.ExecutionEngine;
import org.apache.sqoop.driver.JobRequest;
import org.apache.sqoop.driver.SubmissionEngine;
import org.apache.sqoop.driver.configuration.JobConfiguration;
import org.apache.sqoop.error.code.DriverError;
import org.apache.sqoop.job.etl.Destroyer;
import org.apache.sqoop.job.etl.DestroyerContext;
import org.apache.sqoop.job.etl.Initializer;
import org.apache.sqoop.job.etl.InitializerContext;
import org.apache.sqoop.job.etl.Transferable;
import org.apache.sqoop.model.ConfigUtils;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MLink;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.repository.Repository;
import org.apache.sqoop.repository.RepositoryManager;
import org.apache.sqoop.request.HttpEventContext;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.submission.SubmissionStatus;
import org.apache.sqoop.utils.ClassUtils;

public class JobManager
implements Reconfigurable {
    private static final Logger LOG = Logger.getLogger(JobManager.class);
    private static JobManager instance = new JobManager();
    private static final long DEFAULT_PURGE_THRESHOLD = 86400000L;
    private static final long DEFAULT_PURGE_SLEEP = 86400000L;
    private static final long DEFAULT_UPDATE_SLEEP = 300000L;
    private SubmissionEngine submissionEngine;
    private ExecutionEngine executionEngine;
    private PurgeThread purgeThread = null;
    private UpdateThread updateThread = null;
    private boolean running = true;
    private long purgeThreshold;
    private long purgeSleep;
    private long updateSleep;
    private String notificationBaseUrl;

    public static JobManager getInstance() {
        return instance;
    }

    public static void setInstance(JobManager newInstance) {
        instance = newInstance;
    }

    public void setNotificationBaseUrl(String url) {
        LOG.debug((Object)("Setting notification base URL to " + url));
        this.notificationBaseUrl = url;
    }

    public String getNotificationBaseUrl() {
        return this.notificationBaseUrl;
    }

    public synchronized void destroy() {
        LOG.trace((Object)"Begin submission engine manager destroy");
        this.running = false;
        try {
            this.purgeThread.interrupt();
            this.purgeThread.join();
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Interrupted joining purgeThread");
        }
        try {
            this.updateThread.interrupt();
            this.updateThread.join();
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Interrupted joining updateThread");
        }
        if (this.submissionEngine != null) {
            this.submissionEngine.destroy();
        }
        if (this.executionEngine != null) {
            this.executionEngine.destroy();
        }
    }

    public synchronized void initialize() {
        LOG.trace((Object)"Begin submission engine manager initialization");
        MapContext context = SqoopConfiguration.getInstance().getContext();
        String submissionEngineClassName = context.getString("org.apache.sqoop.submission.engine");
        this.submissionEngine = (SubmissionEngine)ClassUtils.instantiate((String)submissionEngineClassName, (Object[])new Object[0]);
        if (this.submissionEngine == null) {
            throw new SqoopException((ErrorCode)DriverError.DRIVER_0001, submissionEngineClassName);
        }
        this.submissionEngine.initialize(context, "org.apache.sqoop.submission.engine.");
        String executionEngineClassName = context.getString("org.apache.sqoop.execution.engine");
        this.executionEngine = (ExecutionEngine)ClassUtils.instantiate((String)executionEngineClassName, (Object[])new Object[0]);
        if (this.executionEngine == null) {
            throw new SqoopException((ErrorCode)DriverError.DRIVER_0007, executionEngineClassName);
        }
        if (!this.submissionEngine.isExecutionEngineSupported(this.executionEngine.getClass())) {
            throw new SqoopException((ErrorCode)DriverError.DRIVER_0008);
        }
        this.executionEngine.initialize((ImmutableContext)context, "org.apache.sqoop.execution.engine.");
        this.purgeThreshold = context.getLong("org.apache.sqoop.submission.purge.threshold", 86400000L);
        this.purgeSleep = context.getLong("org.apache.sqoop.submission.purge.sleep", 86400000L);
        this.purgeThread = new PurgeThread();
        this.purgeThread.start();
        this.updateSleep = context.getLong("org.apache.sqoop.submission.update.sleep", 300000L);
        this.updateThread = new UpdateThread();
        this.updateThread.start();
        SqoopConfiguration.getInstance().getProvider().registerListener(new SqoopConfiguration.CoreConfigurationListener(this));
        LOG.info((Object)"Submission manager initialized: OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MSubmission start(long jobId, HttpEventContext ctx) {
        MSubmission mSubmission = this.createJobSubmission(ctx, jobId);
        JobRequest jobRequest = this.createJobRequest(jobId, mSubmission);
        this.prepareJob(jobRequest);
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            MSubmission lastSubmission = RepositoryManager.getInstance().getRepository().findLastSubmissionForJob(jobId);
            if (lastSubmission != null && lastSubmission.getStatus().isRunning()) {
                throw new SqoopException((ErrorCode)DriverError.DRIVER_0002, "Job with id " + jobId);
            }
            boolean success = this.submissionEngine.submit(jobRequest);
            if (!success) {
                this.invokeDestroyerOnJobFailure(jobRequest);
                mSubmission.setStatus(SubmissionStatus.FAILURE_ON_SUBMIT);
            }
            RepositoryManager.getInstance().getRepository().createSubmission(mSubmission);
        }
        return mSubmission;
    }

    private JobRequest createJobRequest(long jobId, MSubmission submission) {
        MJob job = this.getJob(jobId);
        MLink fromConnection = this.getLink(job.getFromLinkId());
        MLink toConnection = this.getLink(job.getToLinkId());
        SqoopConnector fromConnector = this.getSqoopConnector(fromConnection.getConnectorId());
        this.validateSupportedDirection(fromConnector, Direction.FROM);
        SqoopConnector toConnector = this.getSqoopConnector(toConnection.getConnectorId());
        this.validateSupportedDirection(toConnector, Direction.TO);
        Object fromLinkConfig = ClassUtils.instantiate((Class)fromConnector.getLinkConfigurationClass(), (Object[])new Object[0]);
        ConfigUtils.fromConfigs((List)fromConnection.getConnectorLinkConfig().getConfigs(), (Object)fromLinkConfig);
        Object toLinkConfig = ClassUtils.instantiate((Class)toConnector.getLinkConfigurationClass(), (Object[])new Object[0]);
        ConfigUtils.fromConfigs((List)toConnection.getConnectorLinkConfig().getConfigs(), (Object)toLinkConfig);
        Object fromJob = ClassUtils.instantiate((Class)fromConnector.getJobConfigurationClass(Direction.FROM), (Object[])new Object[0]);
        ConfigUtils.fromConfigs((List)job.getFromJobConfig().getConfigs(), (Object)fromJob);
        Object toJob = ClassUtils.instantiate((Class)toConnector.getJobConfigurationClass(Direction.TO), (Object[])new Object[0]);
        ConfigUtils.fromConfigs((List)job.getToJobConfig().getConfigs(), (Object)toJob);
        Object driverConfig = ClassUtils.instantiate((Class)Driver.getInstance().getDriverJobConfigurationClass(), (Object[])new Object[0]);
        ConfigUtils.fromConfigs((List)job.getDriverConfig().getConfigs(), (Object)driverConfig);
        JobRequest jobRequest = this.executionEngine.createJobRequest();
        jobRequest.setJobSubmission(submission);
        jobRequest.setConnector(Direction.FROM, fromConnector);
        jobRequest.setConnector(Direction.TO, toConnector);
        jobRequest.setConnectorLinkConfig(Direction.FROM, fromLinkConfig);
        jobRequest.setConnectorLinkConfig(Direction.TO, toLinkConfig);
        jobRequest.setJobConfig(Direction.FROM, fromJob);
        jobRequest.setJobConfig(Direction.TO, toJob);
        jobRequest.setDriverConfig(driverConfig);
        jobRequest.setJobName(job.getName());
        jobRequest.setJobId(job.getPersistenceId());
        jobRequest.setNotificationUrl(this.notificationBaseUrl + jobId);
        jobRequest.setIntermediateDataFormat(fromConnector.getIntermediateDataFormat(), Direction.FROM);
        jobRequest.setIntermediateDataFormat(toConnector.getIntermediateDataFormat(), Direction.TO);
        jobRequest.setFrom((Transferable)fromConnector.getFrom());
        jobRequest.setTo((Transferable)toConnector.getTo());
        this.addStandardJars(jobRequest);
        this.addConnectorClass(jobRequest, fromConnector);
        this.addConnectorClass(jobRequest, toConnector);
        this.addConnectorIDFClass(jobRequest, fromConnector.getIntermediateDataFormat());
        this.addConnectorIDFClass(jobRequest, toConnector.getIntermediateDataFormat());
        this.addConnectorInitializerJars(jobRequest, Direction.FROM);
        this.addConnectorInitializerJars(jobRequest, Direction.TO);
        this.addIDFDependentJars(jobRequest, Direction.FROM);
        this.addIDFDependentJars(jobRequest, Direction.TO);
        this.initializeConnector(jobRequest, Direction.FROM);
        this.initializeConnector(jobRequest, Direction.TO);
        jobRequest.getJobSubmission().setFromSchema(this.getSchemaForConnector(jobRequest, Direction.FROM));
        jobRequest.getJobSubmission().setToSchema(this.getSchemaForConnector(jobRequest, Direction.TO));
        LOG.debug((Object)("Using entities: " + jobRequest.getFrom() + ", " + jobRequest.getTo()));
        return jobRequest;
    }

    private void addConnectorClass(JobRequest jobRequest, SqoopConnector connector) {
        jobRequest.addJarForClass(connector.getClass());
    }

    private void addConnectorIDFClass(JobRequest jobRequest, Class<? extends IntermediateDataFormat<?>> idfClass) {
        jobRequest.addJarForClass(idfClass);
    }

    private void addStandardJars(JobRequest jobRequest) {
        jobRequest.addJarForClass(MapContext.class);
        jobRequest.addJarForClass(Driver.class);
        jobRequest.addJarForClass(SqoopConnector.class);
        jobRequest.addJarForClass(this.executionEngine.getClass());
    }

    MSubmission createJobSubmission(HttpEventContext ctx, long jobId) {
        MSubmission summary = new MSubmission(jobId);
        summary.setCreationUser(ctx.getUsername());
        summary.setLastUpdateUser(ctx.getUsername());
        return summary;
    }

    SqoopConnector getSqoopConnector(long connnectorId) {
        return ConnectorManager.getInstance().getSqoopConnector(connnectorId);
    }

    void validateSupportedDirection(SqoopConnector connector, Direction direction) {
        if (!connector.getSupportedDirections().contains(direction)) {
            throw new SqoopException((ErrorCode)DriverError.DRIVER_0011, "Connector: " + connector.getClass().getCanonicalName());
        }
    }

    MLink getLink(long linkId) {
        MLink link = RepositoryManager.getInstance().getRepository().findLink(linkId);
        if (!link.getEnabled()) {
            throw new SqoopException((ErrorCode)DriverError.DRIVER_0010, "Connection id: " + link.getPersistenceId());
        }
        return link;
    }

    MJob getJob(long jobId) {
        MJob job = RepositoryManager.getInstance().getRepository().findJob(jobId);
        if (job == null) {
            throw new SqoopException((ErrorCode)DriverError.DRIVER_0004, "Unknown job id: " + jobId);
        }
        if (!job.getEnabled()) {
            throw new SqoopException((ErrorCode)DriverError.DRIVER_0009, "Job id: " + job.getPersistenceId());
        }
        return job;
    }

    private void initializeConnector(JobRequest jobRequest, Direction direction) {
        Initializer initializer = this.getConnectorInitializer(jobRequest, direction);
        InitializerContext initializerContext = this.getConnectorInitializerContext(jobRequest, direction);
        initializer.initialize(initializerContext, jobRequest.getConnectorLinkConfig(direction), jobRequest.getJobConfig(direction));
    }

    private Schema getSchemaForConnector(JobRequest jobRequest, Direction direction) {
        Initializer initializer = this.getConnectorInitializer(jobRequest, direction);
        InitializerContext initializerContext = this.getConnectorInitializerContext(jobRequest, direction);
        return initializer.getSchema(initializerContext, jobRequest.getConnectorLinkConfig(direction), jobRequest.getJobConfig(direction));
    }

    private void addIDFDependentJars(JobRequest jobRequest, Direction direction) {
        Class<? extends IntermediateDataFormat<?>> idfClass = jobRequest.getIntermediateDataFormat(direction);
        IntermediateDataFormat idf = (IntermediateDataFormat)ClassUtils.instantiate(idfClass, (Object[])new Object[0]);
        jobRequest.addJars(idf.getJars());
    }

    private void addConnectorInitializerJars(JobRequest jobRequest, Direction direction) {
        Initializer initializer = this.getConnectorInitializer(jobRequest, direction);
        InitializerContext initializerContext = this.getConnectorInitializerContext(jobRequest, direction);
        jobRequest.addJars(initializer.getJars(initializerContext, jobRequest.getConnectorLinkConfig(direction), jobRequest.getJobConfig(direction)));
    }

    private Initializer getConnectorInitializer(JobRequest jobRequest, Direction direction) {
        Transferable transferable = direction.equals((Object)Direction.FROM) ? jobRequest.getFrom() : jobRequest.getTo();
        Class initializerClass = transferable.getInitializer();
        Initializer initializer = (Initializer)ClassUtils.instantiate((Class)initializerClass, (Object[])new Object[0]);
        if (initializer == null) {
            throw new SqoopException((ErrorCode)DriverError.DRIVER_0006, "Can't create connector initializer instance: " + initializerClass.getName());
        }
        return initializer;
    }

    private InitializerContext getConnectorInitializerContext(JobRequest jobRequest, Direction direction) {
        return new InitializerContext((MutableContext)jobRequest.getConnectorContext(direction));
    }

    void prepareJob(JobRequest request) {
        JobConfiguration jobConfiguration = (JobConfiguration)request.getDriverConfig();
        request.setExtractors(jobConfiguration.throttlingConfig.numExtractors);
        request.setLoaders(jobConfiguration.throttlingConfig.numLoaders);
        this.executionEngine.prepareJob(request);
    }

    void invokeDestroyerOnJobFailure(JobRequest request) {
        Transferable from = request.getFrom();
        Transferable to = request.getTo();
        Class fromDestroyerClass = from.getDestroyer();
        Class toDestroyerClass = to.getDestroyer();
        Destroyer fromDestroyer = (Destroyer)ClassUtils.instantiate((Class)fromDestroyerClass, (Object[])new Object[0]);
        Destroyer toDestroyer = (Destroyer)ClassUtils.instantiate((Class)toDestroyerClass, (Object[])new Object[0]);
        if (fromDestroyer == null) {
            throw new SqoopException((ErrorCode)DriverError.DRIVER_0006, "Can't create toDestroyer instance: " + fromDestroyerClass.getName());
        }
        if (toDestroyer == null) {
            throw new SqoopException((ErrorCode)DriverError.DRIVER_0006, "Can't create toDestroyer instance: " + toDestroyerClass.getName());
        }
        DestroyerContext fromDestroyerContext = new DestroyerContext((ImmutableContext)request.getConnectorContext(Direction.FROM), false, request.getJobSubmission().getFromSchema());
        DestroyerContext toDestroyerContext = new DestroyerContext((ImmutableContext)request.getConnectorContext(Direction.TO), false, request.getJobSubmission().getToSchema());
        fromDestroyer.destroy(fromDestroyerContext, request.getConnectorLinkConfig(Direction.FROM), request.getJobConfig(Direction.FROM));
        toDestroyer.destroy(toDestroyerContext, request.getConnectorLinkConfig(Direction.TO), request.getJobConfig(Direction.TO));
    }

    public MSubmission stop(long jobId, HttpEventContext ctx) {
        Repository repository = RepositoryManager.getInstance().getRepository();
        MSubmission mSubmission = repository.findLastSubmissionForJob(jobId);
        if (mSubmission == null || !mSubmission.getStatus().isRunning()) {
            throw new SqoopException((ErrorCode)DriverError.DRIVER_0003, "Job with id " + jobId + " is not running hence cannot stop");
        }
        this.submissionEngine.stop(mSubmission.getExternalJobId());
        mSubmission.setLastUpdateUser(ctx.getUsername());
        this.updateSubmission(mSubmission);
        return mSubmission;
    }

    public MSubmission status(long jobId) {
        Repository repository = RepositoryManager.getInstance().getRepository();
        MSubmission mSubmission = repository.findLastSubmissionForJob(jobId);
        if (mSubmission == null) {
            return new MSubmission(jobId, new Date(), SubmissionStatus.NEVER_EXECUTED);
        }
        if (mSubmission.getStatus().isRunning()) {
            this.updateSubmission(mSubmission);
        }
        return mSubmission;
    }

    public void updateSubmission(MSubmission submission) {
        this.submissionEngine.update(submission);
        RepositoryManager.getInstance().getRepository().updateSubmission(submission);
    }

    @Override
    public synchronized void configurationChanged() {
        String newExecutionEngineClassName;
        LOG.info((Object)"Begin submission engine manager reconfiguring");
        MapContext newContext = SqoopConfiguration.getInstance().getContext();
        MapContext oldContext = SqoopConfiguration.getInstance().getOldContext();
        String newSubmissionEngineClassName = newContext.getString("org.apache.sqoop.submission.engine");
        if (newSubmissionEngineClassName == null || newSubmissionEngineClassName.trim().length() == 0) {
            throw new SqoopException((ErrorCode)DriverError.DRIVER_0001, newSubmissionEngineClassName);
        }
        String oldSubmissionEngineClassName = oldContext.getString("org.apache.sqoop.submission.engine");
        if (!newSubmissionEngineClassName.equals(oldSubmissionEngineClassName)) {
            LOG.warn((Object)"Submission engine cannot be replaced at the runtime. You might need to restart the server.");
        }
        if ((newExecutionEngineClassName = newContext.getString("org.apache.sqoop.execution.engine")) == null || newExecutionEngineClassName.trim().length() == 0) {
            throw new SqoopException((ErrorCode)DriverError.DRIVER_0007, newExecutionEngineClassName);
        }
        String oldExecutionEngineClassName = oldContext.getString("org.apache.sqoop.execution.engine");
        if (!newExecutionEngineClassName.equals(oldExecutionEngineClassName)) {
            LOG.warn((Object)"Execution engine cannot be replaced at the runtime. You might need to restart the server.");
        }
        this.purgeThreshold = newContext.getLong("org.apache.sqoop.submission.purge.threshold", 86400000L);
        this.purgeSleep = newContext.getLong("org.apache.sqoop.submission.purge.sleep", 86400000L);
        this.purgeThread.interrupt();
        this.updateSleep = newContext.getLong("org.apache.sqoop.submission.update.sleep", 300000L);
        this.updateThread.interrupt();
        LOG.info((Object)"Submission engine manager reconfigured.");
    }

    private class UpdateThread
    extends Thread {
        public UpdateThread() {
            super("UpdateThread");
        }

        @Override
        public void run() {
            LOG.info((Object)"Starting submission manager update thread");
            while (JobManager.this.running) {
                try {
                    LOG.debug((Object)"Updating running submissions");
                    List<MSubmission> unfinishedSubmissions = RepositoryManager.getInstance().getRepository().findUnfinishedSubmissions();
                    for (MSubmission submission : unfinishedSubmissions) {
                        JobManager.this.updateSubmission(submission);
                    }
                    Thread.sleep(JobManager.this.updateSleep);
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)"Purge thread interrupted", (Throwable)e);
                }
            }
            LOG.info((Object)"Ending submission manager update thread");
        }
    }

    private class PurgeThread
    extends Thread {
        public PurgeThread() {
            super("PurgeThread");
        }

        @Override
        public void run() {
            LOG.info((Object)"Starting submission manager purge thread");
            while (JobManager.this.running) {
                try {
                    LOG.info((Object)"Purging old submissions");
                    Date threshold = new Date(new Date().getTime() - JobManager.this.purgeThreshold);
                    RepositoryManager.getInstance().getRepository().purgeSubmissions(threshold);
                    Thread.sleep(JobManager.this.purgeSleep);
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)"Purge thread interrupted", (Throwable)e);
                }
            }
            LOG.info((Object)"Ending submission manager purge thread");
        }
    }
}

