/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.driver;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.apache.sqoop.core.Reconfigurable;
import org.apache.sqoop.core.SqoopConfiguration;
import org.apache.sqoop.driver.DriverUpgrader;
import org.apache.sqoop.driver.configuration.JobConfiguration;
import org.apache.sqoop.model.ConfigUtils;
import org.apache.sqoop.model.MDriver;
import org.apache.sqoop.model.MDriverConfig;
import org.apache.sqoop.repository.RepositoryManager;

public class Driver
implements Reconfigurable {
    private static final Logger LOG = Logger.getLogger(Driver.class);
    private static Driver instance = new Driver();
    private MDriver mDriver;
    private final DriverUpgrader driverUpgrader;
    private static final boolean DEFAULT_AUTO_UPGRADE = false;

    public static Driver getInstance() {
        return instance;
    }

    public static void setInstance(Driver newInstance) {
        instance = newInstance;
    }

    public Class getDriverJobConfigurationClass() {
        return JobConfiguration.class;
    }

    public Driver() {
        List driverConfig = ConfigUtils.toConfigs((Class)this.getDriverJobConfigurationClass());
        this.mDriver = new MDriver(new MDriverConfig(driverConfig), "1");
        this.driverUpgrader = new DriverUpgrader();
    }

    public synchronized void initialize() {
        this.initialize(SqoopConfiguration.getInstance().getContext().getBoolean("org.apache.sqoop.driver.autoupgrade", false));
    }

    public synchronized void initialize(boolean autoUpgrade) {
        LOG.trace((Object)"Begin Driver initialization");
        this.mDriver = RepositoryManager.getInstance().getRepository().registerDriver(this.mDriver, autoUpgrade);
        SqoopConfiguration.getInstance().getProvider().registerListener(new SqoopConfiguration.CoreConfigurationListener(this));
        LOG.info((Object)"Driver initialized: OK");
    }

    public synchronized void destroy() {
        LOG.trace((Object)"Begin Driver destroy");
    }

    public DriverUpgrader getConfigurableUpgrader() {
        return this.driverUpgrader;
    }

    public MDriver getDriver() {
        return this.mDriver;
    }

    public static String getClassName() {
        return Driver.getInstance().getClass().getSimpleName();
    }

    public ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("driver-config", locale);
    }

    @Override
    public void configurationChanged() {
        LOG.info((Object)"Begin Driver reconfiguring");
        LOG.info((Object)"Driver reconfigured");
    }
}

