/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.core;

import org.apache.log4j.Logger;
import org.apache.sqoop.audit.AuditLoggerManager;
import org.apache.sqoop.connector.ConnectorManager;
import org.apache.sqoop.core.SqoopConfiguration;
import org.apache.sqoop.driver.Driver;
import org.apache.sqoop.driver.JobManager;
import org.apache.sqoop.repository.RepositoryManager;
import org.apache.sqoop.security.AuthenticationManager;
import org.apache.sqoop.security.AuthorizationManager;

public class SqoopServer {
    private static final Logger LOG = Logger.getLogger(SqoopServer.class);

    public static void destroy() {
        LOG.info((Object)"Shutting down Sqoop server");
        JobManager.getInstance().destroy();
        Driver.getInstance().destroy();
        ConnectorManager.getInstance().destroy();
        RepositoryManager.getInstance().destroy();
        AuditLoggerManager.getInstance().destroy();
        AuthorizationManager.getInstance().destroy();
        AuthenticationManager.getInstance().destroy();
        SqoopConfiguration.getInstance().destroy();
        LOG.info((Object)"Sqoop server has been correctly terminated");
    }

    public static void initialize() {
        try {
            LOG.info((Object)"Booting up Sqoop server");
            SqoopConfiguration.getInstance().initialize();
            AuthenticationManager.getInstance().initialize();
            AuthorizationManager.getInstance().initialize();
            AuditLoggerManager.getInstance().initialize();
            RepositoryManager.getInstance().initialize();
            ConnectorManager.getInstance().initialize();
            Driver.getInstance().initialize();
            JobManager.getInstance().initialize();
            LOG.info((Object)"Sqoop server has successfully boot up");
        }
        catch (Exception ex) {
            LOG.error((Object)"Server startup failure", (Throwable)ex);
            throw new RuntimeException("Failure in server initialization", ex);
        }
    }
}

