/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.MapContext;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.core.ConfigurationListener;
import org.apache.sqoop.core.ConfigurationProvider;
import org.apache.sqoop.core.Reconfigurable;
import org.apache.sqoop.error.code.CoreError;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class SqoopConfiguration
implements Reconfigurable {
    public static final Logger LOG = Logger.getLogger(SqoopConfiguration.class);
    private static SqoopConfiguration instance = new SqoopConfiguration();
    private File configDir = null;
    private boolean initialized = false;
    private ConfigurationProvider provider = null;
    private Map<String, String> config = null;
    private Map<String, String> oldConfig = null;

    public static SqoopConfiguration getInstance() {
        return instance;
    }

    public static void setInstance(SqoopConfiguration newInstance) {
        instance = newInstance;
    }

    public synchronized void initialize() {
        ClassLoader ctxLoader;
        if (this.initialized) {
            LOG.warn((Object)"Attempt to reinitialize the system, ignoring");
            return;
        }
        String configDirPath = System.getProperty("sqoop.config.dir");
        if (configDirPath == null || configDirPath.trim().length() == 0) {
            throw new SqoopException((ErrorCode)CoreError.CORE_0001, "Environment variable sqoop.config.dir is not set.");
        }
        this.configDir = new File(configDirPath);
        if (!this.configDir.exists() || !this.configDir.isDirectory()) {
            throw new SqoopException((ErrorCode)CoreError.CORE_0001, configDirPath);
        }
        String bootstrapConfigFilePath = null;
        try {
            String configDirCanonicalPath = this.configDir.getCanonicalPath();
            bootstrapConfigFilePath = configDirCanonicalPath + "/" + "sqoop_bootstrap.properties";
        }
        catch (IOException ex) {
            throw new SqoopException((ErrorCode)CoreError.CORE_0001, configDirPath, (Throwable)ex);
        }
        File bootstrapConfig = new File(bootstrapConfigFilePath);
        if (!(bootstrapConfig.exists() && bootstrapConfig.isFile() && bootstrapConfig.canRead())) {
            throw new SqoopException((ErrorCode)CoreError.CORE_0002, bootstrapConfigFilePath);
        }
        Properties bootstrapProperties = new Properties();
        FileInputStream bootstrapPropStream = null;
        try {
            bootstrapPropStream = new FileInputStream(bootstrapConfig);
            bootstrapProperties.load(bootstrapPropStream);
        }
        catch (IOException ex) {
            throw new SqoopException((ErrorCode)CoreError.CORE_0002, bootstrapConfigFilePath, (Throwable)ex);
        }
        String configProviderClassName = bootstrapProperties.getProperty("sqoop.config.provider");
        if (configProviderClassName == null || configProviderClassName.trim().length() == 0) {
            throw new SqoopException((ErrorCode)CoreError.CORE_0003, "sqoop.config.provider");
        }
        Class<?> configProviderClass = null;
        try {
            configProviderClass = Class.forName(configProviderClassName);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.warn((Object)"Exception while trying to load configuration provider", (Throwable)cnfe);
        }
        if (configProviderClass == null && (ctxLoader = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                configProviderClass = ctxLoader.loadClass(configProviderClassName);
            }
            catch (ClassNotFoundException cnfe) {
                LOG.warn((Object)("Exception while trying to load configuration provider: " + configProviderClassName), (Throwable)cnfe);
            }
        }
        if (configProviderClass == null) {
            throw new SqoopException((ErrorCode)CoreError.CORE_0004, configProviderClassName);
        }
        try {
            this.provider = (ConfigurationProvider)configProviderClass.newInstance();
        }
        catch (Exception ex) {
            throw new SqoopException((ErrorCode)CoreError.CORE_0005, configProviderClassName, (Throwable)ex);
        }
        this.provider.initialize(this.configDir, bootstrapProperties);
        this.configurationChanged();
        this.provider.registerListener(new CoreConfigurationListener(SqoopConfiguration.getInstance()));
        this.initialized = true;
    }

    public synchronized MapContext getContext() {
        if (!this.initialized) {
            throw new SqoopException((ErrorCode)CoreError.CORE_0007);
        }
        return new MapContext(this.config);
    }

    public synchronized MapContext getOldContext() {
        if (!this.initialized) {
            throw new SqoopException((ErrorCode)CoreError.CORE_0007);
        }
        if (this.oldConfig == null) {
            throw new SqoopException((ErrorCode)CoreError.CORE_0008);
        }
        return new MapContext(this.oldConfig);
    }

    public synchronized void destroy() {
        if (this.provider != null) {
            try {
                this.provider.destroy();
            }
            catch (Exception ex) {
                LOG.error((Object)"Failed to shutdown configuration provider", (Throwable)ex);
            }
        }
        this.provider = null;
        this.configDir = null;
        this.config = null;
        this.oldConfig = null;
        this.initialized = false;
    }

    private synchronized void configureLogging() {
        Properties props = new Properties();
        for (String key : this.config.keySet()) {
            if (!key.startsWith("org.apache.sqoop.log4j.")) continue;
            String logConfigKey = key.substring("org.apache.sqoop.".length());
            props.put(logConfigKey, this.config.get(key));
        }
        PropertyConfigurator.configure((Properties)props);
    }

    public ConfigurationProvider getProvider() {
        return this.provider;
    }

    @Override
    public synchronized void configurationChanged() {
        this.oldConfig = this.config;
        this.config = this.provider.getConfiguration();
        this.configureLogging();
    }

    public static class CoreConfigurationListener
    implements ConfigurationListener {
        private Reconfigurable listener;

        public CoreConfigurationListener(Reconfigurable target) {
            this.listener = target;
        }

        @Override
        public void configurationChanged() {
            this.listener.configurationChanged();
        }
    }
}

