/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.core.ConfigurationListener;
import org.apache.sqoop.core.ConfigurationProvider;
import org.apache.sqoop.error.code.CoreError;

public class PropertiesConfigurationProvider
implements ConfigurationProvider {
    private static final Logger LOG = Logger.getLogger(PropertiesConfigurationProvider.class);
    public static final String CONFIG_FILENAME = "sqoop.properties";
    public static final long DEFAULT_SLEEP_TIME = 60000L;
    private Map<String, String> configuration = new HashMap<String, String>();
    private List<ConfigurationListener> listeners = new ArrayList<ConfigurationListener>();
    private File configFile;
    private ConfigFilePoller poller;

    @Override
    public synchronized void registerListener(ConfigurationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized Map<String, String> getConfiguration() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.putAll(this.configuration);
        return config;
    }

    @Override
    public synchronized void destroy() {
        LOG.info((Object)"Shutting down configuration poller thread");
        if (this.poller != null) {
            this.poller.setShutdown();
            this.poller.interrupt();
            try {
                this.poller.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.poller = null;
    }

    @Override
    public synchronized void initialize(File configDir, Properties bootstrapConfiguration) {
        this.configFile = new File(configDir, CONFIG_FILENAME);
        if (!(this.configFile.exists() && this.configFile.isFile() && this.configFile.canRead())) {
            throw new SqoopException((ErrorCode)CoreError.CORE_0006, this.configFile.getPath());
        }
        this.loadConfiguration(false);
        this.poller = new ConfigFilePoller(this.configFile);
        LOG.info((Object)"Starting config file poller thread");
        this.poller.start();
    }

    private synchronized void loadConfiguration(boolean notifyListeners) {
        Properties configProperties = new Properties();
        InputStream fis = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(this.configFile));
            configProperties.load(fis);
        }
        catch (Exception ex) {
            throw new SqoopException((ErrorCode)CoreError.CORE_0006, this.configFile.getPath(), (Throwable)ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    LOG.error((Object)"Failed to close file stream for configuration", (Throwable)ex);
                }
            }
        }
        this.configuration.clear();
        Enumeration<?> propNameEnum = configProperties.propertyNames();
        while (propNameEnum.hasMoreElements()) {
            String name = (String)propNameEnum.nextElement();
            this.configuration.put(name, configProperties.getProperty(name));
        }
        if (notifyListeners) {
            for (ConfigurationListener configListener : this.listeners) {
                configListener.configurationChanged();
            }
        }
    }

    private class ConfigFilePoller
    extends Thread {
        private File file;
        private long lastUpdatedAt;
        private boolean shutdown;
        private long sleepTime;

        ConfigFilePoller(File configFile) {
            this.file = configFile;
            this.lastUpdatedAt = configFile.lastModified();
            this.setName("sqoop-config-file-poller");
            this.setDaemon(true);
            this.loadSleepTime();
        }

        synchronized void setShutdown() {
            this.shutdown = true;
        }

        private synchronized boolean isShutdown() {
            return this.shutdown;
        }

        private synchronized void loadSleepTime() {
            try {
                String value = (String)PropertiesConfigurationProvider.this.configuration.get("org.apache.sqoop.core.configuration.provider.properties.sleep");
                this.sleepTime = Long.valueOf(value);
            }
            catch (Exception e) {
                LOG.debug((Object)"Can't load sleeping period from configuration file, using default value 60000", (Throwable)e);
                this.sleepTime = 60000L;
            }
        }

        @Override
        public void run() {
            do {
                LOG.trace((Object)("Checking config file for changes: " + this.file));
                if (this.file.lastModified() > this.lastUpdatedAt) {
                    LOG.info((Object)"Configuration file change detected, attempting to load");
                    try {
                        this.lastUpdatedAt = this.file.lastModified();
                        PropertiesConfigurationProvider.this.loadConfiguration(true);
                        this.loadSleepTime();
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Exception while loading configuration", (Throwable)ex);
                    }
                }
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            } while (!this.isShutdown());
        }
    }
}

