/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.connector;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang.StringUtils;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.connector.ConnectorManager;
import org.apache.sqoop.error.code.ConnectorError;

public class ConnectorManagerUtils {
    public static List<URL> getConnectorConfigs() {
        ArrayList<URL> connectorConfigs = new ArrayList<URL>();
        try {
            Enumeration<URL> appPathConfigs = ConnectorManager.class.getClassLoader().getResources("sqoopconnector.properties");
            while (appPathConfigs.hasMoreElements()) {
                connectorConfigs.add(appPathConfigs.nextElement());
            }
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            if (ctxLoader != null) {
                Enumeration<URL> ctxPathConfigs = ctxLoader.getResources("sqoopconnector.properties");
                while (ctxPathConfigs.hasMoreElements()) {
                    URL configUrl = ctxPathConfigs.nextElement();
                    if (connectorConfigs.contains(configUrl)) continue;
                    connectorConfigs.add(configUrl);
                }
            }
        }
        catch (IOException ex) {
            throw new SqoopException((ErrorCode)ConnectorError.CONN_0001, (Throwable)ex);
        }
        return connectorConfigs;
    }

    public static Set<File> getConnectorJars(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        HashSet<File> jarFiles = new HashSet<File>();
        File folder = new File(path);
        if (folder.exists()) {
            for (File file : folder.listFiles()) {
                if (file.isDirectory()) {
                    jarFiles.addAll(ConnectorManagerUtils.getConnectorJars(file.getPath()));
                }
                if (!file.getName().endsWith(".jar") || !ConnectorManagerUtils.isConnectorJar(file)) continue;
                jarFiles.add(file);
            }
        }
        return jarFiles;
    }

    static boolean isConnectorJar(File file) {
        try {
            JarEntry entry = new JarFile(file).getJarEntry("sqoopconnector.properties");
            return entry != null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addExternalConnectorsJarsToClasspath(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return;
        }
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        if (currentThreadClassLoader != null) {
            ExternalConnectorJarFileLoader connectorUrlClassLoader = new ExternalConnectorJarFileLoader(new URL[0], currentThreadClassLoader);
            Set<File> connectorJars = ConnectorManagerUtils.getConnectorJars(path);
            if (connectorJars != null && !connectorJars.isEmpty()) {
                for (File jar : connectorJars) {
                    connectorUrlClassLoader.addJarFile(jar.getPath());
                }
                Thread.currentThread().setContextClassLoader(connectorUrlClassLoader);
            }
        }
    }

    public static class ExternalConnectorJarFileLoader
    extends URLClassLoader {
        public ExternalConnectorJarFileLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public void addJarFile(String path) {
            String urlPath = "jar:file://" + path + "!/";
            try {
                this.addURL(new URL(urlPath));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

