/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.connector;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.connector.ConnectorHandler;
import org.apache.sqoop.connector.ConnectorManagerUtils;
import org.apache.sqoop.connector.spi.SqoopConnector;
import org.apache.sqoop.core.Reconfigurable;
import org.apache.sqoop.core.SqoopConfiguration;
import org.apache.sqoop.error.code.CommonRepositoryError;
import org.apache.sqoop.error.code.ConnectorError;
import org.apache.sqoop.model.MConnector;
import org.apache.sqoop.repository.Repository;
import org.apache.sqoop.repository.RepositoryManager;
import org.apache.sqoop.repository.RepositoryTransaction;

public class ConnectorManager
implements Reconfigurable {
    private static final Logger LOG = Logger.getLogger(ConnectorManager.class);
    private static ConnectorManager instance;
    private static boolean DEFAULT_AUTO_UPGRADE;
    private Map<Long, String> idToNameMap = new HashMap<Long, String>();
    private Set<String> connectorNames = new HashSet<String>();
    private Map<String, ConnectorHandler> handlerMap = new HashMap<String, ConnectorHandler>();

    public static ConnectorManager getInstance() {
        return instance;
    }

    public static void setInstance(ConnectorManager newInstance) {
        instance = newInstance;
    }

    public List<MConnector> getConnectorConfigurables() {
        LinkedList<MConnector> connectors = new LinkedList<MConnector>();
        for (ConnectorHandler handler : this.handlerMap.values()) {
            connectors.add(handler.getConnectorConfigurable());
        }
        return connectors;
    }

    public Set<Long> getConnectorIds() {
        return this.idToNameMap.keySet();
    }

    public Set<String> getConnectorNames() {
        return this.connectorNames;
    }

    public Map<Long, ResourceBundle> getResourceBundles(Locale locale) {
        HashMap<Long, ResourceBundle> bundles = new HashMap<Long, ResourceBundle>();
        for (ConnectorHandler handler : this.handlerMap.values()) {
            long id = handler.getConnectorConfigurable().getPersistenceId();
            ResourceBundle bundle = handler.getSqoopConnector().getBundle(locale);
            bundles.put(id, bundle);
        }
        return bundles;
    }

    public ResourceBundle getResourceBundle(long connectorId, Locale locale) {
        ConnectorHandler handler = this.handlerMap.get(this.idToNameMap.get(connectorId));
        return handler.getSqoopConnector().getBundle(locale);
    }

    public MConnector getConnectorConfigurable(long connectorId) {
        ConnectorHandler handler = this.handlerMap.get(this.idToNameMap.get(connectorId));
        if (handler == null) {
            throw new SqoopException((ErrorCode)CommonRepositoryError.COMMON_0057, "Couldn't find connector with id " + connectorId);
        }
        return handler.getConnectorConfigurable();
    }

    public MConnector getConnectorConfigurable(String connectorName) {
        ConnectorHandler handler = this.handlerMap.get(connectorName);
        if (handler == null) {
            return null;
        }
        return handler.getConnectorConfigurable();
    }

    public SqoopConnector getSqoopConnector(long connectorId) {
        ConnectorHandler handler = this.handlerMap.get(this.idToNameMap.get(connectorId));
        return handler.getSqoopConnector();
    }

    public SqoopConnector getSqoopConnector(String uniqueName) {
        return this.handlerMap.get(uniqueName).getSqoopConnector();
    }

    public synchronized void initialize() {
        this.initialize(SqoopConfiguration.getInstance().getContext().getBoolean("org.apache.sqoop.connector.autoupgrade", DEFAULT_AUTO_UPGRADE));
    }

    public synchronized void initialize(boolean autoUpgrade) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Begin connector manager initialization");
        }
        ConnectorManagerUtils.addExternalConnectorsJarsToClasspath(SqoopConfiguration.getInstance().getContext().getString("org.apache.sqoop.connector.external.loadpath", ""));
        List<URL> connectorConfigs = ConnectorManagerUtils.getConnectorConfigs();
        LOG.info((Object)("Connector config urls: " + connectorConfigs));
        if (connectorConfigs.size() == 0) {
            throw new SqoopException((ErrorCode)ConnectorError.CONN_0002);
        }
        for (URL url : connectorConfigs) {
            ConnectorHandler handler = new ConnectorHandler(url);
            ConnectorHandler handlerOld = this.handlerMap.put(handler.getUniqueName(), handler);
            if (handlerOld == null) continue;
            throw new SqoopException((ErrorCode)ConnectorError.CONN_0006, handler + ", " + handlerOld);
        }
        this.registerConnectors(autoUpgrade);
        SqoopConfiguration.getInstance().getProvider().registerListener(new SqoopConfiguration.CoreConfigurationListener(this));
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Connectors loaded: " + this.handlerMap));
        }
    }

    public synchronized Long getConnectorId(String connectorName) {
        Repository repository = RepositoryManager.getInstance().getRepository();
        return repository.findConnector(connectorName) != null ? Long.valueOf(repository.findConnector(connectorName).getPersistenceId()) : null;
    }

    private synchronized void registerConnectors(boolean autoUpgrade) {
        Repository repository = RepositoryManager.getInstance().getRepository();
        RepositoryTransaction rtx = null;
        try {
            rtx = repository.getTransaction();
            rtx.begin();
            for (String name : this.handlerMap.keySet()) {
                ConnectorHandler handler = this.handlerMap.get(name);
                MConnector newConnector = handler.getConnectorConfigurable();
                MConnector registeredConnector = repository.registerConnector(newConnector, autoUpgrade);
                handler.setConnectorConfigurable(registeredConnector);
                String connectorName = handler.getUniqueName();
                if (!handler.getConnectorConfigurable().hasPersistenceId()) {
                    throw new SqoopException((ErrorCode)ConnectorError.CONN_0010, connectorName);
                }
                this.idToNameMap.put(handler.getConnectorConfigurable().getPersistenceId(), connectorName);
                this.connectorNames.add(connectorName);
                LOG.debug((Object)("Registered connector: " + handler.getConnectorConfigurable()));
            }
            rtx.commit();
        }
        catch (Exception ex) {
            if (rtx != null) {
                rtx.rollback();
            }
            throw new SqoopException((ErrorCode)ConnectorError.CONN_0007, (Throwable)ex);
        }
        finally {
            if (rtx != null) {
                rtx.close();
            }
        }
    }

    public synchronized void destroy() {
        this.handlerMap = null;
        this.idToNameMap = null;
    }

    @Override
    public synchronized void configurationChanged() {
        LOG.info((Object)"Begin connector manager reconfiguring");
        LOG.info((Object)"Connector manager reconfigured");
    }

    static {
        DEFAULT_AUTO_UPGRADE = false;
        instance = new ConnectorManager();
    }
}

