/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.connector;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.Direction;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.connector.spi.SqoopConnector;
import org.apache.sqoop.error.code.ConnectorError;
import org.apache.sqoop.model.ConfigUtils;
import org.apache.sqoop.model.MConnector;
import org.apache.sqoop.model.MFromConfig;
import org.apache.sqoop.model.MLinkConfig;
import org.apache.sqoop.model.MToConfig;
import org.apache.sqoop.utils.ClassUtils;

public final class ConnectorHandler {
    private static final Logger LOG = Logger.getLogger(ConnectorHandler.class);
    private final Properties properties = new Properties();
    private final String connectorUrl;
    private final String connectorClassName;
    private final String connectorUniqueName;
    private final SqoopConnector connector;
    private MConnector connectorConfigurable;

    public ConnectorHandler(URL configFileUrl) {
        this.connectorUrl = configFileUrl.toString();
        try {
            this.properties.load(configFileUrl.openStream());
        }
        catch (IOException ex) {
            throw new SqoopException((ErrorCode)ConnectorError.CONN_0003, configFileUrl.toString(), (Throwable)ex);
        }
        LOG.debug((Object)("Connector configuration: " + this.properties));
        this.connectorClassName = this.properties.getProperty("org.apache.sqoop.connector.class");
        if (this.connectorClassName == null || this.connectorClassName.trim().length() == 0) {
            throw new SqoopException((ErrorCode)ConnectorError.CONN_0004, "org.apache.sqoop.connector.class");
        }
        this.connectorUniqueName = this.properties.getProperty("org.apache.sqoop.connector.name");
        if (this.connectorUniqueName == null || this.connectorUniqueName.trim().length() == 0) {
            throw new SqoopException((ErrorCode)ConnectorError.CONN_0008, this.connectorClassName);
        }
        Class connectorClass = ClassUtils.loadClass((String)this.connectorClassName);
        if (connectorClass == null) {
            throw new SqoopException((ErrorCode)ConnectorError.CONN_0005, this.connectorClassName);
        }
        try {
            this.connector = (SqoopConnector)connectorClass.newInstance();
        }
        catch (IllegalAccessException ex) {
            throw new SqoopException((ErrorCode)ConnectorError.CONN_0005, this.connectorClassName, (Throwable)ex);
        }
        catch (InstantiationException ex) {
            throw new SqoopException((ErrorCode)ConnectorError.CONN_0005, this.connectorClassName, (Throwable)ex);
        }
        MFromConfig fromConfig = null;
        MToConfig toConfig = null;
        if (this.connector.getSupportedDirections().contains(Direction.FROM)) {
            fromConfig = new MFromConfig(ConfigUtils.toConfigs((Class)this.connector.getJobConfigurationClass(Direction.FROM)));
        }
        if (this.connector.getSupportedDirections().contains(Direction.TO)) {
            toConfig = new MToConfig(ConfigUtils.toConfigs((Class)this.connector.getJobConfigurationClass(Direction.TO)));
        }
        MLinkConfig linkConfig = new MLinkConfig(ConfigUtils.toConfigs((Class)this.connector.getLinkConfigurationClass()));
        this.connectorConfigurable = new MConnector(this.connectorUniqueName, this.connectorClassName, this.connector.getVersion(), linkConfig, fromConfig, toConfig);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Connector [" + this.connectorClassName + "] initialized."));
        }
    }

    public String toString() {
        return "{" + this.connectorUniqueName + ":" + this.connectorClassName + ":" + this.connectorUrl + "}";
    }

    public String getUniqueName() {
        return this.connectorUniqueName;
    }

    public String getConnectorClassName() {
        return this.connectorClassName;
    }

    public String getConnectorUrl() {
        return this.connectorUrl;
    }

    public MConnector getConnectorConfigurable() {
        return this.connectorConfigurable;
    }

    public void setConnectorConfigurable(MConnector mConnector) {
        this.connectorConfigurable = mConnector;
    }

    public SqoopConnector getSqoopConnector() {
        return this.connector;
    }
}

