/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.audit;

import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.sqoop.audit.AuditLogger;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.error.code.AuditLoggerError;

public class FileAuditLogger
extends AuditLogger {
    private Logger LOG = Logger.getLogger(FileAuditLogger.class);
    private static final String APPENDER_SURFIX = "Appender";
    private static final String FILE = "file";
    private Logger logger;
    private Map<String, String> config;
    private Properties props = new Properties();

    @Override
    public void initialize() {
        this.config = this.getLoggerConfig();
        String outputFile = this.config.get(FILE);
        if (outputFile == null) {
            throw new SqoopException((ErrorCode)AuditLoggerError.AUDIT_0002);
        }
        String appender = "log4j.appender." + this.getLoggerName() + APPENDER_SURFIX;
        this.LOG.warn((Object)("appender: " + appender));
        this.props.put(appender, "org.apache.log4j.RollingFileAppender");
        this.props.put(appender + ".File", outputFile);
        this.props.put(appender + ".layout", "org.apache.log4j.PatternLayout");
        this.props.put(appender + ".layout.ConversionPattern", "%d %-5p %c: %m%n");
        this.props.put("log4j.logger." + this.getLoggerName(), "INFO," + this.getLoggerName() + APPENDER_SURFIX);
        PropertyConfigurator.configure((Properties)this.props);
        this.logger = Logger.getLogger((String)this.getLoggerName());
    }

    @Override
    public void logAuditEvent(String username, String ip, String operation, String objectType, String objectId) {
        StringBuilder sentence = new StringBuilder();
        sentence.append("user=").append(username).append("\t");
        sentence.append("ip=").append(ip).append("\t");
        sentence.append("op=").append(operation).append("\t");
        sentence.append("obj=").append(objectType).append("\t");
        sentence.append("objId=").append(objectId);
        this.logger.info((Object)sentence.toString());
    }
}

