/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.audit;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.sqoop.audit.AuditLogger;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.MapContext;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.core.Reconfigurable;
import org.apache.sqoop.core.SqoopConfiguration;
import org.apache.sqoop.error.code.AuditLoggerError;
import org.apache.sqoop.utils.ClassUtils;

public class AuditLoggerManager
implements Reconfigurable {
    private static final Logger LOG = Logger.getLogger(AuditLoggerManager.class);
    private List<AuditLogger> loggers = new ArrayList<AuditLogger>();
    private static AuditLoggerManager instance = new AuditLoggerManager();

    public static AuditLoggerManager getInstance() {
        return instance;
    }

    public void setInstance(AuditLoggerManager newInstance) {
        instance = newInstance;
    }

    public synchronized void initialize() {
        LOG.info((Object)"Begin audit logger manager initialization");
        this.initializeLoggers();
        SqoopConfiguration.getInstance().getProvider().registerListener(new SqoopConfiguration.CoreConfigurationListener(this));
        LOG.info((Object)"Audit logger manager initialized: OK");
    }

    private void initializeLoggers() {
        this.loggers.clear();
        MapContext context = SqoopConfiguration.getInstance().getContext();
        Map auditLoggerProps = context.getNestedProperties("org.apache.sqoop.auditlogger.");
        for (String key : auditLoggerProps.keySet()) {
            AuditLogger newLogger;
            if (!key.endsWith(".class")) continue;
            String loggerName = key.substring(0, key.indexOf("."));
            String loggerClassName = (String)auditLoggerProps.get(key);
            if (loggerClassName == null || loggerClassName.trim().length() == 0) {
                throw new SqoopException((ErrorCode)AuditLoggerError.AUDIT_0001, "Logger name: " + loggerName);
            }
            Class loggerClass = ClassUtils.loadClass((String)loggerClassName);
            if (loggerClass == null) {
                throw new SqoopException((ErrorCode)AuditLoggerError.AUDIT_0001, "Logger Class: " + loggerClassName);
            }
            try {
                newLogger = (AuditLogger)loggerClass.newInstance();
            }
            catch (Exception ex) {
                throw new SqoopException((ErrorCode)AuditLoggerError.AUDIT_0001, "Logger Class: " + loggerClassName, (Throwable)ex);
            }
            newLogger.setLoggerName(loggerName);
            newLogger.initialize();
            this.loggers.add(newLogger);
            LOG.info((Object)("Audit Logger has been initialized: " + loggerName));
        }
    }

    public synchronized void destroy() {
        LOG.trace((Object)"Begin audit logger manager destroy");
    }

    public void logAuditEvent(String username, String ip, String operation, String objectType, String objectId) {
        for (AuditLogger logger : this.loggers) {
            logger.logAuditEvent(username, ip, operation, objectType, objectId);
        }
    }

    @Override
    public void configurationChanged() {
        LOG.info((Object)"Begin audit logger manager reconfiguring");
        this.initializeLoggers();
        LOG.info((Object)"Audit logger manager reconfigured");
    }
}

