/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.common.utils;

import com.google.common.base.Strings;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathUtils.class);
    private static String LOCAL_FILE_SCHEMA = "file";
    private static String AUTHORITY_PREFIX = "://";

    public static boolean impliesURI(URI privilegeURI, URI requestURI) throws URISyntaxException {
        if (privilegeURI.getPath() == null || requestURI.getPath() == null) {
            return false;
        }
        if (privilegeURI.getScheme() == null ? requestURI.getScheme() != null : !privilegeURI.getScheme().equals(requestURI.getScheme())) {
            return false;
        }
        String requestPath = PathUtils.ensureEndsWithSeparator(requestURI.getPath()).replace("//", "/");
        String privilegePath = PathUtils.ensureEndsWithSeparator(privilegeURI.getPath()).replace("//", "/");
        return requestURI.getPath().equals(requestURI.normalize().getPath()) && requestPath.startsWith(privilegePath) && Strings.nullToEmpty((String)privilegeURI.getAuthority()).equals(Strings.nullToEmpty((String)requestURI.getAuthority()));
    }

    public static boolean impliesURI(String privilege, String request) {
        try {
            URI privilegeURI = new URI(new StrSubstitutor((Map)System.getProperties()).replace(privilege));
            URI requestURI = new URI(request);
            if (privilegeURI.getScheme() == null || privilegeURI.getPath() == null) {
                LOGGER.warn("Privilege URI " + request + " is not valid. Either no scheme or no path.");
                return false;
            }
            if (requestURI.getScheme() == null || requestURI.getPath() == null) {
                LOGGER.warn("Request URI " + request + " is not valid. Either no scheme or no path.");
                return false;
            }
            return PathUtils.impliesURI(privilegeURI, requestURI);
        }
        catch (URISyntaxException e) {
            LOGGER.warn("Request URI " + request + " is not a URI", (Throwable)e);
            return false;
        }
    }

    private static String ensureEndsWithSeparator(String path) {
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separator;
    }

    public static String parseDFSURI(String warehouseDir, String uri) throws URISyntaxException {
        return PathUtils.parseURI(warehouseDir, uri, false);
    }

    public static String parseURI(String warehouseDir, String uri, boolean isLocal) throws URISyntaxException {
        String uriAuthority;
        String uriScheme;
        Path warehouseDirPath = new Path(warehouseDir);
        Path uriPath = new Path(uri);
        if (uriPath.isAbsolute()) {
            if (uriPath.isAbsoluteAndSchemeAuthorityNull()) {
                uriPath = uriPath.makeQualified(warehouseDirPath.toUri(), warehouseDirPath);
            }
            uriScheme = uriPath.toUri().getScheme();
            uriAuthority = uriPath.toUri().getAuthority();
            if (StringUtils.isEmpty((String)uriScheme) || isLocal) {
                uriScheme = LOCAL_FILE_SCHEMA;
                uriAuthority = "";
            }
        } else {
            throw new IllegalArgumentException("Invalid URI " + uri + ".");
        }
        uriPath = new Path(uriScheme + AUTHORITY_PREFIX + StringUtils.trimToEmpty((String)uriAuthority) + Path.getPathWithoutSchemeAndAuthority((Path)uriPath));
        return uriPath.toUri().toString();
    }

    public static String parseLocalURI(String uri) throws URISyntaxException {
        Path uriPath = new Path(uri);
        if (!uriPath.isAbsolute()) {
            throw new IllegalArgumentException("Parse URI does not work on relative URI: " + uri);
        }
        uriPath = new Path(LOCAL_FILE_SCHEMA + AUTHORITY_PREFIX + StringUtils.trimToEmpty((String)uriPath.toUri().getAuthority()) + Path.getPathWithoutSchemeAndAuthority((Path)uriPath));
        return uriPath.toUri().toString();
    }
}

