/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.common;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;

public class ActiveRoleSet {
    public static final ActiveRoleSet ALL = new ActiveRoleSet(true);
    private final boolean allRoles;
    private final ImmutableSet<String> roles;

    public ActiveRoleSet(boolean allRoles) {
        this(allRoles, new HashSet<String>());
    }

    public ActiveRoleSet(Set<String> roles) {
        this(false, (Set<String>)ImmutableSet.copyOf(roles));
    }

    private ActiveRoleSet(boolean allRoles, Set<String> roles) {
        this.allRoles = allRoles;
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (String role : roles) {
            setBuilder.add((Object)role.toLowerCase());
        }
        this.roles = setBuilder.build();
    }

    public boolean containsRole(String role) {
        return this.allRoles || this.roles.contains((Object)role.toLowerCase());
    }

    public boolean isAll() {
        return this.allRoles;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ActiveRoleSet = [ roles = ");
        if (this.allRoles) {
            builder.append("ALL");
        } else {
            builder.append(this.roles);
        }
        return builder.append(" ").toString();
    }
}

