/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.webapp.AppBlock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class RMAppBlock
extends AppBlock {
    private final ResourceManager rm;

    @Inject
    RMAppBlock(View.ViewContext ctx, Configuration conf, ResourceManager rm) {
        super((ApplicationBaseProtocol)rm.getClientRMService(), ctx, conf);
        this.rm = rm;
    }

    protected void render(HtmlBlock.Block html) {
        super.render(html);
    }

    protected void createApplicationMetricsTable(HtmlBlock.Block html) {
        RMApp rmApp = (RMApp)this.rm.getRMContext().getRMApps().get(this.appID);
        RMAppMetrics appMetrics = rmApp == null ? null : rmApp.getRMAppMetrics();
        RMAppAttemptMetrics attemptMetrics = rmApp == null || null == rmApp.getCurrentAppAttempt() ? null : rmApp.getCurrentAppAttempt().getRMAppAttemptMetrics();
        Resource attemptResourcePreempted = attemptMetrics == null ? Resources.none() : attemptMetrics.getResourcePreempted();
        int attemptNumNonAMContainerPreempted = attemptMetrics == null ? 0 : attemptMetrics.getNumNonAMContainersPreempted();
        Hamlet.DIV pdiv = html._(InfoBlock.class).div(".info-wrap.ui-widget-content.ui-corner-bottom");
        this.info("Application Overview").clear();
        this.info("Application Metrics")._("Total Resource Preempted:", (Object)(appMetrics == null ? "N/A" : appMetrics.getResourcePreempted()))._("Total Number of Non-AM Containers Preempted:", appMetrics == null ? "N/A" : Integer.valueOf(appMetrics.getNumNonAMContainersPreempted()))._("Total Number of AM Containers Preempted:", appMetrics == null ? "N/A" : Integer.valueOf(appMetrics.getNumAMContainersPreempted()))._("Resource Preempted from Current Attempt:", (Object)attemptResourcePreempted)._("Number of Non-AM Containers Preempted from Current Attempt:", (Object)attemptNumNonAMContainerPreempted)._("Aggregate Resource Allocation:", (Object)String.format("%d MB-seconds, %d vcore-seconds", appMetrics == null ? "N/A" : Long.valueOf(appMetrics.getMemorySeconds()), appMetrics == null ? "N/A" : Long.valueOf(appMetrics.getVcoreSeconds())));
        pdiv._();
    }
}

