/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.java.dev.eval.Expression;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ParentQueue
extends AbstractCSQueue {
    private static final Log LOG = LogFactory.getLog(ParentQueue.class);
    protected final Set<CSQueue> childQueues;
    private final boolean rootQueue;
    final Comparator<CSQueue> queueComparator;
    volatile int numApplications;
    private final CapacitySchedulerContext scheduler;
    private Expression label;
    private Queue.QueueLabelPolicy labelPolicy;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private static float PRECISION = 5.0E-4f;

    public ParentQueue(CapacitySchedulerContext cs, String queueName, CSQueue parent, CSQueue old) throws IOException {
        super(cs, queueName, parent, old);
        this.scheduler = cs;
        this.queueComparator = cs.getQueueComparator();
        this.rootQueue = parent == null;
        float rawCapacity = cs.getConfiguration().getNonLabeledQueueCapacity(this.getQueuePath());
        if (this.rootQueue && rawCapacity != 100.0f) {
            throw new IllegalArgumentException("Illegal capacity of " + rawCapacity + " for queue " + queueName + ". Must be " + 100.0f);
        }
        this.childQueues = new TreeSet<CSQueue>(this.queueComparator);
        this.setupQueueConfigs(cs.getClusterResource());
        LOG.info((Object)("Initialized parent-queue " + queueName + " name=" + queueName + ", fullname=" + this.getQueuePath()));
    }

    @Override
    synchronized void setupQueueConfigs(Resource clusterResource) throws IOException {
        super.setupQueueConfigs(clusterResource);
        StringBuilder aclsString = new StringBuilder();
        for (Map.Entry e : this.acls.entrySet()) {
            aclsString.append(e.getKey() + ":" + ((AccessControlList)e.getValue()).getAclString());
        }
        this.label = this.refreshLabel();
        this.labelPolicy = this.refreshLabelPolicy();
        StringBuilder labelStrBuilder = new StringBuilder();
        if (this.accessibleLabels != null) {
            for (String s : this.accessibleLabels) {
                labelStrBuilder.append(s);
                labelStrBuilder.append(",");
            }
        }
        LOG.info((Object)(this.queueName + ", capacity=" + this.queueCapacities.getCapacity() + ", asboluteCapacity=" + this.queueCapacities.getAbsoluteCapacity() + ", maxCapacity=" + this.queueCapacities.getMaximumCapacity() + ", asboluteMaxCapacity=" + this.queueCapacities.getAbsoluteMaximumCapacity() + ", state=" + this.state + ", acls=" + aclsString + ", labels=" + labelStrBuilder.toString() + "\n" + ", reservationsContinueLooking=" + this.reservationsContinueLooking));
    }

    synchronized void setChildQueues(Collection<CSQueue> childQueues) {
        float childCapacities = 0.0f;
        for (CSQueue queue : childQueues) {
            childCapacities += queue.getCapacity();
        }
        float delta = Math.abs(1.0f - childCapacities);
        if (this.queueCapacities.getCapacity() > 0.0f && delta > PRECISION || this.queueCapacities.getCapacity() == 0.0f && childCapacities > 0.0f) {
            throw new IllegalArgumentException("Illegal capacity of " + childCapacities + " for children of queue " + this.queueName);
        }
        for (String nodeLabel : this.labelManager.getClusterNodeLabels()) {
            float capacityByLabel = this.queueCapacities.getCapacity(nodeLabel);
            float sum = 0.0f;
            for (CSQueue queue : childQueues) {
                sum += queue.getQueueCapacities().getCapacity(nodeLabel);
            }
            if (!(capacityByLabel > 0.0f && Math.abs(1.0f - sum) > PRECISION) && (capacityByLabel != 0.0f || !(sum > 0.0f))) continue;
            throw new IllegalArgumentException("Illegal capacity of " + sum + " for children of queue " + this.queueName + " for label=" + nodeLabel);
        }
        this.childQueues.clear();
        this.childQueues.addAll(childQueues);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setChildQueues: " + this.getChildQueuesToPrint()));
        }
    }

    @Override
    public String getQueuePath() {
        String parentPath = this.parent == null ? "" : this.parent.getQueuePath() + ".";
        return parentPath + this.getQueueName();
    }

    @Override
    public synchronized QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
        QueueInfo queueInfo = this.getQueueInfo();
        ArrayList<QueueInfo> childQueuesInfo = new ArrayList<QueueInfo>();
        if (includeChildQueues) {
            for (CSQueue child : this.childQueues) {
                childQueuesInfo.add(child.getQueueInfo(recursive, recursive));
            }
        }
        queueInfo.setChildQueues(childQueuesInfo);
        return queueInfo;
    }

    private synchronized QueueUserACLInfo getUserAclInfo(UserGroupInformation user) {
        QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
        ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
        for (QueueACL operation : QueueACL.values()) {
            if (!this.hasAccess(operation, user)) continue;
            operations.add(operation);
        }
        userAclInfo.setQueueName(this.getQueueName());
        userAclInfo.setUserAcls(operations);
        return userAclInfo;
    }

    @Override
    public synchronized List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        ArrayList<QueueUserACLInfo> userAcls = new ArrayList<QueueUserACLInfo>();
        userAcls.add(this.getUserAclInfo(user));
        for (CSQueue child : this.childQueues) {
            userAcls.addAll(child.getQueueUserAclInfo(user));
        }
        return userAcls;
    }

    public String toString() {
        return this.queueName + ": " + "numChildQueue= " + this.childQueues.size() + ", " + "capacity=" + this.queueCapacities.getCapacity() + ", " + "absoluteCapacity=" + this.queueCapacities.getAbsoluteCapacity() + ", " + "usedResources=" + this.queueUsage.getUsed() + "usedCapacity=" + this.getUsedCapacity() + ", " + "numApps=" + this.getNumApplications() + ", " + "numContainers=" + this.getNumContainers();
    }

    @Override
    public synchronized void reinitialize(CSQueue newlyParsedQueue, Resource clusterResource) throws IOException {
        if (!(newlyParsedQueue instanceof ParentQueue) || !newlyParsedQueue.getQueuePath().equals(this.getQueuePath())) {
            throw new IOException("Trying to reinitialize " + this.getQueuePath() + " from " + newlyParsedQueue.getQueuePath());
        }
        ParentQueue newlyParsedParentQueue = (ParentQueue)newlyParsedQueue;
        this.setupQueueConfigs(clusterResource);
        Map<String, CSQueue> currentChildQueues = this.getQueues(this.childQueues);
        Map<String, CSQueue> newChildQueues = this.getQueues(newlyParsedParentQueue.childQueues);
        for (Map.Entry<String, CSQueue> e : newChildQueues.entrySet()) {
            String newChildQueueName = e.getKey();
            CSQueue newChildQueue = e.getValue();
            CSQueue childQueue = currentChildQueues.get(newChildQueueName);
            if (childQueue != null) {
                childQueue.reinitialize(newChildQueue, clusterResource);
                LOG.info((Object)(this.getQueueName() + ": re-configured queue: " + childQueue));
                continue;
            }
            newChildQueue.setParent(this);
            currentChildQueues.put(newChildQueueName, newChildQueue);
            LOG.info((Object)(this.getQueueName() + ": added new child queue: " + newChildQueue));
        }
        this.childQueues.clear();
        this.childQueues.addAll(currentChildQueues.values());
    }

    Map<String, CSQueue> getQueues(Set<CSQueue> queues) {
        HashMap<String, CSQueue> queuesMap = new HashMap<String, CSQueue>();
        for (CSQueue queue : queues) {
            queuesMap.put(queue.getQueueName(), queue);
        }
        return queuesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitApplication(ApplicationId applicationId, String user, String queue) throws AccessControlException {
        ParentQueue parentQueue = this;
        synchronized (parentQueue) {
            if (queue.equals(this.queueName)) {
                throw new AccessControlException("Cannot submit application to non-leaf queue: " + this.queueName);
            }
            if (this.state != QueueState.RUNNING) {
                throw new AccessControlException("Queue " + this.getQueuePath() + " is STOPPED. Cannot accept submission of application: " + applicationId);
            }
            this.addApplication(applicationId, user);
        }
        if (this.parent != null) {
            try {
                this.parent.submitApplication(applicationId, user, queue);
            }
            catch (AccessControlException ace) {
                LOG.info((Object)("Failed to submit application to parent-queue: " + this.parent.getQueuePath()), (Throwable)ace);
                this.removeApplication(applicationId, user);
                throw ace;
            }
        }
    }

    @Override
    public void submitApplicationAttempt(FiCaSchedulerApp application, String userName) {
    }

    @Override
    public void finishApplicationAttempt(FiCaSchedulerApp application, String queue) {
    }

    private synchronized void addApplication(ApplicationId applicationId, String user) {
        ++this.numApplications;
        LOG.info((Object)("Application added - appId: " + applicationId + " user: " + user + " leaf-queue of parent: " + this.getQueueName() + " #applications: " + this.getNumApplications()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishApplication(ApplicationId application, String user) {
        ParentQueue parentQueue = this;
        synchronized (parentQueue) {
            this.removeApplication(application, user);
        }
        if (this.parent != null) {
            this.parent.finishApplication(application, user);
        }
    }

    private synchronized void removeApplication(ApplicationId applicationId, String user) {
        --this.numApplications;
        LOG.info((Object)("Application removed - appId: " + applicationId + " user: " + user + " leaf-queue of parent: " + this.getQueueName() + " #applications: " + this.getNumApplications()));
    }

    @Override
    public synchronized CSAssignment assignContainers(Resource clusterResource, FiCaSchedulerNode node, boolean needToUnreserve, ResourceLimits resourceLimits) {
        CSAssignment assignment = new CSAssignment(Resources.createResource((int)0, (int)0), NodeType.NODE_LOCAL);
        Set<String> nodeLabels = node.getLabels();
        if (!SchedulerUtils.checkQueueAccessToNode(this.accessibleLabels, nodeLabels)) {
            return assignment;
        }
        while (this.canAssign(clusterResource, node)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to assign containers to child-queue of " + this.getQueueName()));
            }
            boolean localNeedToUnreserve = false;
            if (!this.canAssignToThisQueue(clusterResource, nodeLabels) && !(localNeedToUnreserve = this.assignToQueueIfUnreserve(clusterResource))) break;
            CSAssignment assignedToChild = this.assignContainersToChildQueues(clusterResource, node, localNeedToUnreserve | needToUnreserve, resourceLimits);
            assignment.setType(assignedToChild.getType());
            if (!Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)assignedToChild.getResource(), (Resource)Resources.none())) break;
            super.allocateResource(clusterResource, assignedToChild.getResource(), nodeLabels);
            Resources.addTo((Resource)assignment.getResource(), (Resource)assignedToChild.getResource());
            LOG.info((Object)("assignedContainer queue=" + this.getQueueName() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.queueUsage.getUsed() + " cluster=" + clusterResource));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ParentQ=" + this.getQueueName() + " assignedSoFarInThisIteration=" + assignment.getResource() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity()));
            }
            if (this.rootQueue && assignment.getType() != NodeType.OFF_SWITCH) continue;
            if (!LOG.isDebugEnabled() || !this.rootQueue || assignment.getType() != NodeType.OFF_SWITCH) break;
            LOG.debug((Object)("Not assigning more than one off-switch container, assignments so far: " + assignment));
            break;
        }
        return assignment;
    }

    private synchronized boolean canAssignToThisQueue(Resource clusterResource, Set<String> nodeLabels) {
        HashSet<String> labelCanAccess = new HashSet<String>((Collection<String>)(this.accessibleLabels.contains("*") ? nodeLabels : Sets.intersection((Set)this.accessibleLabels, nodeLabels)));
        if (nodeLabels.isEmpty()) {
            labelCanAccess.add("");
        }
        boolean canAssign = true;
        for (String label : labelCanAccess) {
            float currentAbsoluteLabelUsedCapacity = Resources.divide((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)this.queueUsage.getUsed(label), (Resource)this.labelManager.getResourceByLabel(label, clusterResource));
            if (!(currentAbsoluteLabelUsedCapacity >= this.queueCapacities.getAbsoluteMaximumCapacity(label))) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getQueueName() + " used=" + this.queueUsage.getUsed() + " current-capacity (" + this.queueUsage.getUsed(label) + ") " + " >= max-capacity (" + this.labelManager.getResourceByLabel(label, clusterResource) + ")"));
            }
            canAssign = false;
            break;
        }
        return canAssign;
    }

    private synchronized boolean assignToQueueIfUnreserve(Resource clusterResource) {
        if (this.reservationsContinueLooking) {
            Resource reservedResources = Resources.createResource((int)this.getMetrics().getReservedMB(), (int)this.getMetrics().getReservedVirtualCores());
            float capacityWithoutReservedCapacity = Resources.divide((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)Resources.subtract((Resource)this.queueUsage.getUsed(), (Resource)reservedResources), (Resource)clusterResource);
            if (capacityWithoutReservedCapacity <= this.queueCapacities.getAbsoluteMaximumCapacity()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("parent: try to use reserved: " + this.getQueueName() + " usedResources: " + this.queueUsage.getUsed().getMemory() + " clusterResources: " + clusterResource.getMemory() + " reservedResources: " + reservedResources.getMemory() + " currentCapacity " + (float)this.queueUsage.getUsed().getMemory() / (float)clusterResource.getMemory() + " potentialNewWithoutReservedCapacity: " + capacityWithoutReservedCapacity + " ( " + " max-capacity: " + this.queueCapacities.getAbsoluteMaximumCapacity() + ")"));
                }
                return true;
            }
        }
        return false;
    }

    private boolean canAssign(Resource clusterResource, FiCaSchedulerNode node) {
        return node.getReservedContainer() == null && Resources.greaterThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)node.getAvailableResource(), (Resource)this.minimumAllocation);
    }

    private ResourceLimits getResourceLimitsOfChild(CSQueue child, Resource clusterResource, ResourceLimits myLimits) {
        Resource myCurrentLimit = this.getCurrentResourceLimit(clusterResource, myLimits);
        Resource myMaxAvailableResource = Resources.subtract((Resource)myCurrentLimit, (Resource)this.getUsedResources());
        Resource childLimit = Resources.add((Resource)myMaxAvailableResource, (Resource)child.getUsedResources());
        return new ResourceLimits(childLimit);
    }

    private synchronized CSAssignment assignContainersToChildQueues(Resource cluster, FiCaSchedulerNode node, boolean needToUnreserve, ResourceLimits limits) {
        CSAssignment assignment = new CSAssignment(Resources.createResource((int)0, (int)0), NodeType.NODE_LOCAL);
        this.printChildQueues();
        Iterator<CSQueue> iter = this.childQueues.iterator();
        while (iter.hasNext()) {
            CSQueue childQueue = iter.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to assign to queue: " + childQueue.getQueuePath() + " stats: " + childQueue));
            }
            ResourceLimits childLimits = this.getResourceLimitsOfChild(childQueue, cluster, limits);
            assignment = childQueue.assignContainers(cluster, node, needToUnreserve, childLimits);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Assigned to queue: " + childQueue.getQueuePath() + " stats: " + childQueue + " --> " + assignment.getResource() + ", " + (Object)((Object)assignment.getType())));
            }
            if (!Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)cluster, (Resource)assignment.getResource(), (Resource)Resources.none())) continue;
            iter.remove();
            LOG.info((Object)("Re-sorting assigned queue: " + childQueue.getQueuePath() + " stats: " + childQueue));
            this.childQueues.add(childQueue);
            if (!LOG.isDebugEnabled()) break;
            this.printChildQueues();
            break;
        }
        return assignment;
    }

    String getChildQueuesToPrint() {
        StringBuilder sb = new StringBuilder();
        for (CSQueue q : this.childQueues) {
            sb.append(q.getQueuePath() + "usedCapacity=(" + q.getUsedCapacity() + "), " + " label=(" + StringUtils.join(q.getAccessibleNodeLabels().iterator(), (String)",") + ")");
        }
        return sb.toString();
    }

    private void printChildQueues() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("printChildQueues - queue: " + this.getQueuePath() + " child-queues: " + this.getChildQueuesToPrint()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completedContainer(Resource clusterResource, FiCaSchedulerApp application, FiCaSchedulerNode node, RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event, CSQueue completedChildQueue, boolean sortQueues) {
        if (application != null) {
            ParentQueue parentQueue = this;
            synchronized (parentQueue) {
                super.releaseResource(clusterResource, rmContainer.getContainer().getResource(), node.getLabels());
                LOG.info((Object)("completedContainer queue=" + this.getQueueName() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.queueUsage.getUsed() + " cluster=" + clusterResource));
                if (sortQueues) {
                    Iterator<CSQueue> iter = this.childQueues.iterator();
                    while (iter.hasNext()) {
                        CSQueue csqueue = iter.next();
                        if (!csqueue.equals(completedChildQueue)) continue;
                        iter.remove();
                        LOG.info((Object)("Re-sorting completed queue: " + csqueue.getQueuePath() + " stats: " + csqueue));
                        this.childQueues.add(csqueue);
                        break;
                    }
                }
            }
            if (this.parent != null) {
                this.parent.completedContainer(clusterResource, application, node, rmContainer, null, event, this, sortQueues);
            }
        }
    }

    @Override
    public synchronized void updateClusterResource(Resource clusterResource, ResourceLimits resourceLimits) {
        for (CSQueue childQueue : this.childQueues) {
            ResourceLimits childLimits = this.getResourceLimitsOfChild(childQueue, clusterResource, resourceLimits);
            childQueue.updateClusterResource(clusterResource, childLimits);
        }
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this, this.parent, clusterResource, this.minimumAllocation);
    }

    @Override
    public synchronized List<CSQueue> getChildQueues() {
        return new ArrayList<CSQueue>(this.childQueues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverContainer(Resource clusterResource, SchedulerApplicationAttempt attempt, RMContainer rmContainer) {
        if (rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
            return;
        }
        ParentQueue parentQueue = this;
        synchronized (parentQueue) {
            FiCaSchedulerNode node = this.scheduler.getNode(rmContainer.getContainer().getNodeId());
            super.allocateResource(clusterResource, rmContainer.getContainer().getResource(), node.getLabels());
        }
        if (this.parent != null) {
            this.parent.recoverContainer(clusterResource, attempt, rmContainer);
        }
    }

    @Override
    public ActiveUsersManager getActiveUsersManager() {
        return null;
    }

    @Override
    public synchronized void collectSchedulerApplications(Collection<ApplicationAttemptId> apps) {
        for (CSQueue queue : this.childQueues) {
            queue.collectSchedulerApplications(apps);
        }
    }

    @Override
    public void attachContainer(Resource clusterResource, FiCaSchedulerApp application, RMContainer rmContainer) {
        if (application != null) {
            FiCaSchedulerNode node = this.scheduler.getNode(rmContainer.getContainer().getNodeId());
            super.allocateResource(clusterResource, rmContainer.getContainer().getResource(), node.getLabels());
            LOG.info((Object)("movedContainer queueMoveIn=" + this.getQueueName() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.queueUsage.getUsed() + " cluster=" + clusterResource));
            if (this.parent != null) {
                this.parent.attachContainer(clusterResource, application, rmContainer);
            }
        }
    }

    @Override
    public void detachContainer(Resource clusterResource, FiCaSchedulerApp application, RMContainer rmContainer) {
        if (application != null) {
            FiCaSchedulerNode node = this.scheduler.getNode(rmContainer.getContainer().getNodeId());
            super.releaseResource(clusterResource, rmContainer.getContainer().getResource(), node.getLabels());
            LOG.info((Object)("movedContainer queueMoveOut=" + this.getQueueName() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.queueUsage.getUsed() + " cluster=" + clusterResource));
            if (this.parent != null) {
                this.parent.detachContainer(clusterResource, application, rmContainer);
            }
        }
    }

    @Override
    public synchronized int getNumApplications() {
        return this.numApplications;
    }

    private Queue.QueueLabelPolicy refreshLabelPolicy() {
        String labelPolicyStr = this.scheduler.getConfiguration().get("yarn.scheduler.capacity." + this.getQueuePath() + "." + "label-policy");
        if (labelPolicyStr == null) {
            if (this.parent != null) {
                return ((ParentQueue)this.parent).getLabelPolicy();
            }
            return Queue.QueueLabelPolicy.AND;
        }
        try {
            return Queue.QueueLabelPolicy.valueOf(labelPolicyStr);
        }
        catch (IllegalArgumentException ie) {
            LOG.warn((Object)("Unknown label policy: " + labelPolicyStr));
            return Queue.QueueLabelPolicy.AND;
        }
    }

    @Override
    public Queue.QueueLabelPolicy getLabelPolicy() {
        return this.labelPolicy;
    }

    private Expression refreshLabel() {
        String labelStr = this.scheduler.getConfiguration().get("yarn.scheduler.capacity." + this.getQueuePath() + "." + "label");
        if (labelStr != null) {
            try {
                return LabelManager.getInstance().getEffectiveLabelExpr(labelStr);
            }
            catch (IOException e) {
                return null;
            }
        }
        if (this.parent != null) {
            return ((ParentQueue)this.parent).refreshLabel();
        }
        try {
            return LabelManager.getInstance().getEffectiveLabelExpr("all");
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Expression getLabel() {
        return this.label;
    }
}

