/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.http.lib.StaticUserWebFilter;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.ConfigurationProvider;
import org.apache.hadoop.yarn.conf.ConfigurationProviderFactory;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.api.ConfigurableAuxServices;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.NMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMActiveServiceContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMNMInfo;
import org.apache.hadoop.yarn.server.resourcemanager.RMSecretManagerService;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelManagementService;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingEditPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.NullRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreFactory;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.AbstractReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerPreemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerPreemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.PreemptableResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebApp;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.security.http.RMAuthenticationFilter;
import org.apache.hadoop.yarn.server.security.http.RMAuthenticationFilterInitializer;
import org.apache.hadoop.yarn.server.webproxy.AppReportFetcher;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServlet;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class ResourceManager
extends CompositeService
implements Recoverable {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final Log LOG = LogFactory.getLog(ResourceManager.class);
    private static long clusterTimeStamp = System.currentTimeMillis();
    @VisibleForTesting
    protected RMContextImpl rmContext;
    private Dispatcher rmDispatcher;
    @VisibleForTesting
    protected AdminService adminService;
    protected RMActiveServices activeServices;
    protected RMSecretManagerService rmSecretManagerService;
    protected ResourceScheduler scheduler;
    protected ReservationSystem reservationSystem;
    private ClientRMService clientRM;
    protected ApplicationMasterService masterService;
    protected NMLivelinessMonitor nmLivelinessMonitor;
    protected NodesListManager nodesListManager;
    protected RMAppManager rmAppManager;
    protected ApplicationACLsManager applicationACLsManager;
    protected QueueACLsManager queueACLsManager;
    private WebApp webApp;
    private AppReportFetcher fetcher = null;
    protected ResourceTrackerService resourceTracker;
    @VisibleForTesting
    protected String webAppAddress;
    private ConfigurationProvider configurationProvider = null;
    private Configuration conf;
    private UserGroupInformation rmLoginUGI;
    private ConfigurableAuxServices auxiliaryServices;

    public ResourceManager() {
        super("ResourceManager");
    }

    public RMContext getRMContext() {
        return this.rmContext;
    }

    public static long getClusterTimeStamp() {
        return clusterTimeStamp;
    }

    @VisibleForTesting
    protected static void setClusterTimeStamp(long timestamp) {
        clusterTimeStamp = timestamp;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.conf = conf;
        this.rmContext = new RMContextImpl();
        this.configurationProvider = ConfigurationProviderFactory.getConfigurationProvider((Configuration)conf);
        this.configurationProvider.init(this.conf);
        this.rmContext.setConfigurationProvider(this.configurationProvider);
        InputStream coreSiteXMLInputStream = this.configurationProvider.getConfigurationInputStream(this.conf, "core-site.xml");
        if (coreSiteXMLInputStream != null) {
            this.conf.addResource(coreSiteXMLInputStream);
        }
        Groups.getUserToGroupsMappingServiceWithLoadedConfiguration((Configuration)this.conf).refresh();
        RMServerUtils.processRMProxyUsersConf(conf);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)this.conf);
        InputStream yarnSiteXMLInputStream = this.configurationProvider.getConfigurationInputStream(this.conf, "yarn-site.xml");
        if (yarnSiteXMLInputStream != null) {
            this.conf.addResource(yarnSiteXMLInputStream);
        }
        ResourceManager.validateConfigs(this.conf);
        this.rmContext.setHAEnabled(HAUtil.isHAEnabled((Configuration)this.conf));
        if (this.rmContext.isHAEnabled()) {
            HAUtil.verifyAndSetConfiguration((Configuration)this.conf);
        }
        this.rmLoginUGI = UserGroupInformation.getCurrentUser();
        try {
            this.doSecureLogin();
        }
        catch (IOException ie) {
            throw new YarnRuntimeException("Failed to login", (Throwable)ie);
        }
        this.auxiliaryServices = new ConfigurableAuxServices("RMAuxServices", "yarn.resourcemanager.aux-services");
        this.addService((Service)this.auxiliaryServices);
        this.rmDispatcher = this.setupDispatcher();
        this.addIfService(this.rmDispatcher);
        this.rmContext.setDispatcher(this.rmDispatcher);
        this.adminService = this.createAdminService();
        this.addService((Service)this.adminService);
        this.rmContext.setRMAdminService(this.adminService);
        this.rmContext.setYarnConfiguration(conf);
        this.createAndInitActiveServices();
        this.webAppAddress = WebAppUtils.getWebAppBindURL((Configuration)this.conf, (String)"yarn.resourcemanager.bind-host", (String)WebAppUtils.getRMWebAppURLWithoutScheme((Configuration)this.conf));
        super.serviceInit(this.conf);
    }

    protected QueueACLsManager createQueueACLsManager(ResourceScheduler scheduler, Configuration conf) {
        return new QueueACLsManager(scheduler, conf);
    }

    @VisibleForTesting
    protected void setRMStateStore(RMStateStore rmStore) {
        rmStore.setRMDispatcher(this.rmDispatcher);
        rmStore.setResourceManager(this);
        this.rmContext.setStateStore(rmStore);
    }

    protected EventHandler<SchedulerEvent> createSchedulerEventDispatcher() {
        return new SchedulerEventDispatcher(this.scheduler);
    }

    protected Dispatcher createDispatcher() {
        return new AsyncDispatcher();
    }

    protected ResourceScheduler createScheduler() {
        String schedulerClassName = this.conf.get("yarn.resourcemanager.scheduler.class", "org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler");
        LOG.info((Object)("Using Scheduler: " + schedulerClassName));
        try {
            Class<?> schedulerClazz = Class.forName(schedulerClassName);
            if (ResourceScheduler.class.isAssignableFrom(schedulerClazz)) {
                return (ResourceScheduler)ReflectionUtils.newInstance(schedulerClazz, (Configuration)this.conf);
            }
            throw new YarnRuntimeException("Class: " + schedulerClassName + " not instance of " + ResourceScheduler.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate Scheduler: " + schedulerClassName, (Throwable)e);
        }
    }

    protected ReservationSystem createReservationSystem() {
        String reservationClassName = this.conf.get("yarn.resourcemanager.reservation-system.class", AbstractReservationSystem.getDefaultReservationSystem(this.scheduler));
        if (reservationClassName == null) {
            return null;
        }
        LOG.info((Object)("Using ReservationSystem: " + reservationClassName));
        try {
            Class<?> reservationClazz = Class.forName(reservationClassName);
            if (ReservationSystem.class.isAssignableFrom(reservationClazz)) {
                return (ReservationSystem)ReflectionUtils.newInstance(reservationClazz, (Configuration)this.conf);
            }
            throw new YarnRuntimeException("Class: " + reservationClassName + " not instance of " + ReservationSystem.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate ReservationSystem: " + reservationClassName, (Throwable)e);
        }
    }

    protected ApplicationMasterLauncher createAMLauncher() {
        return new ApplicationMasterLauncher(this.rmContext);
    }

    private NMLivelinessMonitor createNMLivelinessMonitor() {
        return new NMLivelinessMonitor(this.rmContext.getDispatcher());
    }

    protected AMLivelinessMonitor createAMLivelinessMonitor() {
        return new AMLivelinessMonitor(this.rmDispatcher);
    }

    protected RMNodeLabelsManager createNodeLabelManager() throws InstantiationException, IllegalAccessException {
        return new RMNodeLabelsManager();
    }

    protected DelegationTokenRenewer createDelegationTokenRenewer() {
        return new DelegationTokenRenewer();
    }

    protected RMAppManager createRMAppManager() {
        return new RMAppManager(this.rmContext, this.scheduler, this.masterService, this.applicationACLsManager, this.conf);
    }

    protected RMApplicationHistoryWriter createRMApplicationHistoryWriter() {
        return new RMApplicationHistoryWriter();
    }

    protected SystemMetricsPublisher createSystemMetricsPublisher() {
        return new SystemMetricsPublisher();
    }

    protected static void validateConfigs(Configuration conf) {
        long heartbeatIntvl;
        int globalMaxAppAttempts = conf.getInt("yarn.resourcemanager.am.max-attempts", 2);
        if (globalMaxAppAttempts <= 0) {
            throw new YarnRuntimeException("Invalid global max attempts configuration, yarn.resourcemanager.am.max-attempts=" + globalMaxAppAttempts + ", it should be a positive integer.");
        }
        long expireIntvl = conf.getLong("yarn.nm.liveness-monitor.expiry-interval-ms", 600000L);
        if (expireIntvl < (heartbeatIntvl = conf.getLong("yarn.resourcemanager.nodemanagers.heartbeat-interval-ms", 1000L))) {
            throw new YarnRuntimeException("Nodemanager expiry interval should be no less than heartbeat interval, yarn.nm.liveness-monitor.expiry-interval-ms=" + expireIntvl + ", " + "yarn.resourcemanager.nodemanagers.heartbeat-interval-ms" + "=" + heartbeatIntvl);
        }
    }

    public void handleTransitionToStandBy() {
        if (this.rmContext.isHAEnabled()) {
            try {
                LOG.info((Object)"Transitioning RM to Standby mode");
                this.transitionToStandby(true);
                this.adminService.resetLeaderElection();
                return;
            }
            catch (Exception e) {
                LOG.fatal((Object)"Failed to transition RM to Standby mode.");
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
    }

    protected void startWepApp() {
        Configuration conf = this.getConfig();
        boolean useYarnAuthenticationFilter = conf.getBoolean("yarn.resourcemanager.webapp.delegation-token-auth-filter.enabled", true);
        String authPrefix = "hadoop.http.authentication.";
        String authTypeKey = authPrefix + "type";
        String filterInitializerConfKey = "hadoop.http.filter.initializers";
        String actualInitializers = "";
        Class[] initializersClasses = conf.getClasses(filterInitializerConfKey, new Class[0]);
        boolean hasHadoopAuthFilterInitializer = false;
        boolean hasRMAuthFilterInitializer = false;
        if (initializersClasses != null) {
            for (Class initializer : initializersClasses) {
                if (initializer.getName().equals(AuthenticationFilterInitializer.class.getName())) {
                    hasHadoopAuthFilterInitializer = true;
                }
                if (!initializer.getName().equals(RMAuthenticationFilterInitializer.class.getName())) continue;
                hasRMAuthFilterInitializer = true;
            }
            if (UserGroupInformation.isSecurityEnabled() && useYarnAuthenticationFilter && hasHadoopAuthFilterInitializer && conf.get(authTypeKey, "").equals("kerberos")) {
                ArrayList<String> target = new ArrayList<String>();
                for (Class filterInitializer : initializersClasses) {
                    if (filterInitializer.getName().equals(AuthenticationFilterInitializer.class.getName())) {
                        if (hasRMAuthFilterInitializer) continue;
                        target.add(RMAuthenticationFilterInitializer.class.getName());
                        continue;
                    }
                    target.add(filterInitializer.getName());
                }
                actualInitializers = StringUtils.join((CharSequence)",", target);
                LOG.info((Object)"Using RM authentication filter(kerberos/delegation-token) for RM webapp authentication");
                RMAuthenticationFilter.setDelegationTokenSecretManager((AbstractDelegationTokenSecretManager)this.getClientRMService().rmDTSecretManager);
                conf.set(filterInitializerConfKey, actualInitializers);
            }
        }
        String initializers = conf.get(filterInitializerConfKey);
        if (!UserGroupInformation.isSecurityEnabled()) {
            if (initializersClasses == null || initializersClasses.length == 0) {
                conf.set(filterInitializerConfKey, RMAuthenticationFilterInitializer.class.getName());
                conf.set(authTypeKey, "simple");
            } else if (initializers.equals(StaticUserWebFilter.class.getName())) {
                conf.set(filterInitializerConfKey, RMAuthenticationFilterInitializer.class.getName() + "," + initializers);
                conf.set(authTypeKey, "simple");
            }
        }
        WebApps.Builder builder = WebApps.$for((String)"cluster", ApplicationMasterService.class, (Object)((Object)this.masterService), (String)"ws").with(conf).withHttpSpnegoPrincipalKey("yarn.resourcemanager.webapp.spnego-principal").withHttpSpnegoKeytabKey("yarn.resourcemanager.webapp.spnego-keytab-file").at(this.webAppAddress);
        String proxyHostAndPort = WebAppUtils.getProxyHostAndPort((Configuration)conf);
        if (WebAppUtils.getResolvedRMWebAppURLWithoutScheme((Configuration)conf).equals(proxyHostAndPort)) {
            this.fetcher = HAUtil.isHAEnabled((Configuration)conf) ? new AppReportFetcher(conf) : new AppReportFetcher(conf, (ApplicationClientProtocol)this.getClientRMService());
            builder.withServlet("proxy", "/proxy/*", WebAppProxyServlet.class);
            builder.withAttribute("AppUrlFetcher", (Object)this.fetcher);
            String[] proxyParts = proxyHostAndPort.split(":");
            builder.withAttribute("proxyHost", (Object)proxyParts[0]);
        }
        this.webApp = builder.start((WebApp)new RMWebApp(this));
    }

    protected void createAndInitActiveServices() throws Exception {
        this.activeServices = new RMActiveServices(this);
        this.activeServices.init(this.conf);
    }

    void startActiveServices() throws Exception {
        if (this.activeServices != null) {
            clusterTimeStamp = System.currentTimeMillis();
            this.activeServices.start();
        }
    }

    void stopActiveServices() throws Exception {
        if (this.activeServices != null) {
            this.activeServices.stop();
            this.activeServices = null;
        }
    }

    void reinitialize(boolean initialize) throws Exception {
        ClusterMetrics.destroy();
        QueueMetrics.clearQueueMetrics();
        if (initialize) {
            this.resetDispatcher();
            this.createAndInitActiveServices();
        }
    }

    @VisibleForTesting
    protected boolean areActiveServicesRunning() {
        return this.activeServices != null && this.activeServices.isInState(Service.STATE.STARTED);
    }

    synchronized void transitionToActive() throws Exception {
        if (this.rmContext.getHAServiceState() == HAServiceProtocol.HAServiceState.ACTIVE) {
            LOG.info((Object)"Already in active state");
            return;
        }
        LOG.info((Object)"Transitioning to active state");
        this.rmLoginUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    ResourceManager.this.startActiveServices();
                    return null;
                }
                catch (Exception e) {
                    ResourceManager.this.reinitialize(true);
                    throw e;
                }
            }
        });
        this.rmContext.setHAServiceState(HAServiceProtocol.HAServiceState.ACTIVE);
        LOG.info((Object)"Transitioned to active state");
    }

    synchronized void transitionToStandby(boolean initialize) throws Exception {
        if (this.rmContext.getHAServiceState() == HAServiceProtocol.HAServiceState.STANDBY) {
            LOG.info((Object)"Already in standby state");
            return;
        }
        LOG.info((Object)"Transitioning to standby state");
        if (this.rmContext.getHAServiceState() == HAServiceProtocol.HAServiceState.ACTIVE) {
            this.stopActiveServices();
            this.reinitialize(initialize);
        }
        this.rmContext.setHAServiceState(HAServiceProtocol.HAServiceState.STANDBY);
        LOG.info((Object)"Transitioned to standby state");
    }

    protected void serviceStart() throws Exception {
        if (this.rmContext.isHAEnabled()) {
            this.transitionToStandby(true);
        } else {
            this.transitionToActive();
        }
        this.startWepApp();
        if (this.getConfig().getBoolean("yarn.is.minicluster", false)) {
            int port = this.webApp.port();
            WebAppUtils.setRMWebAppPort((Configuration)this.conf, (int)port);
        }
        super.serviceStart();
    }

    protected void doSecureLogin() throws IOException {
        InetSocketAddress socAddr = ResourceManager.getBindAddress(this.conf);
        SecurityUtil.login((Configuration)this.conf, (String)"yarn.resourcemanager.keytab", (String)"yarn.resourcemanager.principal", (String)socAddr.getHostName());
        if (UserGroupInformation.isSecurityEnabled()) {
            this.rmLoginUGI = UserGroupInformation.getLoginUser();
        }
    }

    protected void serviceStop() throws Exception {
        if (this.webApp != null) {
            this.webApp.stop();
        }
        if (this.fetcher != null) {
            this.fetcher.stop();
        }
        if (this.configurationProvider != null) {
            this.configurationProvider.close();
        }
        super.serviceStop();
        this.transitionToStandby(false);
        this.rmContext.setHAServiceState(HAServiceProtocol.HAServiceState.STOPPING);
    }

    protected ResourceTrackerService createResourceTrackerService() {
        return new ResourceTrackerService(this.rmContext, this.nodesListManager, this.nmLivelinessMonitor, this.rmContext.getContainerTokenSecretManager(), this.rmContext.getNMTokenSecretManager());
    }

    protected ClientRMService createClientRMService() {
        return new ClientRMService(this.rmContext, this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.rmContext.getRMDelegationTokenSecretManager());
    }

    protected ApplicationMasterService createApplicationMasterService() {
        return new ApplicationMasterService(this.rmContext, this.scheduler);
    }

    protected AdminService createAdminService() {
        return new AdminService(this, this.rmContext);
    }

    protected RMSecretManagerService createRMSecretManagerService() {
        return new RMSecretManagerService(this.conf, this.rmContext);
    }

    @InterfaceAudience.Private
    public ClientRMService getClientRMService() {
        return this.clientRM;
    }

    @InterfaceAudience.Private
    public ResourceScheduler getResourceScheduler() {
        return this.scheduler;
    }

    @InterfaceAudience.Private
    public ResourceTrackerService getResourceTrackerService() {
        return this.resourceTracker;
    }

    @InterfaceAudience.Private
    public ApplicationMasterService getApplicationMasterService() {
        return this.masterService;
    }

    @InterfaceAudience.Private
    public ApplicationACLsManager getApplicationACLsManager() {
        return this.applicationACLsManager;
    }

    @InterfaceAudience.Private
    public QueueACLsManager getQueueACLsManager() {
        return this.queueACLsManager;
    }

    @InterfaceAudience.Private
    WebApp getWebapp() {
        return this.webApp;
    }

    @Override
    public void recover(RMStateStore.RMState state) throws Exception {
        this.rmContext.getRMDelegationTokenSecretManager().recover(state);
        this.rmContext.getAMRMTokenSecretManager().recover(state);
        this.rmAppManager.recover(state);
        this.setSchedulerRecoveryStartAndWaitTime(state, this.conf);
    }

    public static void main(String[] argv) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(ResourceManager.class, (String[])argv, (Log)LOG);
        try {
            YarnConfiguration conf = new YarnConfiguration();
            GenericOptionsParser hParser = new GenericOptionsParser((Configuration)conf, argv);
            argv = hParser.getRemainingArgs();
            if (argv.length == 1 && argv[0].equals("-format-state-store")) {
                ResourceManager.deleteRMStateStore((Configuration)conf);
            } else {
                ResourceManager resourceManager = new ResourceManager();
                ShutdownHookManager.get().addShutdownHook((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)resourceManager), 30);
                resourceManager.init((Configuration)conf);
                resourceManager.start();
            }
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting ResourceManager", t);
            System.exit(-1);
        }
    }

    private Dispatcher setupDispatcher() {
        Dispatcher dispatcher = this.createDispatcher();
        dispatcher.register(RMFatalEventType.class, (EventHandler)new RMFatalEventDispatcher());
        return dispatcher;
    }

    private void resetDispatcher() {
        Dispatcher dispatcher = this.setupDispatcher();
        ((Service)dispatcher).init(this.conf);
        ((Service)dispatcher).start();
        this.removeService((Service)this.rmDispatcher);
        ((Service)this.rmDispatcher).stop();
        this.rmDispatcher = dispatcher;
        this.addIfService(this.rmDispatcher);
        this.rmContext.setDispatcher(this.rmDispatcher);
    }

    private void setSchedulerRecoveryStartAndWaitTime(RMStateStore.RMState state, Configuration conf) {
        if (!state.getApplicationState().isEmpty()) {
            long waitTime = conf.getLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 10000L);
            this.rmContext.setSchedulerRecoveryStartAndWaitTime(waitTime);
        }
    }

    public static InetSocketAddress getBindAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteRMStateStore(Configuration conf) throws Exception {
        RMStateStore rmStore = RMStateStoreFactory.getStore(conf);
        rmStore.init(conf);
        rmStore.start();
        try {
            LOG.info((Object)"Deleting ResourceManager state store...");
            rmStore.deleteStore();
            LOG.info((Object)"State store deleted");
        }
        finally {
            rmStore.stop();
        }
    }

    @InterfaceAudience.Private
    public static final class NodeEventDispatcher
    implements EventHandler<RMNodeEvent> {
        private final RMContext rmContext;

        public NodeEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMNodeEvent event) {
            NodeId nodeId = event.getNodeId();
            RMNode node = (RMNode)this.rmContext.getRMNodes().get(nodeId);
            if (node != null) {
                try {
                    ((EventHandler)node).handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in handling event type " + event.getType() + " for node " + nodeId), t);
                }
            }
        }
    }

    @InterfaceAudience.Private
    public static final class ApplicationAttemptEventDispatcher
    implements EventHandler<RMAppAttemptEvent> {
        private final RMContext rmContext;

        public ApplicationAttemptEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMAppAttemptEvent event) {
            RMAppAttempt rmAppAttempt;
            ApplicationAttemptId appAttemptID = event.getApplicationAttemptId();
            ApplicationId appAttemptId = appAttemptID.getApplicationId();
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appAttemptId);
            if (rmApp != null && (rmAppAttempt = rmApp.getRMAppAttempt(appAttemptID)) != null) {
                try {
                    rmAppAttempt.handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in handling event type " + event.getType() + " for applicationAttempt " + appAttemptId), t);
                }
            }
        }
    }

    @InterfaceAudience.Private
    public static final class RMContainerPreemptEventDispatcher
    implements EventHandler<ContainerPreemptEvent> {
        private final PreemptableResourceScheduler scheduler;

        public RMContainerPreemptEventDispatcher(PreemptableResourceScheduler scheduler) {
            this.scheduler = scheduler;
        }

        public void handle(ContainerPreemptEvent event) {
            ApplicationAttemptId aid = event.getAppId();
            RMContainer container = event.getContainer();
            switch ((ContainerPreemptEventType)event.getType()) {
                case DROP_RESERVATION: {
                    this.scheduler.dropContainerReservation(container);
                    break;
                }
                case PREEMPT_CONTAINER: {
                    this.scheduler.preemptContainer(aid, container);
                    break;
                }
                case KILL_CONTAINER: {
                    this.scheduler.killContainer(container);
                }
            }
        }
    }

    @InterfaceAudience.Private
    public static final class ApplicationEventDispatcher
    implements EventHandler<RMAppEvent> {
        private final RMContext rmContext;

        public ApplicationEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMAppEvent event) {
            ApplicationId appID = event.getApplicationId();
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appID);
            if (rmApp != null) {
                try {
                    rmApp.handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in handling event type " + event.getType() + " for application " + appID), t);
                }
            }
        }
    }

    @InterfaceAudience.Private
    public static class RMFatalEventDispatcher
    implements EventHandler<RMFatalEvent> {
        public void handle(RMFatalEvent event) {
            LOG.fatal((Object)("Received a " + RMFatalEvent.class.getName() + " of type " + ((RMFatalEventType)event.getType()).name() + ". Cause:\n" + event.getCause()));
            ExitUtil.terminate((int)1, (String)event.getCause());
        }
    }

    @InterfaceAudience.Private
    public static class SchedulerEventDispatcher
    extends AbstractService
    implements EventHandler<SchedulerEvent> {
        private final ResourceScheduler scheduler;
        private final BlockingQueue<SchedulerEvent> eventQueue = new LinkedBlockingQueue<SchedulerEvent>();
        private final Thread eventProcessor;
        private volatile boolean stopped = false;
        private boolean shouldExitOnError = false;

        public SchedulerEventDispatcher(ResourceScheduler scheduler) {
            super(SchedulerEventDispatcher.class.getName());
            this.scheduler = scheduler;
            this.eventProcessor = new Thread(new EventProcessor());
            this.eventProcessor.setName("ResourceManager Event Processor");
        }

        protected void serviceInit(Configuration conf) throws Exception {
            this.shouldExitOnError = conf.getBoolean("yarn.dispatcher.exit-on-error", false);
            super.serviceInit(conf);
        }

        protected void serviceStart() throws Exception {
            this.eventProcessor.start();
            super.serviceStart();
        }

        protected void serviceStop() throws Exception {
            this.stopped = true;
            this.eventProcessor.interrupt();
            try {
                this.eventProcessor.join();
            }
            catch (InterruptedException e) {
                throw new YarnRuntimeException((Throwable)e);
            }
            super.serviceStop();
        }

        public void handle(SchedulerEvent event) {
            try {
                int remCapacity;
                int qSize = this.eventQueue.size();
                if (qSize != 0 && qSize % 1000 == 0) {
                    LOG.info((Object)("Size of scheduler event-queue is " + qSize));
                }
                if ((remCapacity = this.eventQueue.remainingCapacity()) < 1000) {
                    LOG.info((Object)("Very low remaining capacity on scheduler event queue: " + remCapacity));
                }
                this.eventQueue.put(event);
            }
            catch (InterruptedException e) {
                LOG.info((Object)"Interrupted. Trying to exit gracefully.");
            }
        }

        private final class EventProcessor
        implements Runnable {
            private EventProcessor() {
            }

            @Override
            public void run() {
                while (!SchedulerEventDispatcher.this.stopped && !Thread.currentThread().isInterrupted()) {
                    SchedulerEvent event;
                    try {
                        event = (SchedulerEvent)((Object)SchedulerEventDispatcher.this.eventQueue.take());
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)("Returning, interrupted : " + e));
                        return;
                    }
                    try {
                        SchedulerEventDispatcher.this.scheduler.handle((Event)event);
                    }
                    catch (Throwable t) {
                        if (SchedulerEventDispatcher.this.stopped) {
                            LOG.warn((Object)"Exception during shutdown: ", t);
                            break;
                        }
                        LOG.fatal((Object)("Error in handling event type " + event.getType() + " to the scheduler"), t);
                        if (!SchedulerEventDispatcher.this.shouldExitOnError || ShutdownHookManager.get().isShutdownInProgress()) continue;
                        LOG.info((Object)"Exiting, bbye..");
                        System.exit(-1);
                    }
                }
            }
        }
    }

    @InterfaceAudience.Private
    public class RMActiveServices
    extends CompositeService {
        private DelegationTokenRenewer delegationTokenRenewer;
        private EventHandler<SchedulerEvent> schedulerDispatcher;
        private ApplicationMasterLauncher applicationMasterLauncher;
        private ContainerAllocationExpirer containerAllocationExpirer;
        private ResourceManager rm;
        private boolean recoveryEnabled;
        private RMActiveServiceContext activeServiceContext;

        RMActiveServices(ResourceManager rm) {
            super("RMActiveServices");
            this.rm = rm;
        }

        protected void serviceInit(Configuration configuration) throws Exception {
            this.activeServiceContext = new RMActiveServiceContext();
            ResourceManager.this.rmContext.setActiveServiceContext(this.activeServiceContext);
            ResourceManager.this.conf.setBoolean("yarn.dispatcher.exit-on-error", true);
            ResourceManager.this.rmSecretManagerService = ResourceManager.this.createRMSecretManagerService();
            this.addService((Service)ResourceManager.this.rmSecretManagerService);
            this.containerAllocationExpirer = new ContainerAllocationExpirer(ResourceManager.this.rmDispatcher);
            this.addService((Service)this.containerAllocationExpirer);
            ResourceManager.this.rmContext.setContainerAllocationExpirer(this.containerAllocationExpirer);
            AMLivelinessMonitor amLivelinessMonitor = ResourceManager.this.createAMLivelinessMonitor();
            this.addService((Service)amLivelinessMonitor);
            ResourceManager.this.rmContext.setAMLivelinessMonitor(amLivelinessMonitor);
            AMLivelinessMonitor amFinishingMonitor = ResourceManager.this.createAMLivelinessMonitor();
            this.addService((Service)amFinishingMonitor);
            ResourceManager.this.rmContext.setAMFinishingMonitor(amFinishingMonitor);
            RMNodeLabelsManager nlm = ResourceManager.this.createNodeLabelManager();
            nlm.setRMContext(ResourceManager.this.rmContext);
            this.addService((Service)nlm);
            ResourceManager.this.rmContext.setNodeLabelManager(nlm);
            boolean isRecoveryEnabled = ResourceManager.this.conf.getBoolean("yarn.resourcemanager.recovery.enabled", false);
            RMStateStore rmStore = null;
            if (isRecoveryEnabled) {
                this.recoveryEnabled = true;
                rmStore = RMStateStoreFactory.getStore(ResourceManager.this.conf);
                boolean isWorkPreservingRecoveryEnabled = ResourceManager.this.conf.getBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", true);
                ResourceManager.this.rmContext.setWorkPreservingRecoveryEnabled(isWorkPreservingRecoveryEnabled);
            } else {
                this.recoveryEnabled = false;
                rmStore = new NullRMStateStore();
            }
            try {
                rmStore.init(ResourceManager.this.conf);
                rmStore.setRMDispatcher(ResourceManager.this.rmDispatcher);
                rmStore.setResourceManager(this.rm);
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to init state store", (Throwable)e);
                throw e;
            }
            ResourceManager.this.rmContext.setStateStore(rmStore);
            if (UserGroupInformation.isSecurityEnabled()) {
                this.delegationTokenRenewer = ResourceManager.this.createDelegationTokenRenewer();
                ResourceManager.this.rmContext.setDelegationTokenRenewer(this.delegationTokenRenewer);
            }
            RMApplicationHistoryWriter rmApplicationHistoryWriter = ResourceManager.this.createRMApplicationHistoryWriter();
            this.addService((Service)rmApplicationHistoryWriter);
            ResourceManager.this.rmContext.setRMApplicationHistoryWriter(rmApplicationHistoryWriter);
            SystemMetricsPublisher systemMetricsPublisher = ResourceManager.this.createSystemMetricsPublisher();
            this.addService((Service)systemMetricsPublisher);
            ResourceManager.this.rmContext.setSystemMetricsPublisher(systemMetricsPublisher);
            ResourceManager.this.nodesListManager = new NodesListManager(ResourceManager.this.rmContext);
            ResourceManager.this.rmDispatcher.register(NodesListManagerEventType.class, (EventHandler)ResourceManager.this.nodesListManager);
            this.addService((Service)ResourceManager.this.nodesListManager);
            ResourceManager.this.rmContext.setNodesListManager(ResourceManager.this.nodesListManager);
            ResourceManager.this.scheduler = ResourceManager.this.createScheduler();
            ResourceManager.this.scheduler.setRMContext(ResourceManager.this.rmContext);
            this.addIfService(ResourceManager.this.scheduler);
            ResourceManager.this.rmContext.setScheduler(ResourceManager.this.scheduler);
            LabelManagementService lb = new LabelManagementService();
            this.addService((Service)lb);
            this.schedulerDispatcher = ResourceManager.this.createSchedulerEventDispatcher();
            this.addIfService(this.schedulerDispatcher);
            ResourceManager.this.rmDispatcher.register(SchedulerEventType.class, this.schedulerDispatcher);
            ResourceManager.this.rmDispatcher.register(RMAppEventType.class, (EventHandler)new ApplicationEventDispatcher(ResourceManager.this.rmContext));
            ResourceManager.this.rmDispatcher.register(RMAppAttemptEventType.class, (EventHandler)new ApplicationAttemptEventDispatcher(ResourceManager.this.rmContext));
            ResourceManager.this.rmDispatcher.register(RMNodeEventType.class, (EventHandler)new NodeEventDispatcher(ResourceManager.this.rmContext));
            ResourceManager.this.nmLivelinessMonitor = ResourceManager.this.createNMLivelinessMonitor();
            this.addService((Service)ResourceManager.this.nmLivelinessMonitor);
            ResourceManager.this.resourceTracker = ResourceManager.this.createResourceTrackerService();
            this.addService((Service)ResourceManager.this.resourceTracker);
            ResourceManager.this.rmContext.setResourceTrackerService(ResourceManager.this.resourceTracker);
            DefaultMetricsSystem.initialize((String)"ResourceManager");
            JvmMetrics.initSingleton((String)"ResourceManager", null);
            if (ResourceManager.this.conf.getBoolean("yarn.resourcemanager.reservation-system.enable", false)) {
                ResourceManager.this.reservationSystem = ResourceManager.this.createReservationSystem();
                if (ResourceManager.this.reservationSystem != null) {
                    ResourceManager.this.reservationSystem.setRMContext(ResourceManager.this.rmContext);
                    this.addIfService(ResourceManager.this.reservationSystem);
                    ResourceManager.this.rmContext.setReservationSystem(ResourceManager.this.reservationSystem);
                    LOG.info((Object)"Initialized Reservation system");
                }
            }
            this.createPolicyMonitors();
            ResourceManager.this.masterService = ResourceManager.this.createApplicationMasterService();
            this.addService((Service)ResourceManager.this.masterService);
            ResourceManager.this.rmContext.setApplicationMasterService(ResourceManager.this.masterService);
            ResourceManager.this.applicationACLsManager = new ApplicationACLsManager(ResourceManager.this.conf);
            ResourceManager.this.queueACLsManager = ResourceManager.this.createQueueACLsManager(ResourceManager.this.scheduler, ResourceManager.this.conf);
            ResourceManager.this.rmAppManager = ResourceManager.this.createRMAppManager();
            ResourceManager.this.rmDispatcher.register(RMAppManagerEventType.class, (EventHandler)ResourceManager.this.rmAppManager);
            ResourceManager.this.clientRM = ResourceManager.this.createClientRMService();
            this.addService((Service)ResourceManager.this.clientRM);
            ResourceManager.this.rmContext.setClientRMService(ResourceManager.this.clientRM);
            this.applicationMasterLauncher = ResourceManager.this.createAMLauncher();
            ResourceManager.this.rmDispatcher.register(AMLauncherEventType.class, (EventHandler)this.applicationMasterLauncher);
            this.addService((Service)this.applicationMasterLauncher);
            if (UserGroupInformation.isSecurityEnabled()) {
                this.addService((Service)this.delegationTokenRenewer);
                this.delegationTokenRenewer.setRMContext(ResourceManager.this.rmContext);
            }
            new RMNMInfo(ResourceManager.this.rmContext, ResourceManager.this.scheduler);
            super.serviceInit(ResourceManager.this.conf);
        }

        protected void serviceStart() throws Exception {
            RMStateStore rmStore = ResourceManager.this.rmContext.getStateStore();
            rmStore.start();
            if (this.recoveryEnabled) {
                try {
                    LOG.info((Object)"Recovery started");
                    rmStore.checkVersion();
                    if (ResourceManager.this.rmContext.isWorkPreservingRecoveryEnabled()) {
                        ResourceManager.this.rmContext.setEpoch(rmStore.getAndIncrementEpoch());
                    }
                    RMStateStore.RMState state = rmStore.loadState();
                    ResourceManager.this.recover(state);
                    LOG.info((Object)"Recovery ended");
                }
                catch (Exception e) {
                    LOG.error((Object)"Failed to load/recover state", (Throwable)e);
                    throw e;
                }
            }
            super.serviceStart();
        }

        protected void serviceStop() throws Exception {
            DefaultMetricsSystem.shutdown();
            if (ResourceManager.this.rmContext != null) {
                RMStateStore store = ResourceManager.this.rmContext.getStateStore();
                try {
                    store.close();
                }
                catch (Exception e) {
                    LOG.error((Object)"Error closing store.", (Throwable)e);
                }
            }
            super.serviceStop();
        }

        protected void createPolicyMonitors() {
            if (ResourceManager.this.scheduler instanceof PreemptableResourceScheduler && ResourceManager.this.conf.getBoolean("yarn.resourcemanager.scheduler.monitor.enable", false)) {
                LOG.info((Object)"Loading policy monitors");
                List policies = ResourceManager.this.conf.getInstances("yarn.resourcemanager.scheduler.monitor.policies", SchedulingEditPolicy.class);
                if (policies.size() > 0) {
                    ResourceManager.this.rmDispatcher.register(ContainerPreemptEventType.class, (EventHandler)new RMContainerPreemptEventDispatcher((PreemptableResourceScheduler)ResourceManager.this.scheduler));
                    for (SchedulingEditPolicy policy : policies) {
                        LOG.info((Object)("LOADING SchedulingEditPolicy:" + policy.getPolicyName()));
                        SchedulingMonitor mon = new SchedulingMonitor(ResourceManager.this.rmContext, policy);
                        this.addService((Service)mon);
                    }
                } else {
                    LOG.warn((Object)"Policy monitors configured (yarn.resourcemanager.scheduler.monitor.enable) but none specified (yarn.resourcemanager.scheduler.monitor.policies)");
                }
            }
        }
    }
}

