/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.policy.sqoop;

import org.apache.sentry.core.model.sqoop.Connector;
import org.apache.sentry.core.model.sqoop.Job;
import org.apache.sentry.core.model.sqoop.Link;
import org.apache.sentry.core.model.sqoop.Server;
import org.apache.sentry.core.model.sqoop.SqoopAuthorizable;
import org.apache.sentry.provider.common.KeyValue;

public class SqoopModelAuthorizables {
    public static SqoopAuthorizable from(KeyValue keyValue) {
        String prefix = keyValue.getKey().toLowerCase();
        String name = keyValue.getValue().toLowerCase();
        for (SqoopAuthorizable.AuthorizableType type : SqoopAuthorizable.AuthorizableType.values()) {
            if (!prefix.equalsIgnoreCase(type.name())) continue;
            return SqoopModelAuthorizables.from(type, name);
        }
        return null;
    }

    public static SqoopAuthorizable from(String keyValue) {
        return SqoopModelAuthorizables.from(new KeyValue(keyValue));
    }

    public static SqoopAuthorizable from(SqoopAuthorizable.AuthorizableType type, String name) {
        switch (type) {
            case SERVER: {
                return new Server(name);
            }
            case JOB: {
                return new Job(name);
            }
            case CONNECTOR: {
                return new Connector(name);
            }
            case LINK: {
                return new Link(name);
            }
        }
        return null;
    }
}

