/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.policy.sqoop;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.SentryConfigurationException;
import org.apache.sentry.policy.common.PolicyEngine;
import org.apache.sentry.policy.common.PrivilegeFactory;
import org.apache.sentry.policy.sqoop.ServerNameRequiredMatch;
import org.apache.sentry.policy.sqoop.SqoopWildcardPrivilege;
import org.apache.sentry.provider.common.ProviderBackend;
import org.apache.sentry.provider.common.ProviderBackendContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSqoopPolicyEngine
implements PolicyEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSqoopPolicyEngine.class);
    private final ProviderBackend providerBackend;

    public SimpleSqoopPolicyEngine(String sqoopServerName, ProviderBackend providerBackend) {
        this.providerBackend = providerBackend;
        ProviderBackendContext context = new ProviderBackendContext();
        context.setAllowPerDatabase(false);
        context.setValidators(ImmutableList.of((Object)new ServerNameRequiredMatch(sqoopServerName)));
        this.providerBackend.initialize(context);
    }

    public PrivilegeFactory getPrivilegeFactory() {
        return new SqoopWildcardPrivilege.Factory();
    }

    public ImmutableSet<String> getAllPrivileges(Set<String> groups, ActiveRoleSet roleSet) throws SentryConfigurationException {
        return this.getPrivileges(groups, roleSet, new Authorizable[0]);
    }

    public ImmutableSet<String> getPrivileges(Set<String> groups, ActiveRoleSet roleSet, Authorizable ... authorizableHierarchy) throws SentryConfigurationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Getting permissions for {}", groups);
        }
        ImmutableSet result = this.providerBackend.getPrivileges(groups, roleSet, new Authorizable[0]);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("result = " + result);
        }
        return result;
    }

    public void close() {
        if (this.providerBackend != null) {
            this.providerBackend.close();
        }
    }

    public void validatePolicy(boolean strictValidation) throws SentryConfigurationException {
        if (this.providerBackend != null) {
            this.providerBackend.validatePolicy(strictValidation);
        }
    }
}

