/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.policy.sqoop;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.sentry.core.model.sqoop.Server;
import org.apache.sentry.core.model.sqoop.SqoopAuthorizable;
import org.apache.sentry.policy.common.PrivilegeValidator;
import org.apache.sentry.policy.common.PrivilegeValidatorContext;
import org.apache.sentry.policy.sqoop.SqoopModelAuthorizables;
import org.apache.sentry.provider.common.ProviderConstants;
import org.apache.shiro.config.ConfigurationException;

public class ServerNameRequiredMatch
implements PrivilegeValidator {
    private final String sqoopServerName;

    public ServerNameRequiredMatch(String sqoopServerName) {
        this.sqoopServerName = sqoopServerName;
    }

    public void validate(PrivilegeValidatorContext context) throws ConfigurationException {
        Iterable<SqoopAuthorizable> authorizables = this.parsePrivilege(context.getPrivilege());
        boolean match = false;
        for (SqoopAuthorizable authorizable : authorizables) {
            if (!(authorizable instanceof Server) || !authorizable.getName().equalsIgnoreCase(this.sqoopServerName)) continue;
            match = true;
            break;
        }
        if (!match) {
            String msg = "server=[name] in " + context.getPrivilege() + " is required. The name is expected " + this.sqoopServerName;
            throw new ConfigurationException(msg);
        }
    }

    private Iterable<SqoopAuthorizable> parsePrivilege(String string) {
        ArrayList result = Lists.newArrayList();
        for (String section : ProviderConstants.AUTHORIZABLE_SPLITTER.split((CharSequence)string)) {
            if (section.toLowerCase().startsWith(ProviderConstants.PRIVILEGE_PREFIX)) continue;
            SqoopAuthorizable authorizable = SqoopModelAuthorizables.from(section);
            if (authorizable == null) {
                String msg = "No authorizable found for " + section;
                throw new ConfigurationException(msg);
            }
            result.add(authorizable);
        }
        return result;
    }
}

