/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.lucene.util.RamUsageEstimator;

public final class RamUsageTester {
    public static long sizeOf(Object obj, Accumulator accumulator) {
        return RamUsageTester.measureObjectSize(obj, accumulator);
    }

    public static long sizeOf(Object obj) {
        return RamUsageTester.sizeOf(obj, new Accumulator());
    }

    public static String humanSizeOf(Object object) {
        return RamUsageEstimator.humanReadableUnits((long)RamUsageTester.sizeOf(object));
    }

    private static long measureObjectSize(Object root, Accumulator accumulator) {
        IdentityHashSet seen = new IdentityHashSet();
        IdentityHashMap classCache = new IdentityHashMap();
        ArrayList<Object> stack = new ArrayList<Object>();
        stack.add(root);
        long totalSize = 0L;
        while (!stack.isEmpty()) {
            final Object ob = stack.remove(stack.size() - 1);
            if (ob == null || seen.contains(ob)) continue;
            seen.add(ob);
            Class<?> obClazz = ob.getClass();
            assert (obClazz != null) : "jvm bug detected (Object.getClass() == null). please report this to your vendor";
            if (obClazz.isArray()) {
                long shallowSize = RamUsageEstimator.shallowSizeOf(ob);
                final int len = Array.getLength(ob);
                Class<?> componentClazz = obClazz.getComponentType();
                AbstractList<Object> values = componentClazz.isPrimitive() ? Collections.emptyList() : new AbstractList<Object>(){

                    @Override
                    public Object get(int index) {
                        return Array.get(ob, index);
                    }

                    @Override
                    public int size() {
                        return len;
                    }
                };
                totalSize += accumulator.accumulateArray(ob, shallowSize, (List<Object>)values, stack);
                continue;
            }
            try {
                ClassCache cachedInfo = (ClassCache)classCache.get(obClazz);
                if (cachedInfo == null) {
                    cachedInfo = RamUsageTester.createCacheEntry(obClazz);
                    classCache.put(obClazz, cachedInfo);
                }
                HashMap<Field, Object> fieldValues = new HashMap<Field, Object>();
                for (Field f : cachedInfo.referenceFields) {
                    fieldValues.put(f, f.get(ob));
                }
                totalSize += accumulator.accumulateObject(ob, cachedInfo.alignedShallowInstanceSize, fieldValues, stack);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Reflective field access failed?", e);
            }
        }
        seen.clear();
        stack.clear();
        classCache.clear();
        return totalSize;
    }

    private static ClassCache createCacheEntry(Class<?> clazz) {
        long shallowInstanceSize = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        ArrayList<Field> referenceFields = new ArrayList<Field>(32);
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            Field[] fields;
            if (c == Class.class) continue;
            for (Field f : fields = c.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                shallowInstanceSize = RamUsageEstimator.adjustForField((long)shallowInstanceSize, (Field)f);
                if (f.getType().isPrimitive()) continue;
                f.setAccessible(true);
                referenceFields.add(f);
            }
        }
        ClassCache cachedInfo = new ClassCache(RamUsageEstimator.alignObjectSize((long)shallowInstanceSize), referenceFields.toArray(new Field[referenceFields.size()]));
        return cachedInfo;
    }

    static final class IdentityHashSet<KType>
    implements Iterable<KType> {
        public static final float DEFAULT_LOAD_FACTOR = 0.75f;
        public static final int MIN_CAPACITY = 4;
        public Object[] keys;
        public int assigned;
        public final float loadFactor;
        private int resizeThreshold;

        public IdentityHashSet() {
            this(16, 0.75f);
        }

        public IdentityHashSet(int initialCapacity) {
            this(initialCapacity, 0.75f);
        }

        public IdentityHashSet(int initialCapacity, float loadFactor) {
            initialCapacity = Math.max(4, initialCapacity);
            assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
            assert (loadFactor > 0.0f && loadFactor < 1.0f) : "Load factor must be between (0, 1).";
            this.loadFactor = loadFactor;
            this.allocateBuffers(this.roundCapacity(initialCapacity));
        }

        public boolean add(KType e) {
            Object existing;
            assert (e != null) : "Null keys not allowed.";
            if (this.assigned >= this.resizeThreshold) {
                this.expandAndRehash();
            }
            int mask = this.keys.length - 1;
            int slot = IdentityHashSet.rehash(e) & mask;
            while ((existing = this.keys[slot]) != null) {
                if (e == existing) {
                    return false;
                }
                slot = slot + 1 & mask;
            }
            ++this.assigned;
            this.keys[slot] = e;
            return true;
        }

        public boolean contains(KType e) {
            Object existing;
            int mask = this.keys.length - 1;
            int slot = IdentityHashSet.rehash(e) & mask;
            while ((existing = this.keys[slot]) != null) {
                if (e == existing) {
                    return true;
                }
                slot = slot + 1 & mask;
            }
            return false;
        }

        private static int rehash(Object o) {
            int k = System.identityHashCode(o);
            k ^= k >>> 16;
            k *= -2048144789;
            k ^= k >>> 13;
            k *= -1028477387;
            k ^= k >>> 16;
            return k;
        }

        private void expandAndRehash() {
            Object[] oldKeys = this.keys;
            assert (this.assigned >= this.resizeThreshold);
            this.allocateBuffers(this.nextCapacity(this.keys.length));
            int mask = this.keys.length - 1;
            for (int i = 0; i < oldKeys.length; ++i) {
                Object key = oldKeys[i];
                if (key == null) continue;
                int slot = IdentityHashSet.rehash(key) & mask;
                while (this.keys[slot] != null) {
                    slot = slot + 1 & mask;
                }
                this.keys[slot] = key;
            }
            Arrays.fill(oldKeys, null);
        }

        private void allocateBuffers(int capacity) {
            this.keys = new Object[capacity];
            this.resizeThreshold = (int)((float)capacity * 0.75f);
        }

        protected int nextCapacity(int current) {
            assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
            assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
            if (current < 2) {
                current = 2;
            }
            return current << 1;
        }

        protected int roundCapacity(int requestedCapacity) {
            int capacity;
            if (requestedCapacity > 0x40000000) {
                return 0x40000000;
            }
            for (capacity = 4; capacity < requestedCapacity; capacity <<= 1) {
            }
            return capacity;
        }

        public void clear() {
            this.assigned = 0;
            Arrays.fill(this.keys, null);
        }

        public int size() {
            return this.assigned;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Iterator<KType> iterator() {
            return new Iterator<KType>(){
                int pos = -1;
                Object nextElement = this.fetchNext();

                @Override
                public boolean hasNext() {
                    return this.nextElement != null;
                }

                @Override
                public KType next() {
                    Object r = this.nextElement;
                    if (r == null) {
                        throw new NoSuchElementException();
                    }
                    this.nextElement = this.fetchNext();
                    return r;
                }

                private Object fetchNext() {
                    ++this.pos;
                    while (this.pos < IdentityHashSet.this.keys.length && IdentityHashSet.this.keys[this.pos] == null) {
                        ++this.pos;
                    }
                    return this.pos >= IdentityHashSet.this.keys.length ? null : IdentityHashSet.this.keys[this.pos];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static final class ClassCache {
        public final long alignedShallowInstanceSize;
        public final Field[] referenceFields;

        public ClassCache(long alignedShallowInstanceSize, Field[] referenceFields) {
            this.alignedShallowInstanceSize = alignedShallowInstanceSize;
            this.referenceFields = referenceFields;
        }
    }

    public static class Accumulator {
        public long accumulateObject(Object o, long shallowSize, Map<Field, Object> fieldValues, Collection<Object> queue) {
            for (Object value : fieldValues.values()) {
                queue.add(value);
            }
            return shallowSize;
        }

        public long accumulateArray(Object array, long shallowSize, List<Object> values, Collection<Object> queue) {
            queue.addAll(values);
            return shallowSize;
        }
    }
}

