/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.VirtualMethod;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public class AssertingAtomicReader
extends FilterAtomicReader {
    static final VirtualMethod<TermsEnum> SEEK_EXACT = new VirtualMethod(TermsEnum.class, "seekExact", new Class[]{BytesRef.class});
    private final Object cacheKey = new Object();

    public AssertingAtomicReader(AtomicReader in) {
        super(in);
        assert (in.maxDoc() >= 0);
        assert (in.numDocs() <= in.maxDoc());
        assert (in.numDeletedDocs() + in.numDocs() == in.maxDoc());
        assert (!in.hasDeletions() || in.numDeletedDocs() > 0 && in.numDocs() < in.maxDoc());
    }

    public Fields fields() throws IOException {
        Fields fields = super.fields();
        return fields == null ? null : new AssertingFields(fields);
    }

    public Fields getTermVectors(int docID) throws IOException {
        Fields fields = super.getTermVectors(docID);
        return fields == null ? null : new AssertingFields(fields);
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        NumericDocValues dv = super.getNumericDocValues(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (dv != null) {
            assert (fi != null);
            assert (fi.getDocValuesType() == FieldInfo.DocValuesType.NUMERIC);
            return new AssertingNumericDocValues(dv, this.maxDoc());
        }
        assert (fi == null || fi.getDocValuesType() != FieldInfo.DocValuesType.NUMERIC);
        return null;
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        BinaryDocValues dv = super.getBinaryDocValues(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (dv != null) {
            assert (fi != null);
            assert (fi.getDocValuesType() == FieldInfo.DocValuesType.BINARY);
            return new AssertingBinaryDocValues(dv, this.maxDoc());
        }
        assert (fi == null || fi.getDocValuesType() != FieldInfo.DocValuesType.BINARY);
        return null;
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        SortedDocValues dv = super.getSortedDocValues(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (dv != null) {
            assert (fi != null);
            assert (fi.getDocValuesType() == FieldInfo.DocValuesType.SORTED);
            return new AssertingSortedDocValues(dv, this.maxDoc());
        }
        assert (fi == null || fi.getDocValuesType() != FieldInfo.DocValuesType.SORTED);
        return null;
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        SortedNumericDocValues dv = super.getSortedNumericDocValues(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (dv != null) {
            assert (fi != null);
            assert (fi.getDocValuesType() == FieldInfo.DocValuesType.SORTED_NUMERIC);
            return new AssertingSortedNumericDocValues(dv, this.maxDoc());
        }
        assert (fi == null || fi.getDocValuesType() != FieldInfo.DocValuesType.SORTED_NUMERIC);
        return null;
    }

    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        SortedSetDocValues dv = super.getSortedSetDocValues(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (dv != null) {
            assert (fi != null);
            assert (fi.getDocValuesType() == FieldInfo.DocValuesType.SORTED_SET);
            return new AssertingSortedSetDocValues(dv, this.maxDoc());
        }
        assert (fi == null || fi.getDocValuesType() != FieldInfo.DocValuesType.SORTED_SET);
        return null;
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        NumericDocValues dv = super.getNormValues(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (dv != null) {
            assert (fi != null);
            assert (fi.hasNorms());
            return new AssertingNumericDocValues(dv, this.maxDoc());
        }
        assert (fi == null || !fi.hasNorms());
        return null;
    }

    public Bits getLiveDocs() {
        Bits liveDocs = super.getLiveDocs();
        if (liveDocs != null) {
            assert (this.maxDoc() == liveDocs.length());
            liveDocs = new AssertingBits(liveDocs);
        } else {
            assert (this.maxDoc() == this.numDocs());
            assert (!this.hasDeletions());
        }
        return liveDocs;
    }

    public Bits getDocsWithField(String field) throws IOException {
        Bits docsWithField = super.getDocsWithField(field);
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (docsWithField != null) {
            assert (fi != null);
            assert (fi.hasDocValues());
            assert (this.maxDoc() == docsWithField.length());
            docsWithField = new AssertingBits(docsWithField);
        } else assert (fi == null || !fi.hasDocValues());
        return docsWithField;
    }

    public Object getCoreCacheKey() {
        return this.cacheKey;
    }

    public Object getCombinedCoreAndDeletesKey() {
        return this.cacheKey;
    }

    public static class AssertingBits
    implements Bits {
        final Bits in;

        public AssertingBits(Bits in) {
            this.in = in;
        }

        public boolean get(int index) {
            assert (index >= 0 && index < this.length());
            return this.in.get(index);
        }

        public int length() {
            return this.in.length();
        }
    }

    public static class AssertingSortedSetDocValues
    extends SortedSetDocValues {
        private final SortedSetDocValues in;
        private final int maxDoc;
        private final long valueCount;
        long lastOrd = -1L;

        public AssertingSortedSetDocValues(SortedSetDocValues in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
            this.valueCount = in.getValueCount();
            assert (this.valueCount >= 0L);
        }

        public long nextOrd() {
            assert (this.lastOrd != -1L);
            long ord = this.in.nextOrd();
            assert (ord < this.valueCount);
            assert (ord == -1L || ord > this.lastOrd);
            this.lastOrd = ord;
            return ord;
        }

        public void setDocument(int docID) {
            assert (docID >= 0 && docID < this.maxDoc) : "docid=" + docID + ",maxDoc=" + this.maxDoc;
            this.in.setDocument(docID);
            this.lastOrd = -2L;
        }

        public BytesRef lookupOrd(long ord) {
            assert (ord >= 0L && ord < this.valueCount);
            BytesRef result = this.in.lookupOrd(ord);
            assert (result.isValid());
            return result;
        }

        public long getValueCount() {
            long valueCount = this.in.getValueCount();
            assert (valueCount == this.valueCount);
            return valueCount;
        }

        public long lookupTerm(BytesRef key) {
            assert (key.isValid());
            long result = this.in.lookupTerm(key);
            assert (result < this.valueCount);
            assert (key.isValid());
            return result;
        }
    }

    public static class AssertingSortedNumericDocValues
    extends SortedNumericDocValues {
        private final SortedNumericDocValues in;
        private final int maxDoc;

        public AssertingSortedNumericDocValues(SortedNumericDocValues in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
        }

        public void setDocument(int doc) {
            assert (doc >= 0 && doc < this.maxDoc);
            this.in.setDocument(doc);
            long previous = Long.MIN_VALUE;
            for (int i = 0; i < this.in.count(); ++i) {
                long v = this.in.valueAt(i);
                assert (v >= previous);
                previous = v;
            }
        }

        public long valueAt(int index) {
            assert (index < this.in.count());
            return this.in.valueAt(index);
        }

        public int count() {
            return this.in.count();
        }
    }

    public static class AssertingSortedDocValues
    extends SortedDocValues {
        private final SortedDocValues in;
        private final int maxDoc;
        private final int valueCount;

        public AssertingSortedDocValues(SortedDocValues in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
            this.valueCount = in.getValueCount();
            assert (this.valueCount >= 0 && this.valueCount <= maxDoc);
        }

        public int getOrd(int docID) {
            assert (docID >= 0 && docID < this.maxDoc);
            int ord = this.in.getOrd(docID);
            assert (ord >= -1 && ord < this.valueCount);
            return ord;
        }

        public BytesRef lookupOrd(int ord) {
            assert (ord >= 0 && ord < this.valueCount);
            BytesRef result = this.in.lookupOrd(ord);
            assert (result.isValid());
            return result;
        }

        public int getValueCount() {
            int valueCount = this.in.getValueCount();
            assert (valueCount == this.valueCount);
            return valueCount;
        }

        public BytesRef get(int docID) {
            assert (docID >= 0 && docID < this.maxDoc);
            BytesRef result = this.in.get(docID);
            assert (result.isValid());
            return result;
        }

        public int lookupTerm(BytesRef key) {
            assert (key.isValid());
            int result = this.in.lookupTerm(key);
            assert (result < this.valueCount);
            assert (key.isValid());
            return result;
        }
    }

    public static class AssertingBinaryDocValues
    extends BinaryDocValues {
        private final BinaryDocValues in;
        private final int maxDoc;

        public AssertingBinaryDocValues(BinaryDocValues in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
        }

        public BytesRef get(int docID) {
            assert (docID >= 0 && docID < this.maxDoc);
            BytesRef result = this.in.get(docID);
            assert (result.isValid());
            return result;
        }
    }

    public static class AssertingNumericDocValues
    extends NumericDocValues {
        private final NumericDocValues in;
        private final int maxDoc;

        public AssertingNumericDocValues(NumericDocValues in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
        }

        public long get(int docID) {
            assert (docID >= 0 && docID < this.maxDoc);
            return this.in.get(docID);
        }
    }

    static class AssertingDocsAndPositionsEnum
    extends FilterAtomicReader.FilterDocsAndPositionsEnum {
        private DocsEnumState state = DocsEnumState.START;
        private int positionMax = 0;
        private int positionCount = 0;
        private int doc;

        public AssertingDocsAndPositionsEnum(DocsAndPositionsEnum in) {
            super(in);
            int docid = in.docID();
            assert (docid == -1) : "invalid initial doc id: " + docid;
            this.doc = -1;
        }

        public int nextDoc() throws IOException {
            assert (this.state != DocsEnumState.FINISHED) : "nextDoc() called after NO_MORE_DOCS";
            int nextDoc = super.nextDoc();
            assert (nextDoc > this.doc) : "backwards nextDoc from " + this.doc + " to " + nextDoc;
            this.positionCount = 0;
            if (nextDoc == Integer.MAX_VALUE) {
                this.state = DocsEnumState.FINISHED;
                this.positionMax = 0;
            } else {
                this.state = DocsEnumState.ITERATING;
                this.positionMax = super.freq();
            }
            assert (super.docID() == nextDoc);
            this.doc = nextDoc;
            return this.doc;
        }

        public int advance(int target) throws IOException {
            assert (this.state != DocsEnumState.FINISHED) : "advance() called after NO_MORE_DOCS";
            assert (target > this.doc) : "target must be > docID(), got " + target + " <= " + this.doc;
            int advanced = super.advance(target);
            assert (advanced >= target) : "backwards advance from: " + target + " to: " + advanced;
            this.positionCount = 0;
            if (advanced == Integer.MAX_VALUE) {
                this.state = DocsEnumState.FINISHED;
                this.positionMax = 0;
            } else {
                this.state = DocsEnumState.ITERATING;
                this.positionMax = super.freq();
            }
            assert (super.docID() == advanced);
            this.doc = advanced;
            return this.doc;
        }

        public int docID() {
            assert (this.doc == super.docID()) : " invalid docID() in " + this.in.getClass() + " " + super.docID() + " instead of " + this.doc;
            return this.doc;
        }

        public int freq() throws IOException {
            assert (this.state != DocsEnumState.START) : "freq() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "freq() called after NO_MORE_DOCS";
            int freq = super.freq();
            assert (freq > 0);
            return freq;
        }

        public int nextPosition() throws IOException {
            assert (this.state != DocsEnumState.START) : "nextPosition() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "nextPosition() called after NO_MORE_DOCS";
            assert (this.positionCount < this.positionMax) : "nextPosition() called more than freq() times!";
            int position = super.nextPosition();
            assert (position >= 0 || position == -1) : "invalid position: " + position;
            ++this.positionCount;
            return position;
        }

        public int startOffset() throws IOException {
            assert (this.state != DocsEnumState.START) : "startOffset() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "startOffset() called after NO_MORE_DOCS";
            assert (this.positionCount > 0) : "startOffset() called before nextPosition()!";
            return super.startOffset();
        }

        public int endOffset() throws IOException {
            assert (this.state != DocsEnumState.START) : "endOffset() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "endOffset() called after NO_MORE_DOCS";
            assert (this.positionCount > 0) : "endOffset() called before nextPosition()!";
            return super.endOffset();
        }

        public BytesRef getPayload() throws IOException {
            assert (this.state != DocsEnumState.START) : "getPayload() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "getPayload() called after NO_MORE_DOCS";
            assert (this.positionCount > 0) : "getPayload() called before nextPosition()!";
            BytesRef payload = super.getPayload();
            assert (payload == null || payload.isValid() && payload.length > 0) : "getPayload() returned payload with invalid length!";
            return payload;
        }
    }

    public static class AssertingDocsEnum
    extends FilterAtomicReader.FilterDocsEnum {
        private DocsEnumState state;
        private int doc;

        public AssertingDocsEnum(DocsEnum in) {
            this(in, true);
        }

        public AssertingDocsEnum(DocsEnum in, boolean failOnUnsupportedDocID) {
            block3: {
                super(in);
                this.state = DocsEnumState.START;
                try {
                    int docid = in.docID();
                    assert (docid == -1) : in.getClass() + ": invalid initial doc id: " + docid;
                }
                catch (UnsupportedOperationException e) {
                    if (!failOnUnsupportedDocID) break block3;
                    throw e;
                }
            }
            this.doc = -1;
        }

        public int nextDoc() throws IOException {
            assert (this.state != DocsEnumState.FINISHED) : "nextDoc() called after NO_MORE_DOCS";
            int nextDoc = super.nextDoc();
            assert (nextDoc > this.doc) : "backwards nextDoc from " + this.doc + " to " + nextDoc + " " + this.in;
            this.state = nextDoc == Integer.MAX_VALUE ? DocsEnumState.FINISHED : DocsEnumState.ITERATING;
            assert (super.docID() == nextDoc);
            this.doc = nextDoc;
            return this.doc;
        }

        public int advance(int target) throws IOException {
            assert (this.state != DocsEnumState.FINISHED) : "advance() called after NO_MORE_DOCS";
            assert (target > this.doc) : "target must be > docID(), got " + target + " <= " + this.doc;
            int advanced = super.advance(target);
            assert (advanced >= target) : "backwards advance from: " + target + " to: " + advanced;
            this.state = advanced == Integer.MAX_VALUE ? DocsEnumState.FINISHED : DocsEnumState.ITERATING;
            assert (super.docID() == advanced);
            this.doc = advanced;
            return this.doc;
        }

        public int docID() {
            assert (this.doc == super.docID()) : " invalid docID() in " + this.in.getClass() + " " + super.docID() + " instead of " + this.doc;
            return this.doc;
        }

        public int freq() throws IOException {
            assert (this.state != DocsEnumState.START) : "freq() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "freq() called after NO_MORE_DOCS";
            int freq = super.freq();
            assert (freq > 0);
            return freq;
        }
    }

    static enum DocsEnumState {
        START,
        ITERATING,
        FINISHED;

    }

    static class AssertingTermsEnum
    extends FilterAtomicReader.FilterTermsEnum {
        private State state = State.INITIAL;
        private final boolean delegateOverridesSeekExact;

        public AssertingTermsEnum(TermsEnum in) {
            super(in);
            this.delegateOverridesSeekExact = SEEK_EXACT.isOverriddenAsOf(in.getClass());
        }

        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
            DocsEnum docs;
            assert (this.state == State.POSITIONED) : "docs(...) called on unpositioned TermsEnum";
            if (reuse instanceof AssertingDocsEnum) {
                reuse = ((AssertingDocsEnum)reuse).in;
            }
            return (docs = super.docs(liveDocs, reuse, flags)) == null ? null : new AssertingDocsEnum(docs);
        }

        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
            DocsAndPositionsEnum docs;
            assert (this.state == State.POSITIONED) : "docsAndPositions(...) called on unpositioned TermsEnum";
            if (reuse instanceof AssertingDocsAndPositionsEnum) {
                reuse = ((AssertingDocsAndPositionsEnum)reuse).in;
            }
            return (docs = super.docsAndPositions(liveDocs, reuse, flags)) == null ? null : new AssertingDocsAndPositionsEnum(docs);
        }

        public BytesRef next() throws IOException {
            assert (this.state == State.INITIAL || this.state == State.POSITIONED) : "next() called on unpositioned TermsEnum";
            BytesRef result = super.next();
            if (result == null) {
                this.state = State.UNPOSITIONED;
            } else {
                assert (result.isValid());
                this.state = State.POSITIONED;
            }
            return result;
        }

        public long ord() throws IOException {
            assert (this.state == State.POSITIONED) : "ord() called on unpositioned TermsEnum";
            return super.ord();
        }

        public int docFreq() throws IOException {
            assert (this.state == State.POSITIONED) : "docFreq() called on unpositioned TermsEnum";
            return super.docFreq();
        }

        public long totalTermFreq() throws IOException {
            assert (this.state == State.POSITIONED) : "totalTermFreq() called on unpositioned TermsEnum";
            return super.totalTermFreq();
        }

        public BytesRef term() throws IOException {
            assert (this.state == State.POSITIONED) : "term() called on unpositioned TermsEnum";
            BytesRef ret = super.term();
            assert (ret == null || ret.isValid());
            return ret;
        }

        public void seekExact(long ord) throws IOException {
            super.seekExact(ord);
            this.state = State.POSITIONED;
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef term) throws IOException {
            assert (term.isValid());
            TermsEnum.SeekStatus result = super.seekCeil(term);
            this.state = result == TermsEnum.SeekStatus.END ? State.UNPOSITIONED : State.POSITIONED;
            return result;
        }

        public boolean seekExact(BytesRef text) throws IOException {
            assert (text.isValid());
            boolean result = this.delegateOverridesSeekExact ? this.in.seekExact(text) : super.seekExact(text);
            this.state = result ? State.POSITIONED : State.UNPOSITIONED;
            return result;
        }

        public TermState termState() throws IOException {
            assert (this.state == State.POSITIONED) : "termState() called on unpositioned TermsEnum";
            return super.termState();
        }

        public void seekExact(BytesRef term, TermState state) throws IOException {
            assert (term.isValid());
            super.seekExact(term, state);
            this.state = State.POSITIONED;
        }

        public String toString() {
            return "AssertingTermsEnum(" + this.in + ")";
        }

        private static enum State {
            INITIAL,
            POSITIONED,
            UNPOSITIONED;

        }
    }

    public static class AssertingTerms
    extends FilterAtomicReader.FilterTerms {
        public AssertingTerms(Terms in) {
            super(in);
        }

        public TermsEnum intersect(CompiledAutomaton automaton, BytesRef bytes) throws IOException {
            TermsEnum termsEnum = this.in.intersect(automaton, bytes);
            assert (termsEnum != null);
            assert (bytes == null || bytes.isValid());
            return new AssertingTermsEnum(termsEnum);
        }

        public BytesRef getMin() throws IOException {
            BytesRef v = this.in.getMin();
            assert (v == null || v.isValid());
            return v;
        }

        public BytesRef getMax() throws IOException {
            BytesRef v = this.in.getMax();
            assert (v == null || v.isValid());
            return v;
        }

        public TermsEnum iterator(TermsEnum reuse) throws IOException {
            if (reuse instanceof AssertingTermsEnum) {
                reuse = ((AssertingTermsEnum)reuse).in;
            }
            TermsEnum termsEnum = super.iterator(reuse);
            assert (termsEnum != null);
            return new AssertingTermsEnum(termsEnum);
        }
    }

    public static class AssertingFields
    extends FilterAtomicReader.FilterFields {
        public AssertingFields(Fields in) {
            super(in);
        }

        public Iterator<String> iterator() {
            Iterator iterator = super.iterator();
            assert (iterator != null);
            return iterator;
        }

        public Terms terms(String field) throws IOException {
            Terms terms = super.terms(field);
            return terms == null ? null : new AssertingTerms(terms);
        }
    }
}

