/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene42;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.packed.BlockPackedWriter;
import org.apache.lucene.util.packed.PackedInts;

class Lucene42NormsConsumer
extends DocValuesConsumer {
    static final byte NUMBER = 0;
    static final int BLOCK_SIZE = 4096;
    static final byte DELTA_COMPRESSED = 0;
    static final byte TABLE_COMPRESSED = 1;
    static final byte UNCOMPRESSED = 2;
    static final byte GCD_COMPRESSED = 3;
    IndexOutput data;
    IndexOutput meta;
    final int maxDoc;
    final float acceptableOverheadRatio;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene42NormsConsumer(SegmentWriteState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension, float acceptableOverheadRatio) throws IOException {
        this.acceptableOverheadRatio = acceptableOverheadRatio;
        this.maxDoc = state.segmentInfo.getDocCount();
        boolean success = false;
        try {
            String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeHeader((DataOutput)this.data, (String)dataCodec, (int)2);
            String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeHeader((DataOutput)this.meta, (String)metaCodec, (int)2);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
    }

    public void addNumericField(FieldInfo field, Iterable<Number> values) throws IOException {
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)0);
        this.meta.writeLong(this.data.getFilePointer());
        long minValue = Long.MAX_VALUE;
        long maxValue = Long.MIN_VALUE;
        long gcd = 0L;
        HashSet<Long> uniqueValues = null;
        uniqueValues = new HashSet<Long>();
        long count = 0L;
        for (Number nv : values) {
            assert (nv != null);
            long v = nv.longValue();
            if (gcd != 1L) {
                if (v < -4611686018427387904L || v > 0x3FFFFFFFFFFFFFFFL) {
                    gcd = 1L;
                } else if (count != 0L) {
                    gcd = MathUtil.gcd((long)gcd, (long)(v - minValue));
                }
            }
            minValue = Math.min(minValue, v);
            maxValue = Math.max(maxValue, v);
            if (uniqueValues != null && uniqueValues.add(v) && uniqueValues.size() > 256) {
                uniqueValues = null;
            }
            ++count;
        }
        assert (count == (long)this.maxDoc);
        if (uniqueValues != null) {
            int bitsPerValue = PackedInts.bitsRequired((long)(uniqueValues.size() - 1));
            PackedInts.FormatAndBits formatAndBits = PackedInts.fastestFormatAndBits((int)this.maxDoc, (int)bitsPerValue, (float)this.acceptableOverheadRatio);
            if (formatAndBits.bitsPerValue == 8 && minValue >= -128L && maxValue <= 127L) {
                this.meta.writeByte((byte)2);
                for (Number nv : values) {
                    this.data.writeByte(nv == null ? (byte)0 : (byte)nv.longValue());
                }
            } else {
                this.meta.writeByte((byte)1);
                Long[] decode = uniqueValues.toArray(new Long[uniqueValues.size()]);
                HashMap<Long, Integer> encode = new HashMap<Long, Integer>();
                this.data.writeVInt(decode.length);
                for (int i = 0; i < decode.length; ++i) {
                    this.data.writeLong(decode[i].longValue());
                    encode.put(decode[i], i);
                }
                this.meta.writeVInt(2);
                this.data.writeVInt(formatAndBits.format.getId());
                this.data.writeVInt(formatAndBits.bitsPerValue);
                PackedInts.Writer writer = PackedInts.getWriterNoHeader((DataOutput)this.data, (PackedInts.Format)formatAndBits.format, (int)this.maxDoc, (int)formatAndBits.bitsPerValue, (int)1024);
                for (Number nv : values) {
                    writer.add((long)((Integer)encode.get(nv == null ? 0L : nv.longValue())).intValue());
                }
                writer.finish();
            }
        } else if (gcd != 0L && gcd != 1L) {
            this.meta.writeByte((byte)3);
            this.meta.writeVInt(2);
            this.data.writeLong(minValue);
            this.data.writeLong(gcd);
            this.data.writeVInt(4096);
            BlockPackedWriter writer = new BlockPackedWriter((DataOutput)this.data, 4096);
            for (Number nv : values) {
                long value = nv == null ? 0L : nv.longValue();
                writer.add((value - minValue) / gcd);
            }
            writer.finish();
        } else {
            this.meta.writeByte((byte)0);
            this.meta.writeVInt(2);
            this.data.writeVInt(4096);
            BlockPackedWriter writer = new BlockPackedWriter((DataOutput)this.data, 4096);
            for (Number nv : values) {
                writer.add(nv == null ? 0L : nv.longValue());
            }
            writer.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block7: {
            block6: {
                boolean success = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeVInt(-1);
                        CodecUtil.writeFooter((IndexOutput)this.meta);
                    }
                    if (this.data != null) {
                        CodecUtil.writeFooter((IndexOutput)this.data);
                    }
                    if (!(success = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{this.data, this.meta});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data, this.meta});
                    }
                    this.data = null;
                    this.meta = null;
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{this.data, this.meta});
                break block7;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data, this.meta});
        }
        this.data = null;
        this.meta = null;
    }

    public void addBinaryField(FieldInfo field, Iterable<BytesRef> values) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void addSortedField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrd) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void addSortedNumericField(FieldInfo field, Iterable<Number> docToValueCount, Iterable<Number> values) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void addSortedSetField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrdCount, Iterable<Number> ords) throws IOException {
        throw new UnsupportedOperationException();
    }
}

