/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class SaslAuthFailTest
extends ClientBase {
    private AtomicInteger authFailed = new AtomicInteger(0);

    protected TestableZooKeeper createClient(String hp) throws IOException, InterruptedException {
        MyWatcher watcher = new MyWatcher();
        return this.createClient(watcher, hp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadSaslAuthNotifiesWatch() throws Exception {
        TestableZooKeeper zk = this.createClient();
        AtomicInteger atomicInteger = this.authFailed;
        synchronized (atomicInteger) {
            this.authFailed.wait();
        }
        Assert.assertEquals((long)this.authFailed.get(), (long)1L);
        zk.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthFail() throws Exception {
        TestableZooKeeper zk = this.createClient();
        try {
            zk.create("/path1", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            Assert.fail((String)"Should have gotten exception.");
        }
        catch (Exception e) {
            LOG.info("Got exception as expected: " + e);
        }
        finally {
            zk.close();
        }
    }

    static {
        System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        System.setProperty("zookeeper.allowSaslFailedClients", "true");
        try {
            File tmpDir = SaslAuthFailTest.createTmpDir();
            File saslConfFile = new File(tmpDir, "jaas.conf");
            FileWriter fwriter = new FileWriter(saslConfFile);
            fwriter.write("Server {\n          org.apache.zookeeper.server.auth.DigestLoginModule required\n          user_super=\"test\";\n};\nClient {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"super\"\n       password=\"test1\";\n};\n");
            fwriter.close();
            System.setProperty("java.security.auth.login.config", saslConfFile.getAbsolutePath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        private MyWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.AuthFailed) {
                AtomicInteger atomicInteger = SaslAuthFailTest.this.authFailed;
                synchronized (atomicInteger) {
                    SaslAuthFailTest.this.authFailed.incrementAndGet();
                    SaslAuthFailTest.this.authFailed.notify();
                }
            } else {
                super.process(event);
            }
        }
    }
}

