/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.FastLeaderElection;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLENewEpochTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(FLENewEpochTest.class);
    int count;
    HashMap<Long, QuorumPeer.QuorumServer> peers;
    ArrayList<LEThread> threads;
    File[] tmpdir;
    int[] port;
    volatile int[] round;
    Semaphore start0;
    Semaphore finish3;
    Semaphore finish0;

    @Before
    public void setUp() throws Exception {
        this.count = 3;
        this.peers = new HashMap(this.count);
        this.threads = new ArrayList(this.count);
        this.tmpdir = new File[this.count];
        this.port = new int[this.count];
        this.round = new int[3];
        this.round[0] = 0;
        this.round[1] = 0;
        this.round[2] = 0;
        this.start0 = new Semaphore(0);
        this.finish0 = new Semaphore(0);
        this.finish3 = new Semaphore(0);
    }

    @After
    public void tearDown() throws Exception {
        for (int i = 0; i < this.threads.size(); ++i) {
            ((FastLeaderElection)this.threads.get((int)i).peer.getElectionAlg()).shutdown();
        }
    }

    @Test
    public void testLENewEpoch() throws Exception {
        int i;
        FastLeaderElection[] le = new FastLeaderElection[this.count];
        LOG.info("TestLE: " + this.getTestName() + ", " + this.count);
        for (i = 0; i < this.count; ++i) {
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer((long)i, new InetSocketAddress(PortAssignment.unique()), new InetSocketAddress(PortAssignment.unique())));
            this.tmpdir[i] = ClientBase.createTmpDir();
            this.port[i] = PortAssignment.unique();
        }
        for (i = 1; i < le.length; ++i) {
            QuorumPeer peer = new QuorumPeer(this.peers, this.tmpdir[i], this.tmpdir[i], this.port[i], 3, (long)i, 1000, 2, 2);
            peer.startLeaderElection();
            LEThread thread = new LEThread(peer, i);
            thread.start();
            this.threads.add(thread);
        }
        if (!this.start0.tryAcquire(4000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"First leader election failed");
        }
        QuorumPeer peer = new QuorumPeer(this.peers, this.tmpdir[0], this.tmpdir[0], this.port[0], 3, 0L, 1000, 2, 2);
        peer.startLeaderElection();
        LEThread thread = new LEThread(peer, 0);
        thread.start();
        this.threads.add(thread);
        LOG.info("Started threads " + this.getTestName());
        for (int i2 = 0; i2 < this.threads.size(); ++i2) {
            this.threads.get(i2).join(10000L);
            if (!this.threads.get(i2).isAlive()) continue;
            Assert.fail((String)"Threads didn't join");
        }
    }

    class LEThread
    extends Thread {
        int i;
        QuorumPeer peer;

        LEThread(QuorumPeer peer, int i) {
            this.i = i;
            this.peer = peer;
            LOG.info("Constructor: " + this.getName());
        }

        public void run() {
            boolean flag = true;
            try {
                while (flag) {
                    Vote v = null;
                    this.peer.setPeerState(QuorumPeer.ServerState.LOOKING);
                    LOG.info("Going to call leader election again: " + this.i);
                    v = this.peer.getElectionAlg().lookForLeader();
                    if (v == null) {
                        Assert.fail((String)("Thread " + this.i + " got a null vote"));
                    }
                    this.peer.setCurrentVote(v);
                    LOG.info("Finished election: " + this.i + ", " + v.getId());
                    switch (this.i) {
                        case 0: {
                            LOG.info("First peer, do nothing, just join");
                            if (!FLENewEpochTest.this.finish0.tryAcquire(1000L, TimeUnit.MILLISECONDS)) break;
                            LOG.info("Setting flag to false");
                            flag = false;
                            break;
                        }
                        case 1: {
                            LOG.info("Second entering case");
                            if (FLENewEpochTest.this.round[1] != 0) {
                                FLENewEpochTest.this.finish0.release();
                                flag = false;
                            } else {
                                FLENewEpochTest.this.finish3.acquire();
                                FLENewEpochTest.this.start0.release();
                            }
                            LOG.info("Second is going to start second round");
                            FLENewEpochTest.this.round[1] = FLENewEpochTest.this.round[1] + 1;
                            break;
                        }
                        case 2: {
                            LOG.info("Third peer, shutting it down");
                            QuorumBase.shutdown(this.peer);
                            flag = false;
                            FLENewEpochTest.this.round[2] = 1;
                            FLENewEpochTest.this.finish3.release();
                            LOG.info("Third leaving");
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

