/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DataTree;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTreeTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(DataTreeTest.class);
    private DataTree dt;

    @Before
    public void setUp() throws Exception {
        this.dt = new DataTree();
    }

    @After
    public void tearDown() throws Exception {
        this.dt = null;
    }

    @Test
    public void testRootWatchTriggered() throws Exception {
        class MyWatcher
        implements Watcher {
            boolean fired = false;

            MyWatcher() {
            }

            public void process(WatchedEvent event) {
                if (event.getPath().equals("/")) {
                    this.fired = true;
                }
            }
        }
        MyWatcher watcher = new MyWatcher();
        this.dt.getChildren("/", new Stat(), (Watcher)watcher);
        this.dt.createNode("/xyz", new byte[0], null, 0L, this.dt.getNode((String)"/").stat.getCversion() + 1, 1L, 1L);
        Assert.assertFalse((String)"Root node watch not triggered", (!watcher.fired ? 1 : 0) != 0);
    }

    @Test
    public void testIncrementCversion() throws Exception {
        this.dt.createNode("/test", new byte[0], null, 0L, this.dt.getNode((String)"/").stat.getCversion() + 1, 1L, 1L);
        DataNode zk = this.dt.getNode("/test");
        int prevCversion = zk.stat.getCversion();
        long prevPzxid = zk.stat.getPzxid();
        this.dt.setCversionPzxid("/test/", prevCversion + 1, prevPzxid + 1L);
        int newCversion = zk.stat.getCversion();
        long newPzxid = zk.stat.getPzxid();
        Assert.assertTrue((String)("<cversion, pzxid> verification failed. Expected: <" + (prevCversion + 1) + ", " + (prevPzxid + 1L) + ">, found: <" + newCversion + ", " + newPzxid + ">"), (newCversion == prevCversion + 1 && newPzxid == prevPzxid + 1L ? 1 : 0) != 0);
    }
}

