/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import com.sun.management.UnixOperatingSystemMXBean;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServerConnection;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.FourLetterWordMain;
import org.apache.zookeeper.common.IOUtils;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxnFactoryAccessor;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.JMXEnv;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientBase
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(ClientBase.class);
    public static int CONNECTION_TIMEOUT = 30000;
    static final File BASETEST = new File(System.getProperty("build.test.dir", "build"));
    protected String hostPort = "127.0.0.1:" + PortAssignment.unique();
    protected int maxCnxns = 0;
    protected ServerCnxnFactory serverFactory = null;
    protected File tmpDir = null;
    long initialFdCount;
    private LinkedList<ZooKeeper> allClients;
    private boolean allClientsSetup = false;

    protected TestableZooKeeper createClient() throws IOException, InterruptedException {
        return this.createClient(this.hostPort);
    }

    protected TestableZooKeeper createClient(String hp) throws IOException, InterruptedException {
        CountdownWatcher watcher = new CountdownWatcher();
        return this.createClient(watcher, hp);
    }

    protected TestableZooKeeper createClient(CountdownWatcher watcher) throws IOException, InterruptedException {
        return this.createClient(watcher, this.hostPort);
    }

    protected TestableZooKeeper createClient(CountdownWatcher watcher, String hp) throws IOException, InterruptedException {
        return this.createClient(watcher, hp, CONNECTION_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TestableZooKeeper createClient(CountdownWatcher watcher, String hp, int timeout) throws IOException, InterruptedException {
        watcher.reset();
        TestableZooKeeper zk = new TestableZooKeeper(hp, timeout, watcher);
        if (!watcher.clientConnected.await(timeout, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"Unable to connect to server");
        }
        ClientBase clientBase = this;
        synchronized (clientBase) {
            if (!this.allClientsSetup) {
                LOG.error("allClients never setup");
                Assert.fail((String)"allClients never setup");
            }
            if (this.allClients != null) {
                this.allClients.add(zk);
            } else {
                zk.close();
            }
        }
        JMXEnv.ensureAll("0x" + Long.toHexString(zk.getSessionId()));
        return zk;
    }

    public static List<HostPort> parseHostPortList(String hplist) {
        ArrayList<HostPort> alist = new ArrayList<HostPort>();
        for (String hp : hplist.split(",")) {
            int port;
            int idx = hp.lastIndexOf(58);
            String host = hp.substring(0, idx);
            try {
                port = Integer.parseInt(hp.substring(idx + 1));
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Problem parsing " + hp + e.toString());
            }
            alist.add(new HostPort(host, port));
        }
        return alist;
    }

    public static boolean waitForServerUp(String hp, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                HostPort hpobj = ClientBase.parseHostPortList(hp).get(0);
                String result = FourLetterWordMain.send4LetterWord((String)hpobj.host, (int)hpobj.port, (String)"stat");
                if (result.startsWith("Zookeeper version:") && !result.contains("READ-ONLY")) {
                    return true;
                }
            }
            catch (IOException e) {
                LOG.info("server " + hp + " not up " + e);
            }
            if (System.currentTimeMillis() > start + timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {}
        }
        return false;
    }

    public static boolean waitForServerDown(String hp, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                HostPort hpobj = ClientBase.parseHostPortList(hp).get(0);
                FourLetterWordMain.send4LetterWord((String)hpobj.host, (int)hpobj.port, (String)"stat");
            }
            catch (IOException e) {
                return true;
            }
            if (System.currentTimeMillis() > start + timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {}
        }
        return false;
    }

    public static boolean waitForServerState(QuorumPeer qp, int timeout, String serverState) {
        long start = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!qp.getServerState().equals(serverState)) continue;
            return true;
        } while (System.currentTimeMillis() <= start + (long)timeout);
        return false;
    }

    static void verifyThreadTerminated(Thread thread, long millis) throws InterruptedException {
        thread.join(millis);
        if (thread.isAlive()) {
            LOG.error("Thread " + thread.getName() + " : " + Arrays.toString(thread.getStackTrace()));
            Assert.assertFalse((String)("thread " + thread.getName() + " still alive after join"), (boolean)true);
        }
    }

    public static File createTmpDir() throws IOException {
        return ClientBase.createTmpDir(BASETEST);
    }

    static File createTmpDir(File parentDir) throws IOException {
        File tmpFile = File.createTempFile("test", ".junit", parentDir);
        File tmpDir = new File(tmpFile + ".dir");
        Assert.assertFalse((boolean)tmpDir.exists());
        Assert.assertTrue((boolean)tmpDir.mkdirs());
        return tmpDir;
    }

    private static int getPort(String hostPort) {
        String[] split = hostPort.split(":");
        String portstr = split[split.length - 1];
        String[] pc = portstr.split("/");
        if (pc.length > 1) {
            portstr = pc[0];
        }
        return Integer.parseInt(portstr);
    }

    public static ServerCnxnFactory createNewServerInstance(File dataDir, ServerCnxnFactory factory, String hostPort, int maxCnxns) throws IOException, InterruptedException {
        ZooKeeperServer zks = new ZooKeeperServer(dataDir, dataDir, 3000);
        int PORT = ClientBase.getPort(hostPort);
        if (factory == null) {
            factory = ServerCnxnFactory.createFactory((int)PORT, (int)maxCnxns);
        }
        factory.startup(zks);
        Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + PORT, CONNECTION_TIMEOUT));
        return factory;
    }

    static void shutdownServerInstance(ServerCnxnFactory factory, String hostPort) {
        if (factory != null) {
            ZooKeeperServer zs = ClientBase.getServer(factory);
            ZKDatabase zkDb = zs.getZKDatabase();
            factory.shutdown();
            try {
                zkDb.close();
            }
            catch (IOException ie) {
                LOG.warn("Error closing logs ", (Throwable)ie);
            }
            int PORT = ClientBase.getPort(hostPort);
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + PORT, CONNECTION_TIMEOUT));
        }
    }

    public static void setupTestEnv() {
        System.setProperty("zookeeper.preAllocSize", "100");
        FileTxnLog.setPreallocSize((long)102400L);
    }

    protected void setUpAll() throws Exception {
        this.allClients = new LinkedList();
        this.allClientsSetup = true;
    }

    @Before
    public void setUp() throws Exception {
        OperatingSystemMXBean osMbean = ManagementFactory.getOperatingSystemMXBean();
        if (osMbean != null && osMbean instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean unixos = (UnixOperatingSystemMXBean)osMbean;
            this.initialFdCount = unixos.getOpenFileDescriptorCount();
            LOG.info("Initial fdcount is: " + this.initialFdCount);
        }
        ClientBase.setupTestEnv();
        JMXEnv.setUp();
        this.setUpAll();
        this.tmpDir = ClientBase.createTmpDir(BASETEST);
        this.startServer();
        LOG.info("Client test setup finished");
    }

    protected void startServer() throws Exception {
        LOG.info("STARTING server");
        this.serverFactory = ClientBase.createNewServerInstance(this.tmpDir, this.serverFactory, this.hostPort, this.maxCnxns);
        JMXEnv.ensureOnly("InMemoryDataTree", "StandaloneServer_port");
    }

    protected void stopServer() throws Exception {
        LOG.info("STOPPING server");
        ClientBase.shutdownServerInstance(this.serverFactory, this.hostPort);
        this.serverFactory = null;
        JMXEnv.ensureOnly(new String[0]);
    }

    protected static ZooKeeperServer getServer(ServerCnxnFactory fac) {
        ZooKeeperServer zs = ServerCnxnFactoryAccessor.getZkServer(fac);
        return zs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDownAll() throws Exception {
        ClientBase clientBase = this;
        synchronized (clientBase) {
            if (this.allClients != null) {
                for (ZooKeeper zk : this.allClients) {
                    try {
                        if (zk == null) continue;
                        zk.close();
                    }
                    catch (InterruptedException e) {
                        LOG.warn("ignoring interrupt", (Throwable)e);
                    }
                }
            }
            this.allClients = null;
        }
    }

    @After
    public void tearDown() throws Exception {
        LOG.info("tearDown starting");
        this.tearDownAll();
        this.stopServer();
        if (this.tmpDir != null) {
            Assert.assertTrue((String)("delete " + this.tmpDir.toString()), (boolean)ClientBase.recursiveDelete(this.tmpDir));
        }
        this.serverFactory = null;
        JMXEnv.tearDown();
        OperatingSystemMXBean osMbean = ManagementFactory.getOperatingSystemMXBean();
        if (osMbean != null && osMbean instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean unixos = (UnixOperatingSystemMXBean)osMbean;
            long fdCount = unixos.getOpenFileDescriptorCount();
            String message = "fdcount after test is: " + fdCount + " at start it was " + this.initialFdCount;
            LOG.info(message);
            if (fdCount > this.initialFdCount) {
                LOG.info("sleeping for 20 secs");
            }
        }
    }

    public static MBeanServerConnection jmxConn() throws IOException {
        return JMXEnv.conn();
    }

    public static boolean recursiveDelete(File d) {
        if (d.isDirectory()) {
            File[] children;
            for (File f : children = d.listFiles()) {
                Assert.assertTrue((String)("delete " + f.toString()), (boolean)ClientBase.recursiveDelete(f));
            }
        }
        return d.delete();
    }

    public static void logAllStackTraces() {
        StringBuilder sb = new StringBuilder();
        sb.append("Starting logAllStackTraces()\n");
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> e : threads.entrySet()) {
            sb.append("Thread " + e.getKey().getName() + "\n");
            for (StackTraceElement elem : e.getValue()) {
                sb.append("\tat " + elem + "\n");
            }
        }
        sb.append("Ending logAllStackTraces()\n");
        LOG.error(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verifyRootOfAllServersMatch(String hostPort) throws InterruptedException, KeeperException, IOException {
        String[] parts = hostPort.split(",");
        int[] counts = new int[parts.length];
        int failed = 0;
        for (int j = 0; j < 100; ++j) {
            int[] newcounts = new int[parts.length];
            int i = 0;
            for (String hp : parts) {
                try {
                    TestableZooKeeper zk = this.createClient(hp);
                    try {
                        newcounts[i++] = zk.getChildren("/", false).size();
                    }
                    finally {
                        zk.close();
                    }
                }
                catch (Throwable t) {
                    ++failed;
                    ClientBase.logAllStackTraces();
                }
            }
            if (Arrays.equals(newcounts, counts)) {
                LOG.info("Found match with array:" + Arrays.toString(newcounts));
                counts = newcounts;
                break;
            }
            counts = newcounts;
            Thread.sleep(10000L);
            if (failed > 10) break;
        }
        String logmsg = "node count not consistent{} {}";
        for (int i = 1; i < parts.length; ++i) {
            if (counts[i - 1] != counts[i]) {
                LOG.error(logmsg, (Object)counts[i - 1], (Object)counts[i]);
                continue;
            }
            LOG.info(logmsg, (Object)counts[i - 1], (Object)counts[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            IOUtils.copyBytes((InputStream)is, (OutputStream)os, (int)1024, (boolean)true);
        }
        finally {
            is.close();
        }
        return os.toString();
    }

    public static String join(String separator, Object[] parts) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object part : parts) {
            if (!first) {
                sb.append(separator);
                first = false;
            }
            sb.append(part);
        }
        return sb.toString();
    }

    public static class HostPort {
        String host;
        int port;

        public HostPort(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }

    public static class CountdownWatcher
    implements Watcher {
        volatile CountDownLatch clientConnected;
        volatile boolean connected;

        public CountdownWatcher() {
            this.reset();
        }

        public synchronized void reset() {
            this.clientConnected = new CountDownLatch(1);
            this.connected = false;
        }

        public synchronized void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected || event.getState() == Watcher.Event.KeeperState.ConnectedReadOnly) {
                this.connected = true;
                this.notifyAll();
                this.clientConnected.countDown();
            } else {
                this.connected = false;
                this.notifyAll();
            }
        }

        public synchronized boolean isConnected() {
            return this.connected;
        }

        public synchronized void waitForConnected(long timeout) throws InterruptedException, TimeoutException {
            long expire = System.currentTimeMillis() + timeout;
            long left = timeout;
            while (!this.connected && left > 0L) {
                this.wait(left);
                left = expire - System.currentTimeMillis();
            }
            if (!this.connected) {
                throw new TimeoutException("Did not connect");
            }
        }

        public synchronized void waitForDisconnected(long timeout) throws InterruptedException, TimeoutException {
            long expire = System.currentTimeMillis() + timeout;
            long left = timeout;
            while (this.connected && left > 0L) {
                this.wait(left);
                left = expire - System.currentTimeMillis();
            }
            if (this.connected) {
                throw new TimeoutException("Did not disconnect");
            }
        }
    }

    protected class NullWatcher
    implements Watcher {
        protected NullWatcher() {
        }

        public void process(WatchedEvent event) {
        }
    }
}

