/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.metastore;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.sentry.binding.hive.HiveAuthzBindingHook;
import org.apache.sentry.binding.hive.authz.HiveAuthzBinding;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.thrift.TException;

public class SentryHiveMetaStoreClient
extends HiveMetaStoreClient
implements IMetaStoreClient {
    private HiveAuthzBinding hiveAuthzBinding;
    private HiveAuthzConf authzConf;
    private final HiveConf hiveConf;

    public SentryHiveMetaStoreClient(HiveConf conf) throws MetaException {
        super(conf);
        this.hiveConf = conf;
    }

    public SentryHiveMetaStoreClient(HiveConf conf, HiveMetaHookLoader hookLoader) throws MetaException {
        super(conf, hookLoader);
        this.hiveConf = conf;
    }

    public List<String> getDatabases(String databasePattern) throws MetaException {
        return this.filterDatabases(super.getDatabases(databasePattern));
    }

    public List<String> getAllDatabases() throws MetaException {
        return this.filterDatabases(super.getAllDatabases());
    }

    public List<String> getTables(String dbName, String tablePattern) throws MetaException {
        return this.filterTables(dbName, super.getTables(dbName, tablePattern));
    }

    public List<String> getAllTables(String dbName) throws MetaException {
        return this.filterTables(dbName, super.getAllTables(dbName));
    }

    public List<String> listTableNamesByFilter(String dbName, String filter, short maxTables) throws InvalidOperationException, UnknownDBException, TException {
        return this.filterTables(dbName, super.listTableNamesByFilter(dbName, filter, maxTables));
    }

    private List<String> filterDatabases(List<String> dbList) throws MetaException {
        try {
            return HiveAuthzBindingHook.filterShowDatabases(this.getHiveAuthzBinding(), dbList, HiveOperation.SHOWDATABASES, this.getUserName());
        }
        catch (SemanticException e) {
            throw new MetaException("Error getting DB list " + e.getMessage());
        }
    }

    private List<String> filterTables(String dbName, List<String> tabList) throws MetaException {
        try {
            return HiveAuthzBindingHook.filterShowTables(this.getHiveAuthzBinding(), tabList, HiveOperation.SHOWTABLES, this.getUserName(), dbName);
        }
        catch (SemanticException e) {
            throw new MetaException("Error getting Table list " + e.getMessage());
        }
    }

    private String getUserName() {
        return this.getConf().get("hive.sentry.subject.name");
    }

    private HiveAuthzBinding getHiveAuthzBinding() throws MetaException {
        if (this.hiveAuthzBinding == null) {
            String hiveAuthzConf = this.getConf().get("hive.sentry.conf.url");
            if (hiveAuthzConf == null || (hiveAuthzConf = hiveAuthzConf.trim()).isEmpty()) {
                throw new MetaException("Configuration key hive.sentry.conf.url value '" + hiveAuthzConf + "' is invalid.");
            }
            try {
                this.authzConf = new HiveAuthzConf(new URL(hiveAuthzConf));
            }
            catch (MalformedURLException e) {
                throw new MetaException("Configuration key hive.sentry.conf.url specifies a malformed URL '" + hiveAuthzConf + "' " + e.getMessage());
            }
            try {
                this.hiveAuthzBinding = new HiveAuthzBinding(HiveAuthzBinding.HiveHook.HiveMetaStore, this.getConf(), this.authzConf);
            }
            catch (Exception e) {
                throw new MetaException("Failed to load Hive binding " + e.getMessage());
            }
        }
        return this.hiveAuthzBinding;
    }

    private HiveConf getConf() {
        return SessionState.get().getConf();
    }
}

