/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.metastore;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.sentry.binding.hive.HiveAuthzBindingHook;
import org.apache.sentry.binding.hive.authz.HiveAuthzBinding;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;

public class AuthorizingObjectStore
extends ObjectStore {
    private static ImmutableSet<String> serviceUsers;
    private static HiveConf hiveConf;
    private static HiveAuthzConf authzConf;
    private static HiveAuthzBinding hiveAuthzBinding;
    private static String NO_ACCESS_MESSAGE_TABLE;
    private static String NO_ACCESS_MESSAGE_DATABASE;

    public List<String> getDatabases(String pattern) throws MetaException {
        return this.filterDatabases(super.getDatabases(pattern));
    }

    public List<String> getAllDatabases() throws MetaException {
        return this.filterDatabases(super.getAllDatabases());
    }

    public Database getDatabase(String name) throws NoSuchObjectException {
        Database db = super.getDatabase(name);
        try {
            if (this.filterDatabases(Lists.newArrayList((Object[])new String[]{name})).isEmpty()) {
                throw new NoSuchObjectException(this.getNoAccessMessageForDB(name));
            }
        }
        catch (MetaException e) {
            throw new NoSuchObjectException("Failed to authorized access to " + name + " : " + e.getMessage());
        }
        return db;
    }

    public Table getTable(String dbName, String tableName) throws MetaException {
        Table table = super.getTable(dbName, tableName);
        if (table == null || this.filterTables(dbName, Lists.newArrayList((Object[])new String[]{tableName})).isEmpty()) {
            return null;
        }
        return table;
    }

    public Partition getPartition(String dbName, String tableName, List<String> part_vals) throws MetaException, NoSuchObjectException {
        if (this.filterTables(dbName, Lists.newArrayList((Object[])new String[]{tableName})).isEmpty()) {
            throw new NoSuchObjectException(this.getNoAccessMessageForTable(dbName, tableName));
        }
        return super.getPartition(dbName, tableName, part_vals);
    }

    public List<Partition> getPartitions(String dbName, String tableName, int maxParts) throws MetaException, NoSuchObjectException {
        if (this.filterTables(dbName, Lists.newArrayList((Object[])new String[]{tableName})).isEmpty()) {
            throw new MetaException(this.getNoAccessMessageForTable(dbName, tableName));
        }
        return super.getPartitions(dbName, tableName, maxParts);
    }

    public List<String> getTables(String dbName, String pattern) throws MetaException {
        return this.filterTables(dbName, super.getTables(dbName, pattern));
    }

    public List<Table> getTableObjectsByName(String dbname, List<String> tableNames) throws MetaException, UnknownDBException {
        return super.getTableObjectsByName(dbname, this.filterTables(dbname, tableNames));
    }

    public List<String> getAllTables(String dbName) throws MetaException {
        return this.filterTables(dbName, super.getAllTables(dbName));
    }

    public List<String> listTableNamesByFilter(String dbName, String filter, short maxTables) throws MetaException {
        return this.filterTables(dbName, super.listTableNamesByFilter(dbName, filter, maxTables));
    }

    public List<String> listPartitionNames(String dbName, String tableName, short max_parts) throws MetaException {
        if (this.filterTables(dbName, Lists.newArrayList((Object[])new String[]{tableName})).isEmpty()) {
            throw new MetaException(this.getNoAccessMessageForTable(dbName, tableName));
        }
        return super.listPartitionNames(dbName, tableName, max_parts);
    }

    public List<String> listPartitionNamesByFilter(String dbName, String tableName, String filter, short max_parts) throws MetaException {
        if (this.filterTables(dbName, Lists.newArrayList((Object[])new String[]{tableName})).isEmpty()) {
            throw new MetaException(this.getNoAccessMessageForTable(dbName, tableName));
        }
        return super.listPartitionNamesByFilter(dbName, tableName, filter, max_parts);
    }

    public Index getIndex(String dbName, String origTableName, String indexName) throws MetaException {
        if (this.filterTables(dbName, Lists.newArrayList((Object[])new String[]{origTableName})).isEmpty()) {
            throw new MetaException(this.getNoAccessMessageForTable(dbName, origTableName));
        }
        return super.getIndex(dbName, origTableName, indexName);
    }

    public List<Index> getIndexes(String dbName, String origTableName, int max) throws MetaException {
        if (this.filterTables(dbName, Lists.newArrayList((Object[])new String[]{origTableName})).isEmpty()) {
            throw new MetaException(this.getNoAccessMessageForTable(dbName, origTableName));
        }
        return super.getIndexes(dbName, origTableName, max);
    }

    public List<String> listIndexNames(String dbName, String origTableName, short max) throws MetaException {
        if (this.filterTables(dbName, Lists.newArrayList((Object[])new String[]{origTableName})).isEmpty()) {
            throw new MetaException(this.getNoAccessMessageForTable(dbName, origTableName));
        }
        return super.listIndexNames(dbName, origTableName, max);
    }

    public List<Partition> getPartitionsByFilter(String dbName, String tblName, String filter, short maxParts) throws MetaException, NoSuchObjectException {
        if (this.filterTables(dbName, Lists.newArrayList((Object[])new String[]{tblName})).isEmpty()) {
            throw new MetaException(this.getNoAccessMessageForTable(dbName, tblName));
        }
        return super.getPartitionsByFilter(dbName, tblName, filter, maxParts);
    }

    public List<Partition> getPartitionsByNames(String dbName, String tblName, List<String> partNames) throws MetaException, NoSuchObjectException {
        if (this.filterTables(dbName, Lists.newArrayList((Object[])new String[]{tblName})).isEmpty()) {
            throw new MetaException(this.getNoAccessMessageForTable(dbName, tblName));
        }
        return super.getPartitionsByNames(dbName, tblName, partNames);
    }

    public Partition getPartitionWithAuth(String dbName, String tblName, List<String> partVals, String user_name, List<String> group_names) throws MetaException, NoSuchObjectException, InvalidObjectException {
        if (this.filterTables(dbName, Lists.newArrayList((Object[])new String[]{tblName})).isEmpty()) {
            throw new MetaException(this.getNoAccessMessageForTable(dbName, tblName));
        }
        return super.getPartitionWithAuth(dbName, tblName, partVals, user_name, group_names);
    }

    public List<Partition> getPartitionsWithAuth(String dbName, String tblName, short maxParts, String userName, List<String> groupNames) throws MetaException, NoSuchObjectException, InvalidObjectException {
        if (this.filterTables(dbName, Lists.newArrayList((Object[])new String[]{tblName})).isEmpty()) {
            throw new MetaException(this.getNoAccessMessageForTable(dbName, tblName));
        }
        return super.getPartitionsWithAuth(dbName, tblName, maxParts, userName, groupNames);
    }

    public List<String> listPartitionNamesPs(String dbName, String tblName, List<String> part_vals, short max_parts) throws MetaException, NoSuchObjectException {
        if (this.filterTables(dbName, Lists.newArrayList((Object[])new String[]{tblName})).isEmpty()) {
            throw new MetaException(this.getNoAccessMessageForTable(dbName, tblName));
        }
        return super.listPartitionNamesPs(dbName, tblName, part_vals, max_parts);
    }

    public List<Partition> listPartitionsPsWithAuth(String dbName, String tblName, List<String> part_vals, short max_parts, String userName, List<String> groupNames) throws MetaException, InvalidObjectException, NoSuchObjectException {
        if (this.filterTables(dbName, Lists.newArrayList((Object[])new String[]{tblName})).isEmpty()) {
            throw new MetaException(this.getNoAccessMessageForTable(dbName, tblName));
        }
        return super.listPartitionsPsWithAuth(dbName, tblName, part_vals, max_parts, userName, groupNames);
    }

    public ColumnStatistics getTableColumnStatistics(String dbName, String tableName, List<String> colNames) throws MetaException, NoSuchObjectException {
        if (this.filterTables(dbName, Lists.newArrayList((Object[])new String[]{tableName})).isEmpty()) {
            throw new MetaException(this.getNoAccessMessageForTable(dbName, tableName));
        }
        return super.getTableColumnStatistics(dbName, tableName, colNames);
    }

    public List<ColumnStatistics> getPartitionColumnStatistics(String dbName, String tblName, List<String> partNames, List<String> colNames) throws MetaException, NoSuchObjectException {
        if (this.filterTables(dbName, Lists.newArrayList((Object[])new String[]{tblName})).isEmpty()) {
            throw new MetaException(this.getNoAccessMessageForTable(dbName, tblName));
        }
        return super.getPartitionColumnStatistics(dbName, tblName, partNames, colNames);
    }

    private List<String> filterDatabases(List<String> dbList) throws MetaException {
        if (this.needsAuthorization(this.getUserName())) {
            try {
                return HiveAuthzBindingHook.filterShowDatabases(this.getHiveAuthzBinding(), dbList, HiveOperation.SHOWDATABASES, this.getUserName());
            }
            catch (SemanticException e) {
                throw new MetaException("Error getting DB list " + e.getMessage());
            }
        }
        return dbList;
    }

    private List<String> filterTables(String dbName, List<String> tabList) throws MetaException {
        if (this.needsAuthorization(this.getUserName())) {
            try {
                return HiveAuthzBindingHook.filterShowTables(this.getHiveAuthzBinding(), tabList, HiveOperation.SHOWTABLES, this.getUserName(), dbName);
            }
            catch (SemanticException e) {
                throw new MetaException("Error getting Table list " + e.getMessage());
            }
        }
        return tabList;
    }

    private HiveAuthzBinding getHiveAuthzBinding() throws MetaException {
        if (hiveAuthzBinding == null) {
            try {
                hiveAuthzBinding = new HiveAuthzBinding(HiveAuthzBinding.HiveHook.HiveMetaStore, this.getHiveConf(), this.getAuthzConf());
            }
            catch (Exception e) {
                throw new MetaException("Failed to load Hive binding " + e.getMessage());
            }
        }
        return hiveAuthzBinding;
    }

    private ImmutableSet<String> getServiceUsers() throws MetaException {
        if (serviceUsers == null) {
            serviceUsers = ImmutableSet.copyOf(AuthorizingObjectStore.toTrimed(Sets.newHashSet((Object[])this.getAuthzConf().getStrings(HiveAuthzConf.AuthzConfVars.AUTHZ_METASTORE_SERVICE_USERS.getVar(), new String[]{""}))));
        }
        return serviceUsers;
    }

    private HiveConf getHiveConf() {
        if (hiveConf == null) {
            hiveConf = new HiveConf(this.getConf(), ((Object)((Object)this)).getClass());
        }
        return hiveConf;
    }

    private HiveAuthzConf getAuthzConf() throws MetaException {
        if (authzConf == null) {
            String hiveAuthzConf = this.getConf().get("hive.sentry.conf.url");
            if (hiveAuthzConf == null || (hiveAuthzConf = hiveAuthzConf.trim()).isEmpty()) {
                throw new MetaException("Configuration key hive.sentry.conf.url value '" + hiveAuthzConf + "' is invalid.");
            }
            try {
                authzConf = new HiveAuthzConf(new URL(hiveAuthzConf));
            }
            catch (MalformedURLException e) {
                throw new MetaException("Configuration key hive.sentry.conf.url specifies a malformed URL '" + hiveAuthzConf + "' " + e.getMessage());
            }
        }
        return authzConf;
    }

    private String getUserName() throws MetaException {
        try {
            return Utils.getUGI().getShortUserName();
        }
        catch (LoginException e) {
            throw new MetaException("Failed to get username " + e.getMessage());
        }
        catch (IOException e) {
            throw new MetaException("Failed to get username " + e.getMessage());
        }
    }

    private boolean needsAuthorization(String userName) throws MetaException {
        return !this.getServiceUsers().contains((Object)userName.trim());
    }

    private static Set<String> toTrimed(Set<String> s) {
        HashSet result = Sets.newHashSet();
        for (String v : s) {
            result.add(v.trim());
        }
        return result;
    }

    private String getNoAccessMessageForTable(String dbName, String tableName) {
        return NO_ACCESS_MESSAGE_TABLE + "<" + dbName + ">.<" + tableName + ">";
    }

    private String getNoAccessMessageForDB(String dbName) {
        return NO_ACCESS_MESSAGE_DATABASE + "<" + dbName + ">";
    }

    static {
        NO_ACCESS_MESSAGE_TABLE = "Table does not exist or insufficient privileges to access: ";
        NO_ACCESS_MESSAGE_DATABASE = "Database does not exist or insufficient privileges to access: ";
    }
}

