/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive.conf;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAuthzConf
extends Configuration {
    public static final String HIVE_ACCESS_CONF_URL = "hive.access.conf.url";
    public static final String HIVE_SENTRY_CONF_URL = "hive.sentry.conf.url";
    public static final String HIVE_ACCESS_SUBJECT_NAME = "hive.access.subject.name";
    public static final String HIVE_SENTRY_SUBJECT_NAME = "hive.sentry.subject.name";
    public static final String HIVE_SENTRY_AUTH_ERRORS = "sentry.hive.authorization.errors";
    public static final String HIVE_SENTRY_MOCK_COMPILATION = "sentry.hive.mock.compilation";
    public static final String HIVE_SENTRY_MOCK_ERROR = "sentry.hive.mock.error";
    public static final String HIVE_SENTRY_PRIVILEGE_ERROR_MESSAGE = "No valid privileges";
    public static final String SENTRY_ACTIVE_ROLE_SET = "hive.sentry.active.role.set";
    public static final String HIVE_SENTRY_SECURITY_COMMAND_WHITELIST = "hive.sentry.security.command.whitelist";
    public static final String HIVE_SENTRY_SECURITY_COMMAND_WHITELIST_DEFAULT = "set,reset,reload";
    private static final String HIVE_UDF_WHITE_LIST = "date,decimal,timestamp,abs,acos,and,array,array_contains,ascii,asin,assert_true,atan,avg,between,bin,case,cast,ceil,ceiling,coalesce,collect_set,compute_stats,concat,concat_ws,UDFConv,UDFHex,UDFSign,UDFToBoolean,UDFToByte,UDFToDouble,UDFToFloat,UDFToInteger,UDFToLong,UDFToShort,UDFToString,context_ngrams,conv,corr,cos,count,covar_pop,covar_samp,create_union,date_add,date_sub,datediff,day,dayofmonth,degrees,div,e,elt,ewah_bitmap,ewah_bitmap_and,ewah_bitmap_empty,ewah_bitmap_or,exp,explode,field,find_in_set,floor,format_number,from_unixtime,from_utc_timestamp,get_json_object,hash,hex,histogram_numeric,hour,if,in,in_file,index,inline,instr,isnotnull,isnull,json_tuple,lcase,length,like,ln,locate,log,log10,log2,lower,lpad,ltrim,map,map_keys,map_values,max,min,minute,month,named_struct,negative,ngrams,not,or,parse_url,parse_url_tuple,percentile,percentile_approx,pi,pmod,posexplode,positive,pow,power,printf,radians,rand,regexp,regexp_extract,regexp_replace,repeat,reverse,rlike,round,rpad,rtrim,second,sentences,sign,sin,size,sort_array,space,split,sqrt,stack,std,stddev,stddev_pop,stddev_samp,str_to_map,struct,substr,substring,sum,tan,to_date,to_utc_timestamp,translate,trim,ucase,unhex,union_map,unix_timestamp,upper,var_pop,var_samp,variance,weekofyear,when,xpath,xpath_boolean,xpath_double,xpath_float,xpath_int,xpath_long,xpath_number,xpath_short,xpath_string,year,base64,cume_dist, decode, dense_rank, first_value,lag, last_value, lead, noop, noopwithmap, ntile, nvl, percent_rank, rank, to_unix_timestamp,current_database,char,varchar,matchpath,row_number,unbase64,windowingtablefunction";
    private static final Map<String, AuthzConfVars> currentToDeprecatedProps = new HashMap<String, AuthzConfVars>();
    private static final Logger LOG;
    public static final String AUTHZ_SITE_FILE = "sentry-site.xml";
    private final String hiveAuthzSiteFile;

    public HiveAuthzConf(URL hiveAuthzSiteURL) {
        LOG.info("DefaultFS: " + super.get("fs.defaultFS"));
        this.addResource(hiveAuthzSiteURL);
        this.applySystemProperties();
        LOG.info("DefaultFS: " + super.get("fs.defaultFS"));
        this.hiveAuthzSiteFile = hiveAuthzSiteURL.toString();
    }

    private void applySystemProperties() {
        Map<String, String> systemProperties = HiveAuthzConf.getConfSystemProperties();
        for (Map.Entry<String, String> systemProperty : systemProperties.entrySet()) {
            this.set(systemProperty.getKey(), systemProperty.getValue());
        }
    }

    public static Map<String, String> getConfSystemProperties() {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        for (AuthzConfVars oneVar : AuthzConfVars.values()) {
            String value = System.getProperty(oneVar.getVar());
            if (value == null || value.length() <= 0) continue;
            systemProperties.put(oneVar.getVar(), value);
        }
        return systemProperties;
    }

    public String get(String varName) {
        return this.get(varName, null);
    }

    public String get(String varName, String defaultVal) {
        String retVal = super.get(varName);
        if (retVal == null) {
            if (currentToDeprecatedProps.containsKey(varName)) {
                retVal = super.get(currentToDeprecatedProps.get(varName).getVar());
            }
            if (retVal == null) {
                retVal = AuthzConfVars.getDefault(varName);
            } else {
                LOG.warn("Using the deprecated config setting " + currentToDeprecatedProps.get(varName).getVar() + " instead of " + varName);
            }
        }
        if (retVal == null) {
            retVal = defaultVal;
        }
        return retVal;
    }

    public String getHiveAuthzSiteFile() {
        return this.hiveAuthzSiteFile;
    }

    public static HiveAuthzConf getAuthzConf(HiveConf hiveConf) throws IllegalArgumentException {
        boolean depreicatedConfigFile = false;
        String hiveAuthzConf = hiveConf.get(HIVE_SENTRY_CONF_URL);
        if (hiveAuthzConf == null || (hiveAuthzConf = hiveAuthzConf.trim()).isEmpty()) {
            hiveAuthzConf = hiveConf.get(HIVE_ACCESS_CONF_URL);
            depreicatedConfigFile = true;
        }
        if (hiveAuthzConf == null || (hiveAuthzConf = hiveAuthzConf.trim()).isEmpty()) {
            throw new IllegalArgumentException("Configuration key hive.sentry.conf.url value '" + hiveAuthzConf + "' is invalid.");
        }
        try {
            return new HiveAuthzConf(new URL(hiveAuthzConf));
        }
        catch (MalformedURLException e) {
            if (depreicatedConfigFile) {
                throw new IllegalArgumentException("Configuration key hive.access.conf.url specifies a malformed URL '" + hiveAuthzConf + "'", e);
            }
            throw new IllegalArgumentException("Configuration key hive.sentry.conf.url specifies a malformed URL '" + hiveAuthzConf + "'", e);
        }
    }

    static {
        currentToDeprecatedProps.put(AuthzConfVars.AUTHZ_PROVIDER.getVar(), AuthzConfVars.AUTHZ_PROVIDER_DEPRECATED);
        currentToDeprecatedProps.put(AuthzConfVars.AUTHZ_PROVIDER_RESOURCE.getVar(), AuthzConfVars.AUTHZ_PROVIDER_RESOURCE_DEPRECATED);
        currentToDeprecatedProps.put(AuthzConfVars.AUTHZ_SERVER_NAME.getVar(), AuthzConfVars.AUTHZ_SERVER_NAME_DEPRECATED);
        currentToDeprecatedProps.put(AuthzConfVars.AUTHZ_RESTRICT_DEFAULT_DB.getVar(), AuthzConfVars.AUTHZ_RESTRICT_DEFAULT_DB_DEPRECATED);
        currentToDeprecatedProps.put(AuthzConfVars.SENTRY_TESTING_MODE.getVar(), AuthzConfVars.SENTRY_TESTING_MODE_DEPRECATED);
        currentToDeprecatedProps.put(AuthzConfVars.AUTHZ_UDF_WHITELIST.getVar(), AuthzConfVars.AUTHZ_UDF_WHITELIST_DEPRECATED);
        currentToDeprecatedProps.put(AuthzConfVars.AUTHZ_ALLOW_HIVE_IMPERSONATION.getVar(), AuthzConfVars.AUTHZ_ALLOW_HIVE_IMPERSONATION_DEPRECATED);
        currentToDeprecatedProps.put(AuthzConfVars.AUTHZ_ONFAILURE_HOOKS.getVar(), AuthzConfVars.AUTHZ_ONFAILURE_HOOKS_DEPRECATED);
        LOG = LoggerFactory.getLogger(HiveAuthzConf.class);
    }

    public static enum AuthzConfVars {
        AUTHZ_PROVIDER("sentry.provider", "org.apache.sentry.provider.common.HadoopGroupResourceAuthorizationProvider"),
        AUTHZ_PROVIDER_RESOURCE("sentry.hive.provider.resource", ""),
        AUTHZ_PROVIDER_BACKEND("sentry.hive.provider.backend", "org.apache.sentry.provider.file.SimpleFileProviderBackend"),
        AUTHZ_POLICY_ENGINE("sentry.hive.policy.engine", "org.apache.sentry.policy.db.SimpleDBPolicyEngine"),
        AUTHZ_POLICY_FILE_FORMATTER("sentry.hive.policy.file.formatter", "org.apache.sentry.binding.hive.SentryIniPolicyFileFormatter"),
        AUTHZ_SERVER_NAME("sentry.hive.server", "HS2"),
        AUTHZ_RESTRICT_DEFAULT_DB("sentry.hive.restrict.defaultDB", "false"),
        SENTRY_TESTING_MODE("sentry.hive.testing.mode", "false"),
        AUTHZ_UDF_WHITELIST("sentry.hive.udf.whitelist", "date,decimal,timestamp,abs,acos,and,array,array_contains,ascii,asin,assert_true,atan,avg,between,bin,case,cast,ceil,ceiling,coalesce,collect_set,compute_stats,concat,concat_ws,UDFConv,UDFHex,UDFSign,UDFToBoolean,UDFToByte,UDFToDouble,UDFToFloat,UDFToInteger,UDFToLong,UDFToShort,UDFToString,context_ngrams,conv,corr,cos,count,covar_pop,covar_samp,create_union,date_add,date_sub,datediff,day,dayofmonth,degrees,div,e,elt,ewah_bitmap,ewah_bitmap_and,ewah_bitmap_empty,ewah_bitmap_or,exp,explode,field,find_in_set,floor,format_number,from_unixtime,from_utc_timestamp,get_json_object,hash,hex,histogram_numeric,hour,if,in,in_file,index,inline,instr,isnotnull,isnull,json_tuple,lcase,length,like,ln,locate,log,log10,log2,lower,lpad,ltrim,map,map_keys,map_values,max,min,minute,month,named_struct,negative,ngrams,not,or,parse_url,parse_url_tuple,percentile,percentile_approx,pi,pmod,posexplode,positive,pow,power,printf,radians,rand,regexp,regexp_extract,regexp_replace,repeat,reverse,rlike,round,rpad,rtrim,second,sentences,sign,sin,size,sort_array,space,split,sqrt,stack,std,stddev,stddev_pop,stddev_samp,str_to_map,struct,substr,substring,sum,tan,to_date,to_utc_timestamp,translate,trim,ucase,unhex,union_map,unix_timestamp,upper,var_pop,var_samp,variance,weekofyear,when,xpath,xpath_boolean,xpath_double,xpath_float,xpath_int,xpath_long,xpath_number,xpath_short,xpath_string,year,base64,cume_dist, decode, dense_rank, first_value,lag, last_value, lead, noop, noopwithmap, ntile, nvl, percent_rank, rank, to_unix_timestamp,current_database,char,varchar,matchpath,row_number,unbase64,windowingtablefunction"),
        AUTHZ_ALLOW_HIVE_IMPERSONATION("sentry.hive.allow.hive.impersonation", "false"),
        AUTHZ_ONFAILURE_HOOKS("sentry.hive.failure.hooks", ""),
        AUTHZ_METASTORE_SERVICE_USERS("sentry.metastore.service.users", null),
        AUTHZ_SYNC_ALTER_WITH_POLICY_STORE("sentry.hive.sync.alter", "true"),
        AUTHZ_SYNC_CREATE_WITH_POLICY_STORE("sentry.hive.sync.create", "false"),
        AUTHZ_SYNC_DROP_WITH_POLICY_STORE("sentry.hive.sync.drop", "true"),
        AUTHZ_PROVIDER_DEPRECATED("hive.sentry.provider", "org.apache.sentry.provider.file.ResourceAuthorizationProvider"),
        AUTHZ_PROVIDER_RESOURCE_DEPRECATED("hive.sentry.provider.resource", ""),
        AUTHZ_SERVER_NAME_DEPRECATED("hive.sentry.server", "HS2"),
        AUTHZ_RESTRICT_DEFAULT_DB_DEPRECATED("hive.sentry.restrict.defaultDB", "false"),
        SENTRY_TESTING_MODE_DEPRECATED("hive.sentry.testing.mode", "false"),
        AUTHZ_UDF_WHITELIST_DEPRECATED("hive.sentry.udf.whitelist", "date,decimal,timestamp,abs,acos,and,array,array_contains,ascii,asin,assert_true,atan,avg,between,bin,case,cast,ceil,ceiling,coalesce,collect_set,compute_stats,concat,concat_ws,UDFConv,UDFHex,UDFSign,UDFToBoolean,UDFToByte,UDFToDouble,UDFToFloat,UDFToInteger,UDFToLong,UDFToShort,UDFToString,context_ngrams,conv,corr,cos,count,covar_pop,covar_samp,create_union,date_add,date_sub,datediff,day,dayofmonth,degrees,div,e,elt,ewah_bitmap,ewah_bitmap_and,ewah_bitmap_empty,ewah_bitmap_or,exp,explode,field,find_in_set,floor,format_number,from_unixtime,from_utc_timestamp,get_json_object,hash,hex,histogram_numeric,hour,if,in,in_file,index,inline,instr,isnotnull,isnull,json_tuple,lcase,length,like,ln,locate,log,log10,log2,lower,lpad,ltrim,map,map_keys,map_values,max,min,minute,month,named_struct,negative,ngrams,not,or,parse_url,parse_url_tuple,percentile,percentile_approx,pi,pmod,posexplode,positive,pow,power,printf,radians,rand,regexp,regexp_extract,regexp_replace,repeat,reverse,rlike,round,rpad,rtrim,second,sentences,sign,sin,size,sort_array,space,split,sqrt,stack,std,stddev,stddev_pop,stddev_samp,str_to_map,struct,substr,substring,sum,tan,to_date,to_utc_timestamp,translate,trim,ucase,unhex,union_map,unix_timestamp,upper,var_pop,var_samp,variance,weekofyear,when,xpath,xpath_boolean,xpath_double,xpath_float,xpath_int,xpath_long,xpath_number,xpath_short,xpath_string,year,base64,cume_dist, decode, dense_rank, first_value,lag, last_value, lead, noop, noopwithmap, ntile, nvl, percent_rank, rank, to_unix_timestamp,current_database,char,varchar,matchpath,row_number,unbase64,windowingtablefunction"),
        AUTHZ_ALLOW_HIVE_IMPERSONATION_DEPRECATED("hive.sentry.allow.hive.impersonation", "false"),
        AUTHZ_ONFAILURE_HOOKS_DEPRECATED("hive.sentry.failure.hooks", "");

        private final String varName;
        private final String defaultVal;

        private AuthzConfVars(String varName, String defaultVal) {
            this.varName = varName;
            this.defaultVal = defaultVal;
        }

        public String getVar() {
            return this.varName;
        }

        public String getDefault() {
            return this.defaultVal;
        }

        public static String getDefault(String varName) {
            for (AuthzConfVars oneVar : AuthzConfVars.values()) {
                if (!oneVar.getVar().equalsIgnoreCase(varName)) continue;
                return oneVar.getDefault();
            }
            return null;
        }
    }
}

