/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.DDLTask;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.ShowColumnsDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.sentry.binding.hive.HiveAuthzBindingHook;
import org.apache.sentry.binding.hive.authz.HiveAuthzBinding;
import org.apache.sentry.core.common.Subject;

public class SentryFilterDDLTask
extends DDLTask {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(SentryFilterDDLTask.class);
    private HiveAuthzBinding hiveAuthzBinding;
    private Subject subject;
    private HiveOperation stmtOperation;

    public SentryFilterDDLTask(HiveAuthzBinding hiveAuthzBinding, Subject subject, HiveOperation stmtOperation) {
        Preconditions.checkNotNull((Object)hiveAuthzBinding);
        Preconditions.checkNotNull((Object)subject);
        Preconditions.checkNotNull((Object)stmtOperation);
        this.hiveAuthzBinding = hiveAuthzBinding;
        this.subject = subject;
        this.stmtOperation = stmtOperation;
    }

    public HiveAuthzBinding getHiveAuthzBinding() {
        return this.hiveAuthzBinding;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public HiveOperation getStmtOperation() {
        return this.stmtOperation;
    }

    public int execute(DriverContext driverContext) {
        ShowColumnsDesc showCols = ((DDLWork)this.work).getShowColumnsDesc();
        try {
            if (showCols != null) {
                return this.showFilterColumns(showCols);
            }
        }
        catch (Throwable e) {
            this.failed(e);
            return 1;
        }
        return super.execute(driverContext);
    }

    private void failed(Throwable e) {
        while (e.getCause() != null && e.getClass() == RuntimeException.class) {
            e = e.getCause();
        }
        this.setException(e);
        LOG.error((Object)StringUtils.stringifyException((Throwable)e));
    }

    private int showFilterColumns(ShowColumnsDesc showCols) throws HiveException {
        Table table = Hive.get((HiveConf)this.conf).getTable(showCols.getTableName());
        FSDataOutputStream outStream = null;
        try {
            Path resFile = new Path(showCols.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            outStream = fs.create(resFile);
            List cols = table.getCols();
            cols.addAll(table.getPartCols());
            boolean isOutputPadded = !SessionState.get().isHiveServerQuery();
            outStream.writeBytes(MetaDataFormatUtils.getAllColumnsInformation(this.fiterColumns(cols, table), (boolean)false, (boolean)isOutputPadded, null));
            outStream.close();
            outStream = null;
        }
        catch (IOException e) {
            try {
                throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, new String[0]);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(outStream);
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)outStream);
        return 0;
    }

    private List<FieldSchema> fiterColumns(List<FieldSchema> cols, Table table) throws HiveException {
        return HiveAuthzBindingHook.filterShowColumns(this.getHiveAuthzBinding(), cols, this.getStmtOperation(), this.getSubject().getName(), table.getTableName(), table.getDbName());
    }
}

