/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.policy.db;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.SentryConfigurationException;
import org.apache.sentry.policy.common.PolicyEngine;
import org.apache.sentry.policy.common.PrivilegeFactory;
import org.apache.sentry.policy.common.PrivilegeValidator;
import org.apache.sentry.policy.db.DBWildcardPrivilege;
import org.apache.sentry.policy.db.DatabaseMustMatch;
import org.apache.sentry.policy.db.DatabaseRequiredInPrivilege;
import org.apache.sentry.policy.db.ServerNameMustMatch;
import org.apache.sentry.policy.db.ServersAllIsInvalid;
import org.apache.sentry.provider.common.ProviderBackend;
import org.apache.sentry.provider.common.ProviderBackendContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDBPolicyEngine
implements PolicyEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleDBPolicyEngine.class);
    public static final String ACCESS_ALLOW_URI_PER_DB_POLICYFILE = "sentry.allow.uri.db.policyfile";
    private final ProviderBackend providerBackend;

    public SimpleDBPolicyEngine(String serverName, ProviderBackend providerBackend) {
        this.providerBackend = providerBackend;
        ProviderBackendContext context = new ProviderBackendContext();
        context.setAllowPerDatabase(true);
        context.setValidators(SimpleDBPolicyEngine.createPrivilegeValidators(serverName));
        this.providerBackend.initialize(context);
    }

    public PrivilegeFactory getPrivilegeFactory() {
        return new DBWildcardPrivilege.DBWildcardPrivilegeFactory();
    }

    public ImmutableSet<String> getAllPrivileges(Set<String> groups, ActiveRoleSet roleSet) throws SentryConfigurationException {
        return this.getPrivileges(groups, roleSet, null);
    }

    public ImmutableSet<String> getPrivileges(Set<String> groups, ActiveRoleSet roleSet, Authorizable ... authorizableHierarchy) throws SentryConfigurationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Getting permissions for {}", groups);
        }
        ImmutableSet result = this.providerBackend.getPrivileges(groups, roleSet, authorizableHierarchy);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("result = " + result);
        }
        return result;
    }

    public void validatePolicy(boolean strictValidation) throws SentryConfigurationException {
        this.providerBackend.validatePolicy(strictValidation);
    }

    public void close() {
        if (this.providerBackend != null) {
            this.providerBackend.close();
        }
    }

    public static ImmutableList<PrivilegeValidator> createPrivilegeValidators(String serverName) {
        return ImmutableList.of((Object)new ServersAllIsInvalid(), (Object)new DatabaseMustMatch(), (Object)new DatabaseRequiredInPrivilege(), (Object)new ServerNameMustMatch(serverName));
    }
}

