/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.policy.db;

import org.apache.sentry.core.model.db.AccessURI;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.core.model.db.Database;
import org.apache.sentry.policy.common.PrivilegeValidatorContext;
import org.apache.sentry.policy.db.AbstractDBPrivilegeValidator;
import org.apache.shiro.config.ConfigurationException;

public class DatabaseRequiredInPrivilege
extends AbstractDBPrivilegeValidator {
    public void validate(PrivilegeValidatorContext context) throws ConfigurationException {
        String database = context.getDatabase();
        String privilege = context.getPrivilege();
        if (database != null) {
            Iterable<DBModelAuthorizable> authorizables = DatabaseRequiredInPrivilege.parsePrivilege(privilege);
            boolean foundDatabaseInAuthorizables = false;
            boolean foundURIInAuthorizables = false;
            boolean allowURIInAuthorizables = false;
            if ("true".equalsIgnoreCase(System.getProperty("sentry.allow.uri.db.policyfile"))) {
                allowURIInAuthorizables = true;
            }
            for (DBModelAuthorizable authorizable : authorizables) {
                if (authorizable instanceof Database) {
                    foundDatabaseInAuthorizables = true;
                }
                if (!(authorizable instanceof AccessURI)) continue;
                if (foundDatabaseInAuthorizables) {
                    String msg = "URI object is specified at DB scope in " + privilege;
                    throw new ConfigurationException(msg);
                }
                foundURIInAuthorizables = true;
            }
            if (!(foundDatabaseInAuthorizables || foundURIInAuthorizables && allowURIInAuthorizables)) {
                String msg = "Missing database object in " + privilege;
                throw new ConfigurationException(msg);
            }
        }
    }
}

