/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.connector.matcher;

import org.apache.log4j.Logger;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.schema.ByteArraySchema;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.schema.SchemaError;
import org.apache.sqoop.schema.type.Column;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class Matcher {
    private static final Logger LOG = Logger.getLogger(Matcher.class);
    private final Schema fromSchema;
    private final Schema toSchema;

    public Matcher(Schema fromSchema, Schema toSchema) {
        if (fromSchema.isEmpty() && toSchema.isEmpty()) {
            this.fromSchema = ByteArraySchema.getInstance();
            this.toSchema = ByteArraySchema.getInstance();
        } else if (toSchema.isEmpty()) {
            this.fromSchema = fromSchema;
            this.toSchema = fromSchema;
        } else if (fromSchema.isEmpty()) {
            this.fromSchema = toSchema;
            this.toSchema = toSchema;
        } else {
            this.fromSchema = fromSchema;
            this.toSchema = toSchema;
        }
    }

    public abstract Object[] getMatchingData(Object[] var1);

    public Schema getFromSchema() {
        return this.fromSchema;
    }

    public Schema getToSchema() {
        return this.toSchema;
    }

    protected void tryFillNullInArrayForUnexpectedColumn(Column column, Object[] array, int index) throws SqoopException {
        if (!column.isNullable().booleanValue()) {
            throw new SqoopException((ErrorCode)SchemaError.SCHEMA_0004, "Target column " + column + " didn't match with any source column and cannot be null.");
        }
        LOG.warn((Object)("Column " + column + " has no matching source column. Will be ignored."));
        array[index] = null;
    }
}

