/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.connector.idf;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.util.Utf8;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.connector.common.SqoopAvroUtils;
import org.apache.sqoop.connector.common.SqoopIDFUtils;
import org.apache.sqoop.connector.idf.IntermediateDataFormat;
import org.apache.sqoop.error.code.IntermediateDataFormatError;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.schema.type.Column;
import org.apache.sqoop.schema.type.DateTime;
import org.apache.sqoop.utils.ClassUtils;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class AVROIntermediateDataFormat
extends IntermediateDataFormat<GenericRecord> {
    private org.apache.avro.Schema avroSchema;

    public AVROIntermediateDataFormat() {
    }

    public AVROIntermediateDataFormat(Schema schema) {
        this.setSchema(schema);
        this.avroSchema = SqoopAvroUtils.createAvroSchema(schema);
    }

    @Override
    public void setCSVTextData(String text) {
        super.validateSchema(this.schema);
        this.data = this.toAVRO(text);
    }

    @Override
    public String getCSVTextData() {
        super.validateSchema(this.schema);
        return this.toCSV((GenericRecord)this.data);
    }

    @Override
    public void setObjectData(Object[] data) {
        super.validateSchema(this.schema);
        this.data = this.toAVRO(data);
    }

    @Override
    public Object[] getObjectData() {
        super.validateSchema(this.schema);
        return this.toObject((GenericRecord)this.data);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        GenericDatumWriter writer = new GenericDatumWriter(this.avroSchema);
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)((DataOutputStream)out), null);
        writer.write(this.data, (Encoder)encoder);
    }

    @Override
    public void read(DataInput in) throws IOException {
        GenericDatumReader reader = new GenericDatumReader(this.avroSchema);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)((Object)in), null);
        this.data = reader.read(null, (Decoder)decoder);
    }

    @Override
    public Set<String> getJars() {
        Set<String> jars = super.getJars();
        jars.add(ClassUtils.jarForClass(GenericRecord.class));
        return jars;
    }

    private GenericRecord toAVRO(String csv) {
        String[] csvStringArray = SqoopIDFUtils.parseCSVString(csv);
        if (csvStringArray == null) {
            return null;
        }
        Column[] columns = this.schema.getColumnsArray();
        if (csvStringArray.length != columns.length) {
            throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0001, "The data " + csv + " has the wrong number of fields.");
        }
        GenericData.Record avroObject = new GenericData.Record(this.avroSchema);
        for (int i = 0; i < csvStringArray.length; ++i) {
            if (csvStringArray[i].equals("NULL") && !columns[i].isNullable().booleanValue()) {
                throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0005, columns[i].getName() + " does not support null values");
            }
            if (csvStringArray[i].equals("NULL")) {
                avroObject.put(columns[i].getName(), null);
                continue;
            }
            avroObject.put(columns[i].getName(), this.toAVRO(csvStringArray[i], columns[i]));
        }
        return avroObject;
    }

    private Object toAVRO(String csvString, Column column) {
        Object returnValue = null;
        switch (column.getType()) {
            case ARRAY: 
            case SET: {
                Object[] list = SqoopIDFUtils.toList(csvString);
                returnValue = Arrays.asList(list);
                break;
            }
            case MAP: {
                returnValue = SqoopIDFUtils.toMap(csvString);
                break;
            }
            case ENUM: {
                returnValue = new GenericData.EnumSymbol(SqoopAvroUtils.createEnumSchema(column), SqoopIDFUtils.removeQuotes(csvString));
                break;
            }
            case TEXT: {
                returnValue = new Utf8(SqoopIDFUtils.removeQuotes(csvString));
                break;
            }
            case BINARY: 
            case UNKNOWN: {
                returnValue = ByteBuffer.wrap(SqoopIDFUtils.toByteArray(csvString));
                break;
            }
            case FIXED_POINT: {
                returnValue = SqoopIDFUtils.toFixedPoint(csvString, column);
                break;
            }
            case FLOATING_POINT: {
                returnValue = SqoopIDFUtils.toFloatingPoint(csvString, column);
                break;
            }
            case DECIMAL: {
                returnValue = SqoopIDFUtils.removeQuotes(csvString);
                break;
            }
            case DATE: {
                returnValue = ((LocalDate)SqoopIDFUtils.toDate(csvString, column)).toDate().getTime();
                break;
            }
            case TIME: {
                returnValue = ((LocalTime)SqoopIDFUtils.toTime(csvString, column)).toDateTimeToday().getMillis();
                break;
            }
            case DATE_TIME: {
                returnValue = SqoopIDFUtils.toDateTimeInMillis(csvString, column);
                break;
            }
            case BIT: {
                returnValue = Boolean.valueOf(SqoopIDFUtils.removeQuotes(csvString));
                break;
            }
            default: {
                throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0004, "Column type from schema was not recognized for " + column.getType());
            }
        }
        return returnValue;
    }

    private GenericRecord toAVRO(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Column[] columns = this.schema.getColumnsArray();
        if (objectArray.length != columns.length) {
            throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0001, "The data " + objectArray.toString() + " has the wrong number of fields.");
        }
        GenericData.Record avroObject = new GenericData.Record(this.avroSchema);
        block13: for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null && !columns[i].isNullable().booleanValue()) {
                throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0005, columns[i].getName() + " does not support null values");
            }
            if (objectArray[i] == null) {
                avroObject.put(columns[i].getName(), null);
                continue;
            }
            switch (columns[i].getType()) {
                case ARRAY: 
                case SET: {
                    avroObject.put(columns[i].getName(), SqoopIDFUtils.toList((Object[])objectArray[i]));
                    continue block13;
                }
                case MAP: {
                    avroObject.put(columns[i].getName(), objectArray[i]);
                    continue block13;
                }
                case ENUM: {
                    GenericData.EnumSymbol enumValue = new GenericData.EnumSymbol(SqoopAvroUtils.createEnumSchema(columns[i]), (String)objectArray[i]);
                    avroObject.put(columns[i].getName(), (Object)enumValue);
                    continue block13;
                }
                case TEXT: {
                    avroObject.put(columns[i].getName(), (Object)new Utf8((String)objectArray[i]));
                    continue block13;
                }
                case BINARY: 
                case UNKNOWN: {
                    avroObject.put(columns[i].getName(), (Object)ByteBuffer.wrap((byte[])objectArray[i]));
                    continue block13;
                }
                case FIXED_POINT: 
                case FLOATING_POINT: {
                    avroObject.put(columns[i].getName(), objectArray[i]);
                    continue block13;
                }
                case DECIMAL: {
                    avroObject.put(columns[i].getName(), (Object)((BigDecimal)objectArray[i]).toPlainString());
                    continue block13;
                }
                case DATE_TIME: {
                    if (objectArray[i] instanceof org.joda.time.DateTime) {
                        avroObject.put(columns[i].getName(), (Object)((org.joda.time.DateTime)objectArray[i]).toDate().getTime());
                        continue block13;
                    }
                    if (!(objectArray[i] instanceof LocalDateTime)) continue block13;
                    avroObject.put(columns[i].getName(), (Object)((LocalDateTime)objectArray[i]).toDate().getTime());
                    continue block13;
                }
                case TIME: {
                    avroObject.put(columns[i].getName(), (Object)((LocalTime)objectArray[i]).toDateTimeToday().getMillis());
                    continue block13;
                }
                case DATE: {
                    avroObject.put(columns[i].getName(), (Object)((LocalDate)objectArray[i]).toDate().getTime());
                    continue block13;
                }
                case BIT: {
                    avroObject.put(columns[i].getName(), (Object)((Boolean)objectArray[i]));
                    continue block13;
                }
                default: {
                    throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0001, "Column type from schema was not recognized for " + columns[i].getType());
                }
            }
        }
        return avroObject;
    }

    private String toCSV(GenericRecord record) {
        Column[] columns = this.schema.getColumnsArray();
        StringBuilder csvString = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            Object obj = record.get(columns[i].getName());
            if (obj == null && !columns[i].isNullable().booleanValue()) {
                throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0005, columns[i].getName() + " does not support null values");
            }
            if (obj == null) {
                csvString.append("NULL");
            } else {
                switch (columns[i].getType()) {
                    case ARRAY: 
                    case SET: {
                        List objList = (List)obj;
                        csvString.append(SqoopIDFUtils.toCSVList(SqoopIDFUtils.toObjectArray(objList), columns[i]));
                        break;
                    }
                    case MAP: {
                        Map objMap = (Map)obj;
                        csvString.append(SqoopIDFUtils.toCSVMap(objMap, columns[i]));
                        break;
                    }
                    case ENUM: 
                    case TEXT: {
                        csvString.append(SqoopIDFUtils.toCSVString(obj.toString()));
                        break;
                    }
                    case BINARY: 
                    case UNKNOWN: {
                        csvString.append(SqoopIDFUtils.toCSVByteArray(SqoopAvroUtils.getBytesFromByteBuffer(obj)));
                        break;
                    }
                    case FIXED_POINT: {
                        csvString.append(SqoopIDFUtils.toCSVFixedPoint(obj, columns[i]));
                        break;
                    }
                    case FLOATING_POINT: {
                        csvString.append(SqoopIDFUtils.toCSVFloatingPoint(obj, columns[i]));
                        break;
                    }
                    case DECIMAL: {
                        csvString.append(SqoopIDFUtils.toCSVDecimal(obj));
                        break;
                    }
                    case DATE: {
                        Long dateInMillis = (Long)obj;
                        csvString.append(SqoopIDFUtils.toCSVDate(new LocalDate((Object)dateInMillis)));
                        break;
                    }
                    case TIME: {
                        Long timeInMillis = (Long)obj;
                        csvString.append(SqoopIDFUtils.toCSVTime(new LocalTime((Object)timeInMillis), columns[i]));
                        break;
                    }
                    case DATE_TIME: {
                        Long dateTimeInMillis = (Long)obj;
                        csvString.append(SqoopIDFUtils.toCSVDateTime(new org.joda.time.DateTime((Object)dateTimeInMillis), columns[i]));
                        break;
                    }
                    case BIT: {
                        csvString.append(SqoopIDFUtils.toCSVBit(obj));
                        break;
                    }
                    default: {
                        throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0001, "Column type from schema was not recognized for " + columns[i].getType());
                    }
                }
            }
            if (i >= columns.length - 1) continue;
            csvString.append(',');
        }
        return csvString.toString();
    }

    private Object[] toObject(GenericRecord record) {
        if (record == null) {
            return null;
        }
        Column[] columns = this.schema.getColumnsArray();
        Object[] object = new Object[columns.length];
        block12: for (int i = 0; i < columns.length; ++i) {
            Object obj = record.get(columns[i].getName());
            Integer nameIndex = this.schema.getColumnNameIndex(columns[i].getName());
            Column column = columns[nameIndex];
            if (obj == null && !column.isNullable().booleanValue()) {
                throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0005, column.getName() + " does not support null values");
            }
            if (obj == null) {
                object[nameIndex.intValue()] = null;
                continue;
            }
            switch (column.getType()) {
                case ARRAY: 
                case SET: {
                    object[nameIndex.intValue()] = SqoopIDFUtils.toObjectArray((List)obj);
                    continue block12;
                }
                case MAP: {
                    object[nameIndex.intValue()] = obj;
                    continue block12;
                }
                case ENUM: 
                case TEXT: {
                    object[nameIndex.intValue()] = obj.toString();
                    continue block12;
                }
                case BINARY: 
                case UNKNOWN: {
                    object[nameIndex.intValue()] = SqoopAvroUtils.getBytesFromByteBuffer(obj);
                    continue block12;
                }
                case FIXED_POINT: 
                case FLOATING_POINT: {
                    object[nameIndex.intValue()] = obj;
                    continue block12;
                }
                case DECIMAL: {
                    object[nameIndex.intValue()] = obj.toString();
                    continue block12;
                }
                case DATE: {
                    Long dateInMillis = (Long)obj;
                    object[nameIndex.intValue()] = new LocalDate((Object)dateInMillis);
                    continue block12;
                }
                case TIME: {
                    Long timeInMillis = (Long)obj;
                    object[nameIndex.intValue()] = new LocalTime((Object)timeInMillis);
                    continue block12;
                }
                case DATE_TIME: {
                    Long dateTimeInMillis = (Long)obj;
                    if (((DateTime)column).hasTimezone().booleanValue()) {
                        object[nameIndex.intValue()] = new org.joda.time.DateTime((Object)dateTimeInMillis);
                        continue block12;
                    }
                    object[nameIndex.intValue()] = new LocalDateTime((Object)dateTimeInMillis);
                    continue block12;
                }
                case BIT: {
                    object[nameIndex.intValue()] = SqoopIDFUtils.toBit(obj.toString());
                    continue block12;
                }
                default: {
                    throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0001, "Column type from schema was not recognized for " + column.getType());
                }
            }
        }
        return object;
    }
}

