/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.connector.common;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.error.code.CSVIntermediateDataFormatError;
import org.apache.sqoop.error.code.IntermediateDataFormatError;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.schema.type.AbstractComplexListType;
import org.apache.sqoop.schema.type.Column;
import org.apache.sqoop.schema.type.ColumnType;
import org.apache.sqoop.schema.type.DateTime;
import org.apache.sqoop.schema.type.Decimal;
import org.apache.sqoop.schema.type.FixedPoint;
import org.apache.sqoop.schema.type.FloatingPoint;
import org.apache.sqoop.schema.type.Time;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class SqoopIDFUtils {
    public static final String NULL_VALUE = "NULL";
    public static final String BYTE_FIELD_CHARSET = "ISO-8859-1";
    public static final Map<Character, String> ORIGINALS = new TreeMap<Character, String>();
    public static final char CSV_SEPARATOR_CHARACTER = ',';
    public static final char ESCAPE_CHARACTER = '\\';
    public static final char QUOTE_CHARACTER = '\'';
    private static final Map<Character, Character> REPLACEMENTS = new TreeMap<Character, Character>();
    public static final DateTimeFormatter dtfWithFractionAndTimeZone;
    public static final DateTimeFormatter dtfWithNoFractionAndTimeZone;
    public static final DateTimeFormatter dtfWithFractionNoTimeZone;
    public static final DateTimeFormatter dtfWithNoFractionWithTimeZone;
    public static final DateTimeFormatter df;
    public static final DateTimeFormatter tfWithFraction;
    public static final DateTimeFormatter tfWithNoFraction;
    public static final String[] TRUE_BIT_VALUES;
    public static final Set<String> TRUE_BIT_SET;
    public static final String[] FALSE_BIT_VALUES;
    public static final Set<String> FALSE_BIT_SET;

    public static boolean isInteger(Column column) {
        Long byteSize = ((FixedPoint)column).getByteSize();
        Boolean signed = ((FixedPoint)column).isSigned();
        if (byteSize == null) {
            return false;
        }
        if (signed != null && !signed.booleanValue()) {
            byteSize = byteSize * 2L;
        }
        return byteSize <= 4L;
    }

    public static String toCSVFixedPoint(Object obj, Column column) {
        if (SqoopIDFUtils.isInteger(column)) {
            if (obj instanceof Number) {
                return new Integer(((Number)obj).intValue()).toString();
            }
            return new Integer(obj.toString()).toString();
        }
        if (obj instanceof Number) {
            return new Long(((Number)obj).longValue()).toString();
        }
        return new Long(obj.toString()).toString();
    }

    public static Object toFixedPoint(String csvString, Column column) {
        Number returnValue = SqoopIDFUtils.isInteger(column) ? (Number)Integer.valueOf(csvString) : (Number)Long.valueOf(csvString);
        return returnValue;
    }

    public static String toCSVFloatingPoint(Object obj, Column column) {
        Long byteSize = ((FloatingPoint)column).getByteSize();
        if (byteSize != null && byteSize <= 4L) {
            return ((Float)obj).toString();
        }
        return ((Double)obj).toString();
    }

    public static Object toFloatingPoint(String csvString, Column column) {
        Long byteSize = ((FloatingPoint)column).getByteSize();
        Number returnValue = byteSize != null && byteSize <= 4L ? (Number)Float.valueOf(csvString) : (Number)Double.valueOf(csvString);
        return returnValue;
    }

    public static String toCSVDecimal(Object obj) {
        return ((BigDecimal)obj).toString();
    }

    public static Object toDecimal(String csvString, Column column) {
        Integer precision = ((Decimal)column).getPrecision();
        Integer scale = ((Decimal)column).getScale();
        BigDecimal bd = null;
        if (precision != null) {
            MathContext mc = new MathContext(precision);
            bd = new BigDecimal(csvString, mc);
        } else {
            bd = new BigDecimal(csvString);
        }
        if (scale != null) {
            bd.setScale((int)scale, RoundingMode.HALF_UP);
        }
        return bd;
    }

    public static String toCSVBit(Object obj) {
        String bitStringValue = obj.toString();
        if (TRUE_BIT_SET.contains(bitStringValue) || FALSE_BIT_SET.contains(bitStringValue)) {
            return bitStringValue;
        }
        throw new SqoopException((ErrorCode)CSVIntermediateDataFormatError.CSV_INTERMEDIATE_DATA_FORMAT_0005, " given bit value: " + bitStringValue);
    }

    public static Object toBit(String csvString) {
        if (TRUE_BIT_SET.contains(csvString) || FALSE_BIT_SET.contains(csvString)) {
            return TRUE_BIT_SET.contains(csvString);
        }
        throw new SqoopException((ErrorCode)CSVIntermediateDataFormatError.CSV_INTERMEDIATE_DATA_FORMAT_0005, " given bit value: " + csvString);
    }

    public static String toCSVDate(Object obj) {
        LocalDate date = (LocalDate)obj;
        return SqoopIDFUtils.encloseWithQuotes(df.print((ReadablePartial)date));
    }

    public static String toCSVTime(Object obj, Column col) {
        if (((Time)col).hasFraction().booleanValue()) {
            return SqoopIDFUtils.encloseWithQuotes(tfWithFraction.print((ReadablePartial)((LocalTime)obj)));
        }
        return SqoopIDFUtils.encloseWithQuotes(tfWithNoFraction.print((ReadablePartial)((LocalTime)obj)));
    }

    public static Object toDate(String csvString, Column column) {
        return LocalDate.parse((String)SqoopIDFUtils.removeQuotes(csvString));
    }

    public static Object toTime(String csvString, Column column) {
        return LocalTime.parse((String)SqoopIDFUtils.removeQuotes(csvString));
    }

    public static String toCSVLocalDateTime(Object obj, Column col) {
        LocalDateTime localDateTime = (LocalDateTime)obj;
        DateTime column = (DateTime)col;
        if (column.hasFraction().booleanValue()) {
            return SqoopIDFUtils.encloseWithQuotes(dtfWithFractionNoTimeZone.print((ReadablePartial)localDateTime));
        }
        return SqoopIDFUtils.encloseWithQuotes(dtfWithNoFractionAndTimeZone.print((ReadablePartial)localDateTime));
    }

    public static String toCSVDateTime(Object obj, Column col) {
        org.joda.time.DateTime dateTime = (org.joda.time.DateTime)obj;
        DateTime column = (DateTime)col;
        if (column.hasFraction().booleanValue() && column.hasTimezone().booleanValue()) {
            return SqoopIDFUtils.encloseWithQuotes(dtfWithFractionAndTimeZone.print((ReadableInstant)dateTime));
        }
        if (column.hasFraction().booleanValue() && !column.hasTimezone().booleanValue()) {
            return SqoopIDFUtils.encloseWithQuotes(dtfWithFractionNoTimeZone.print((ReadableInstant)dateTime));
        }
        if (column.hasTimezone().booleanValue()) {
            return SqoopIDFUtils.encloseWithQuotes(dtfWithNoFractionWithTimeZone.print((ReadableInstant)dateTime));
        }
        return SqoopIDFUtils.encloseWithQuotes(dtfWithNoFractionAndTimeZone.print((ReadableInstant)dateTime));
    }

    public static Object toDateTime(String csvString, Column column) {
        String dateTime = SqoopIDFUtils.removeQuotes(csvString);
        DateTime col = (DateTime)column;
        Object returnValue = col.hasFraction() != false && col.hasTimezone() != false ? dtfWithFractionAndTimeZone.withOffsetParsed().parseDateTime(dateTime) : (col.hasFraction() != false && col.hasTimezone() == false ? dtfWithFractionNoTimeZone.parseLocalDateTime(dateTime) : (col.hasTimezone() != false ? dtfWithNoFractionWithTimeZone.withOffsetParsed().parseDateTime(dateTime) : dtfWithNoFractionAndTimeZone.parseLocalDateTime(dateTime)));
        return returnValue;
    }

    public static Long toDateTimeInMillis(String csvString, Column column) {
        String dateTime = SqoopIDFUtils.removeQuotes(csvString);
        DateTime col = (DateTime)column;
        long returnValue = col.hasFraction() != false && col.hasTimezone() != false ? dtfWithFractionAndTimeZone.withOffsetParsed().parseDateTime(dateTime).toDate().getTime() : (col.hasFraction() != false && col.hasTimezone() == false ? dtfWithFractionNoTimeZone.parseLocalDateTime(dateTime).toDate().getTime() : (col.hasTimezone() != false ? dtfWithNoFractionWithTimeZone.withOffsetParsed().parseDateTime(dateTime).toDate().getTime() : dtfWithNoFractionAndTimeZone.parseLocalDateTime(dateTime).toDate().getTime()));
        return returnValue;
    }

    public static String toCSVMap(Map<Object, Object> map, Column column) {
        JSONObject object = new JSONObject();
        object.putAll(map);
        return SqoopIDFUtils.encloseWithQuotes(object.toJSONString());
    }

    public static Map<Object, Object> toMap(String csvString) {
        JSONObject object = null;
        try {
            object = (JSONObject)new JSONParser().parse(SqoopIDFUtils.removeQuotes(csvString));
        }
        catch (ParseException e) {
            throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0003, (Throwable)e);
        }
        if (object != null) {
            return SqoopIDFUtils.toMap(object);
        }
        return null;
    }

    public static List<Object> toList(JSONArray array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.size(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = SqoopIDFUtils.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = SqoopIDFUtils.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    public static Map<Object, Object> toMap(JSONObject object) {
        HashMap<Object, Object> elementMap = new HashMap<Object, Object>();
        Set entries = object.entrySet();
        for (Map.Entry entry : entries) {
            Object value = entry.getValue();
            if (value instanceof JSONArray) {
                value = SqoopIDFUtils.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = SqoopIDFUtils.toMap((JSONObject)value);
            }
            elementMap.put(entry.getKey(), value);
        }
        return elementMap;
    }

    public static String toCSVList(Object[] list, Column column) {
        ArrayList<Object> elementList = new ArrayList<Object>();
        for (int n = 0; n < list.length; ++n) {
            Column listType = ((AbstractComplexListType)column).getListType();
            if (SqoopIDFUtils.isColumnListType(listType)) {
                Object[] listElements = (Object[])list[n];
                JSONArray subArray = new JSONArray();
                for (int i = 0; i < listElements.length; ++i) {
                    subArray.add(listElements[i]);
                }
                elementList.add(subArray);
                continue;
            }
            elementList.add(list[n]);
        }
        JSONArray array = new JSONArray();
        array.addAll(elementList);
        return SqoopIDFUtils.encloseWithQuotes(array.toJSONString());
    }

    public static Object[] toList(String csvString) {
        JSONArray array = null;
        try {
            array = (JSONArray)new JSONParser().parse(SqoopIDFUtils.removeQuotes(csvString));
        }
        catch (ParseException e) {
            throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0003, (Throwable)e);
        }
        if (array != null) {
            return array.toArray();
        }
        return null;
    }

    public static JSONArray toJSONArray(Object[] objectArray) {
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Object value = objectArray[i];
            if (value instanceof Object[]) {
                value = SqoopIDFUtils.toJSONArray((Object[])value);
            }
            jsonArray.add(value);
        }
        return jsonArray;
    }

    public static List<Object> toList(Object[] objectArray) {
        ArrayList<Object> objList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            List<Object> value = objectArray[i];
            if (value instanceof Object[]) {
                value = SqoopIDFUtils.toList((Object[])value);
            }
            objList.add(value);
        }
        return objList;
    }

    public static Object[] toObjectArray(List<Object> list) {
        Object[] array = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Object[] value = list.get(i);
            if (value instanceof List) {
                value = SqoopIDFUtils.toObjectArray((List)value);
            }
            array[i] = value;
        }
        return array;
    }

    public static String toCSVString(String string) {
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                sb1.append('\\');
            }
            sb1.append(c);
        }
        for (char c : sb1.toString().toCharArray()) {
            if (ORIGINALS.containsKey(Character.valueOf(c))) {
                sb2.append(ORIGINALS.get(Character.valueOf(c)));
                continue;
            }
            sb2.append(c);
        }
        return SqoopIDFUtils.encloseWithQuotes(sb2.toString());
    }

    public static String toText(String string) {
        boolean escaped = false;
        StringBuilder sb = new StringBuilder();
        string = SqoopIDFUtils.removeQuotes(string);
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (escaped) {
                escaped = false;
                if (REPLACEMENTS.containsKey(Character.valueOf(c))) {
                    c = REPLACEMENTS.get(Character.valueOf(c)).charValue();
                }
                sb.append(c);
                continue;
            }
            switch (c) {
                case '\\': {
                    escaped = true;
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String toCSVByteArray(Object obj) {
        byte[] bytes = (byte[])obj;
        try {
            return SqoopIDFUtils.toCSVString(new String(bytes, BYTE_FIELD_CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            throw new SqoopException((ErrorCode)CSVIntermediateDataFormatError.CSV_INTERMEDIATE_DATA_FORMAT_0001, "The character set ISO-8859-1 is not available.");
        }
    }

    public static byte[] toByteArray(String csvString) {
        try {
            return SqoopIDFUtils.toText(csvString).getBytes(BYTE_FIELD_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new SqoopException((ErrorCode)CSVIntermediateDataFormatError.CSV_INTERMEDIATE_DATA_FORMAT_0001, "The character set ISO-8859-1 is not available.");
        }
    }

    public static String encloseWithQuotes(String string) {
        StringBuilder builder = new StringBuilder();
        builder.append('\'').append(string).append('\'');
        return builder.toString();
    }

    public static String removeQuotes(String string) {
        if (string.startsWith(String.valueOf('\'')) && string.endsWith(String.valueOf('\''))) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static boolean isColumnListType(Column listType) {
        return listType.getType().equals((Object)ColumnType.ARRAY) || listType.getType().equals((Object)ColumnType.SET);
    }

    public static boolean isColumnStringType(Column stringType) {
        return stringType.getType().equals((Object)ColumnType.TEXT) || stringType.getType().equals((Object)ColumnType.ENUM);
    }

    public static String toCSV(Object[] objectArray, Schema schema) {
        Column[] columns = schema.getColumnsArray();
        StringBuilder csvString = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            if (objectArray[i] == null && !columns[i].isNullable().booleanValue()) {
                throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0005, columns[i].getName() + " does not support null values");
            }
            if (objectArray[i] == null) {
                csvString.append(NULL_VALUE);
            } else {
                switch (columns[i].getType()) {
                    case ARRAY: 
                    case SET: {
                        csvString.append(SqoopIDFUtils.toCSVList((Object[])objectArray[i], (Column)((AbstractComplexListType)columns[i])));
                        break;
                    }
                    case MAP: {
                        csvString.append(SqoopIDFUtils.toCSVMap((Map)objectArray[i], columns[i]));
                        break;
                    }
                    case ENUM: 
                    case TEXT: {
                        csvString.append(SqoopIDFUtils.toCSVString(objectArray[i].toString()));
                        break;
                    }
                    case BINARY: 
                    case UNKNOWN: {
                        csvString.append(SqoopIDFUtils.toCSVByteArray((byte[])objectArray[i]));
                        break;
                    }
                    case FIXED_POINT: {
                        csvString.append(SqoopIDFUtils.toCSVFixedPoint(objectArray[i], columns[i]));
                        break;
                    }
                    case FLOATING_POINT: {
                        csvString.append(SqoopIDFUtils.toCSVFloatingPoint(objectArray[i], columns[i]));
                        break;
                    }
                    case DECIMAL: {
                        csvString.append(SqoopIDFUtils.toCSVDecimal(objectArray[i]));
                        break;
                    }
                    case DATE: {
                        csvString.append(SqoopIDFUtils.toCSVDate(objectArray[i]));
                        break;
                    }
                    case TIME: {
                        csvString.append(SqoopIDFUtils.toCSVTime(objectArray[i], columns[i]));
                        break;
                    }
                    case DATE_TIME: {
                        if (objectArray[i] instanceof org.joda.time.DateTime) {
                            org.joda.time.DateTime dateTime = (org.joda.time.DateTime)objectArray[i];
                            csvString.append(SqoopIDFUtils.toCSVDateTime(dateTime, columns[i]));
                            break;
                        }
                        if (!(objectArray[i] instanceof LocalDateTime)) break;
                        LocalDateTime localDateTime = (LocalDateTime)objectArray[i];
                        csvString.append(SqoopIDFUtils.toCSVLocalDateTime(localDateTime, columns[i]));
                        break;
                    }
                    case BIT: {
                        csvString.append(SqoopIDFUtils.toCSVBit(objectArray[i]));
                        break;
                    }
                    default: {
                        throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0001, "Column type from schema was not recognized for " + columns[i].getType());
                    }
                }
            }
            if (i >= columns.length - 1) continue;
            csvString.append(',');
        }
        return csvString.toString();
    }

    public static String[] parseCSVString(String csvText) {
        if (csvText == null) {
            return null;
        }
        boolean quoted = false;
        boolean escaped = false;
        LinkedList<String> parsedData = new LinkedList<String>();
        StringBuilder builder = new StringBuilder();
        block5: for (int i = 0; i < csvText.length(); ++i) {
            char c = csvText.charAt(i);
            switch (c) {
                case '\'': {
                    builder.append(c);
                    if (escaped) {
                        escaped = false;
                        continue block5;
                    }
                    quoted = !quoted;
                    continue block5;
                }
                case '\\': {
                    builder.append('\\');
                    escaped = !escaped;
                    continue block5;
                }
                case ',': {
                    if (quoted) {
                        builder.append(c);
                        continue block5;
                    }
                    parsedData.add(builder.toString());
                    builder = new StringBuilder();
                    continue block5;
                }
                default: {
                    if (escaped) {
                        escaped = false;
                    }
                    builder.append(c);
                }
            }
        }
        parsedData.add(builder.toString());
        return parsedData.toArray(new String[parsedData.size()]);
    }

    private static Object toObject(String csvString, Column column) {
        Object returnValue = null;
        switch (column.getType()) {
            case ENUM: 
            case TEXT: {
                returnValue = SqoopIDFUtils.toText(csvString);
                break;
            }
            case BINARY: 
            case UNKNOWN: {
                returnValue = SqoopIDFUtils.toByteArray(csvString);
                break;
            }
            case FIXED_POINT: {
                returnValue = SqoopIDFUtils.toFixedPoint(csvString, column);
                break;
            }
            case FLOATING_POINT: {
                returnValue = SqoopIDFUtils.toFloatingPoint(csvString, column);
                break;
            }
            case DECIMAL: {
                returnValue = SqoopIDFUtils.toDecimal(csvString, column);
                break;
            }
            case DATE: {
                returnValue = SqoopIDFUtils.toDate(csvString, column);
                break;
            }
            case TIME: {
                returnValue = SqoopIDFUtils.toTime(csvString, column);
                break;
            }
            case DATE_TIME: {
                returnValue = SqoopIDFUtils.toDateTime(csvString, column);
                break;
            }
            case BIT: {
                returnValue = SqoopIDFUtils.toBit(csvString);
                break;
            }
            case ARRAY: 
            case SET: {
                returnValue = SqoopIDFUtils.toList(csvString);
                break;
            }
            case MAP: {
                returnValue = SqoopIDFUtils.toMap(csvString);
                break;
            }
            default: {
                throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0004, "Column type from schema was not recognized for " + column.getType());
            }
        }
        return returnValue;
    }

    public static Object[] fromCSV(String csvText, Schema schema) {
        String[] csvArray = SqoopIDFUtils.parseCSVString(csvText);
        if (csvArray == null) {
            return null;
        }
        Column[] columns = schema.getColumnsArray();
        if (csvArray.length != columns.length) {
            throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0001, "The data " + csvArray + " has the wrong number of fields.");
        }
        Object[] objectArray = new Object[csvArray.length];
        for (int i = 0; i < csvArray.length; ++i) {
            if (csvArray[i].equals(NULL_VALUE) && !columns[i].isNullable().booleanValue()) {
                throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0005, columns[i].getName() + " does not support null values");
            }
            objectArray[i] = csvArray[i].equals(NULL_VALUE) ? null : SqoopIDFUtils.toObject(csvArray[i], columns[i]);
        }
        return objectArray;
    }

    static {
        ORIGINALS.put(new Character('\u0000'), new String(new char[]{'\\', '0'}));
        ORIGINALS.put(new Character('\n'), new String(new char[]{'\\', 'n'}));
        ORIGINALS.put(new Character('\r'), new String(new char[]{'\\', 'r'}));
        ORIGINALS.put(new Character('\u001a'), new String(new char[]{'\\', 'Z'}));
        ORIGINALS.put(new Character('\"'), new String(new char[]{'\\', '\"'}));
        ORIGINALS.put(new Character('\''), new String(new char[]{'\\', '\''}));
        REPLACEMENTS.put(Character.valueOf('0'), new Character('\u0000'));
        REPLACEMENTS.put(Character.valueOf('n'), new Character('\n'));
        REPLACEMENTS.put(Character.valueOf('r'), new Character('\r'));
        REPLACEMENTS.put(Character.valueOf('Z'), new Character('\u001a'));
        REPLACEMENTS.put(Character.valueOf('\"'), new Character('\"'));
        REPLACEMENTS.put(Character.valueOf('\''), new Character('\''));
        dtfWithFractionAndTimeZone = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSZ");
        dtfWithNoFractionAndTimeZone = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
        dtfWithFractionNoTimeZone = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS");
        dtfWithNoFractionWithTimeZone = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ssZ");
        df = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        tfWithFraction = DateTimeFormat.forPattern((String)"HH:mm:ss.SSS");
        tfWithNoFraction = DateTimeFormat.forPattern((String)"HH:mm:ss");
        TRUE_BIT_VALUES = new String[]{"1", "true", "TRUE"};
        TRUE_BIT_SET = new HashSet<String>(Arrays.asList(TRUE_BIT_VALUES));
        FALSE_BIT_VALUES = new String[]{"0", "false", "FALSE"};
        FALSE_BIT_SET = new HashSet<String>(Arrays.asList(FALSE_BIT_VALUES));
    }
}

