/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.connector.common;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.connector.common.SqoopIDFUtils;
import org.apache.sqoop.error.code.IntermediateDataFormatError;
import org.apache.sqoop.schema.type.AbstractComplexListType;
import org.apache.sqoop.schema.type.Column;
import org.apache.sqoop.schema.type.Enum;
import org.apache.sqoop.schema.type.FixedPoint;
import org.apache.sqoop.schema.type.FloatingPoint;
import org.apache.sqoop.schema.type.Map;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class SqoopAvroUtils {
    public static final String COLUMN_TYPE = "columnType";
    public static final String SQOOP_SCHEMA_NAMESPACE = "org.apache.sqoop";

    public static Schema createAvroSchema(org.apache.sqoop.schema.Schema sqoopSchema) {
        String name = sqoopSchema.getName();
        String doc = sqoopSchema.getNote();
        String namespace = SQOOP_SCHEMA_NAMESPACE;
        Schema schema = Schema.createRecord((String)name, (String)doc, (String)namespace, (boolean)false);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (Column column : sqoopSchema.getColumnsArray()) {
            Schema.Field field = new Schema.Field(column.getName(), SqoopAvroUtils.createAvroFieldSchema(column), null, null);
            field.addProp(COLUMN_TYPE, column.getType().toString());
            fields.add(field);
        }
        schema.setFields(fields);
        return schema;
    }

    public static Schema createAvroFieldSchema(Column column) {
        Schema schema = SqoopAvroUtils.toAvroFieldType(column);
        if (!column.isNullable().booleanValue()) {
            return schema;
        }
        ArrayList<Schema> union = new ArrayList<Schema>();
        union.add(schema);
        union.add(Schema.create((Schema.Type)Schema.Type.NULL));
        return Schema.createUnion(union);
    }

    public static Schema toAvroFieldType(Column column) throws IllegalArgumentException {
        switch (column.getType()) {
            case ARRAY: 
            case SET: {
                AbstractComplexListType listColumn = (AbstractComplexListType)column;
                return Schema.createArray((Schema)SqoopAvroUtils.toAvroFieldType(listColumn.getListType()));
            }
            case UNKNOWN: 
            case BINARY: {
                return Schema.create((Schema.Type)Schema.Type.BYTES);
            }
            case BIT: {
                return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            }
            case DATE: 
            case DATE_TIME: 
            case TIME: {
                return Schema.create((Schema.Type)Schema.Type.LONG);
            }
            case DECIMAL: {
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
            case ENUM: {
                return SqoopAvroUtils.createEnumSchema(column);
            }
            case FIXED_POINT: {
                Long byteSize = ((FixedPoint)column).getByteSize();
                if (SqoopIDFUtils.isInteger(column)) {
                    return Schema.create((Schema.Type)Schema.Type.INT);
                }
                return Schema.create((Schema.Type)Schema.Type.LONG);
            }
            case FLOATING_POINT: {
                Long byteSize = ((FloatingPoint)column).getByteSize();
                if (byteSize != null && byteSize <= 4L) {
                    return Schema.create((Schema.Type)Schema.Type.FLOAT);
                }
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            case MAP: {
                Map mapColumn = (Map)column;
                return Schema.createArray((Schema)SqoopAvroUtils.toAvroFieldType(mapColumn.getValue()));
            }
            case TEXT: {
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
        }
        throw new SqoopException((ErrorCode)IntermediateDataFormatError.INTERMEDIATE_DATA_FORMAT_0004, column.getType().name());
    }

    public static Schema createEnumSchema(Column column) {
        Set options = ((Enum)column).getOptions();
        ArrayList listOptions = new ArrayList(options);
        return Schema.createEnum((String)column.getName(), null, (String)SQOOP_SCHEMA_NAMESPACE, listOptions);
    }

    public static byte[] getBytesFromByteBuffer(Object obj) {
        ByteBuffer buffer = (ByteBuffer)obj;
        byte[] bytes = new byte[buffer.remaining()];
        buffer.duplicate().get(bytes);
        return bytes;
    }
}

