/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.connector.common;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class JarUtil {
    public static List<String> getMatchedJars(Pattern[] patterns) {
        LinkedList<String> jars = new LinkedList<String>();
        for (URL url : ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs()) {
            if (!JarUtil.isDesiredJar(url.getPath(), patterns) || jars.contains(url.getFile())) continue;
            jars.add(url.toString());
        }
        return jars;
    }

    private static boolean isDesiredJar(String path, Pattern[] patterns) {
        if (path.endsWith(".jar")) {
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(path).find()) continue;
                return true;
            }
        }
        return false;
    }
}

