/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.configurable;

import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MInput;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ConfigurableUpgradeUtil {
    private static final Logger LOG = Logger.getLogger(ConfigurableUpgradeUtil.class);

    public static void doUpgrade(List<MConfig> original, List<MConfig> target) {
        HashMap<String, MConfig> configMap = new HashMap<String, MConfig>();
        for (MConfig config : original) {
            configMap.put(config.getName(), config);
        }
        for (MConfig config : target) {
            List inputs = config.getInputs();
            MConfig originalConfig = (MConfig)configMap.get(config.getName());
            if (originalConfig == null) {
                LOG.warn((Object)("Config: '" + config.getName() + "' not present in old " + "configurable. So it and its inputs will not be transferred by the upgrader."));
                continue;
            }
            for (MInput input : inputs) {
                try {
                    MInput originalInput = originalConfig.getInput(input.getName());
                    input.setValue(originalInput.getValue());
                }
                catch (SqoopException ex) {
                    LOG.warn((Object)("Input: '" + input.getName() + "' not present in old " + "configurable. So it will not be transferred by the upgrader."));
                }
            }
        }
    }
}

