/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.sentry.core.model.search.SearchModelAction;
import org.apache.solr.common.SolrException;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.sentry.SentryIndexAuthorizationSingleton;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;

public class UpdateIndexAuthorizationProcessor
extends UpdateRequestProcessor {
    private SolrQueryRequest req;
    private SentryIndexAuthorizationSingleton sentryInstance;

    public UpdateIndexAuthorizationProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        this(SentryIndexAuthorizationSingleton.getInstance(), req, rsp, next);
    }

    @VisibleForTesting
    public UpdateIndexAuthorizationProcessor(SentryIndexAuthorizationSingleton sentryInstance, SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        super(next);
        this.sentryInstance = sentryInstance;
        this.req = req;
    }

    private void authorizeCollectionAction(String operation) throws SolrException {
        this.sentryInstance.authorizeCollectionAction(this.req, EnumSet.of(SearchModelAction.UPDATE), operation);
    }

    public void processAdd(AddUpdateCommand cmd) throws IOException {
        this.authorizeCollectionAction(cmd.name());
        super.processAdd(cmd);
    }

    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        String operation = cmd.name();
        operation = cmd.isDeleteById() ? operation + "ById" : operation + "ByQuery";
        this.authorizeCollectionAction(operation);
        super.processDelete(cmd);
    }

    public void processMergeIndexes(MergeIndexesCommand cmd) throws IOException {
        this.authorizeCollectionAction(cmd.name());
        super.processMergeIndexes(cmd);
    }

    public void processCommit(CommitUpdateCommand cmd) throws IOException {
        this.authorizeCollectionAction(cmd.name());
        super.processCommit(cmd);
    }

    public void processRollback(RollbackUpdateCommand cmd) throws IOException {
        this.authorizeCollectionAction(cmd.name());
        super.processRollback(cmd);
    }

    public void finish() throws IOException {
        this.authorizeCollectionAction("finish");
        super.finish();
    }
}

