/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.sentry;

import java.net.URL;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.sentry.binding.solr.authz.SentrySolrAuthorizationException;
import org.apache.sentry.binding.solr.authz.SolrAuthzBinding;
import org.apache.sentry.binding.solr.conf.SolrAuthzConf;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.core.model.search.Collection;
import org.apache.sentry.core.model.search.SearchModelAction;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.sentry.AuditLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryIndexAuthorizationSingleton {
    private static Logger log = LoggerFactory.getLogger(SentryIndexAuthorizationSingleton.class);
    public static final String propertyName = "solr.authorization.sentry.site";
    private static final String USER_NAME = "solr.user.name";
    private static final SentryIndexAuthorizationSingleton INSTANCE = new SentryIndexAuthorizationSingleton(System.getProperty("solr.authorization.sentry.site"));
    private final SolrAuthzBinding binding;
    private final AuditLogger auditLogger = new AuditLogger();

    private SentryIndexAuthorizationSingleton(String sentrySiteLocation) {
        SolrAuthzBinding tmpBinding = null;
        try {
            if (sentrySiteLocation != null && sentrySiteLocation.length() > 0) {
                tmpBinding = new SolrAuthzBinding(new SolrAuthzConf(new URL("file://" + sentrySiteLocation)));
                log.info("SolrAuthzBinding created successfully");
            } else {
                log.info("SolrAuthzBinding not created because solr.authorization.sentry.site not set, sentry not enabled");
            }
        }
        catch (Exception ex) {
            log.error("Unable to create SolrAuthzBinding", (Throwable)ex);
        }
        this.binding = tmpBinding;
    }

    public static SentryIndexAuthorizationSingleton getInstance() {
        return INSTANCE;
    }

    public boolean isEnabled() {
        return this.binding != null;
    }

    public void authorizeAdminAction(SolrQueryRequest req, Set<SearchModelAction> actions, String operation, boolean checkCollection, String collection) throws SolrException {
        this.authorizeCollectionAction(req, actions, operation, "admin", true);
        if (checkCollection) {
            this.authorizeCollectionAction(req, actions, operation, collection, false);
        }
    }

    public void authorizeCollectionAction(SolrQueryRequest req, Set<SearchModelAction> actions, String operation) throws SolrException {
        this.authorizeCollectionAction(req, actions, operation, null, true);
    }

    public void authorizeCollectionAction(SolrQueryRequest req, Set<SearchModelAction> actions, String operation, String collectionName, boolean errorIfNoCollection) throws SolrException {
        Subject superUser = new Subject(System.getProperty("solr.authorization.superuser", "solr"));
        Subject userName = new Subject(this.getUserName(req));
        long eventTime = req.getStartTime();
        String paramString = req.getParamString();
        String impersonator = null;
        String ipAddress = null;
        HttpServletRequest sreq = (HttpServletRequest)req.getContext().get("httpRequest");
        if (sreq != null) {
            try {
                ipAddress = sreq.getRemoteAddr();
            }
            catch (AssertionError e) {
                // empty catch block
            }
        }
        if (collectionName == null) {
            SolrCore solrCore = req.getCore();
            if (solrCore == null) {
                String msg = "Unable to locate collection for sentry to authorize because no SolrCore attached to request";
                if (errorIfNoCollection) {
                    this.auditLogger.log(userName.getName(), impersonator, ipAddress, operation, paramString, eventTime, 0, collectionName);
                    throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, msg);
                }
                log.warn(msg);
                this.auditLogger.log(userName.getName(), impersonator, ipAddress, operation, paramString, eventTime, 1, collectionName);
                return;
            }
            collectionName = solrCore.getCoreDescriptor().getCloudDescriptor().getCollectionName();
        }
        Collection collection = new Collection(collectionName);
        try {
            if (!superUser.getName().equals(userName.getName())) {
                this.binding.authorizeCollection(userName, collection, actions);
            }
        }
        catch (SentrySolrAuthorizationException ex) {
            this.auditLogger.log(userName.getName(), impersonator, ipAddress, operation, paramString, eventTime, 0, collectionName);
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, (Throwable)ex);
        }
        this.auditLogger.log(userName.getName(), impersonator, ipAddress, operation, paramString, eventTime, 1, collectionName);
    }

    public Set<String> getRoles(String userName) {
        if (this.binding == null) {
            return null;
        }
        return this.binding.getRoles(userName);
    }

    public String getUserName(SolrQueryRequest req) throws SolrException {
        if (this.binding == null) {
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "Solr binding was not created successfully.  Defaulting to no access");
        }
        SolrCore solrCore = req.getCore();
        HttpServletRequest httpServletRequest = (HttpServletRequest)req.getContext().get("httpRequest");
        if (httpServletRequest == null && !(req instanceof LocalSolrQueryRequest)) {
            StringBuilder builder = new StringBuilder("Unable to locate HttpServletRequest");
            if (solrCore != null && !solrCore.getSolrConfig().getBool("requestDispatcher/requestParsers/@addHttpRequestToContext", true)) {
                builder.append(", ensure requestDispatcher/requestParsers/@addHttpRequestToContext is set to true");
            }
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, builder.toString());
        }
        String superUser = System.getProperty("solr.authorization.superuser", "solr");
        return req instanceof LocalSolrQueryRequest ? superUser : (String)httpServletRequest.getAttribute(USER_NAME);
    }

    public void deleteCollection(String collection) throws SolrException {
        try {
            this.binding.deleteCollectionPrivilege(collection);
        }
        catch (SentrySolrAuthorizationException ex) {
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, (Throwable)ex);
        }
    }
}

