/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.sentry;

import org.apache.lucene.util.Version;
import org.noggit.CharArr;
import org.noggit.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AuditLogger {
    public static final int ALLOWED = 1;
    public static final int UNAUTHORIZED = 0;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final boolean IS_ENABLED = Boolean.valueOf(System.getProperty(AuditLogger.class.getName() + ".isEnabled", "true"));
    private static final String SOLR_VERSION = Version.LATEST.toString();

    public boolean isLogEnabled() {
        return IS_ENABLED && this.logger.isInfoEnabled();
    }

    public void log(String userName, String impersonator, String ipAddress, String operation, String operationParams, long eventTime, int allowed, String collectionName) {
        if (!this.isLogEnabled()) {
            return;
        }
        CharArr chars = new CharArr(512);
        JSONWriter writer = new JSONWriter(chars, -1);
        writer.startObject();
        this.writeField("solrVersion", SOLR_VERSION, writer);
        writer.writeValueSeparator();
        this.writeField("eventTime", eventTime, writer);
        writer.writeValueSeparator();
        this.writeField("allowed", allowed, writer);
        writer.writeValueSeparator();
        this.writeField("collectionName", collectionName, writer);
        writer.writeValueSeparator();
        this.writeField("operation", operation, writer);
        writer.writeValueSeparator();
        this.writeField("operationParams", operationParams, writer);
        writer.writeValueSeparator();
        this.writeField("ipAddress", ipAddress, writer);
        writer.writeValueSeparator();
        this.writeField("username", userName, writer);
        writer.writeValueSeparator();
        this.writeField("impersonator", impersonator, writer);
        writer.endObject();
        this.logger.info("{}", (Object)chars);
    }

    private void writeField(String key, Object value, JSONWriter writer) {
        writer.writeString((CharSequence)key);
        writer.writeNameSeparator();
        writer.write(value);
    }
}

