/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import org.apache.sentry.core.model.search.SearchModelAction;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.sentry.SentryIndexAuthorizationSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryIndexAuthorizationComponent
extends SearchComponent {
    private static final String OPERATION_NAME = "query";
    private static Logger log = LoggerFactory.getLogger(QueryIndexAuthorizationComponent.class);
    private SentryIndexAuthorizationSingleton sentryInstance;

    public QueryIndexAuthorizationComponent() {
        this(SentryIndexAuthorizationSingleton.getInstance());
    }

    @VisibleForTesting
    public QueryIndexAuthorizationComponent(SentryIndexAuthorizationSingleton sentryInstance) {
        this.sentryInstance = sentryInstance;
    }

    public void prepare(ResponseBuilder rb) throws IOException {
        this.sentryInstance.authorizeCollectionAction(rb.req, EnumSet.of(SearchModelAction.QUERY), OPERATION_NAME);
        String collections = rb.req.getParams().get("collection");
        if (collections != null) {
            List collectionList = StrUtils.splitSmart((String)collections, (String)",", (boolean)true);
            for (String coll : collectionList) {
                this.sentryInstance.authorizeCollectionAction(rb.req, EnumSet.of(SearchModelAction.QUERY), OPERATION_NAME, coll, true);
            }
        }
    }

    public void process(ResponseBuilder rb) throws IOException {
    }

    public String getDescription() {
        return "Handle Query Index Authorization";
    }

    public String getSource() {
        return "$URL$";
    }
}

