/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.sqoop.conf;

import java.net.URL;
import org.apache.hadoop.conf.Configuration;

public class SqoopAuthConf
extends Configuration {
    public static final String SENTRY_SQOOP_SITE_URL = "sentry.sqoop.site.url";
    public static final String AUTHZ_SITE_FILE = "sentry-site.xml";

    public SqoopAuthConf(URL sqoopAuthzSiteURL) {
        super(true);
        this.addResource(sqoopAuthzSiteURL);
    }

    public String get(String varName) {
        return this.get(varName, AuthzConfVars.getDefault(varName));
    }

    public static enum AuthzConfVars {
        AUTHZ_PROVIDER("sentry.sqoop.provider", "org.apache.sentry.provider.common.HadoopGroupResourceAuthorizationProvider"),
        AUTHZ_PROVIDER_RESOURCE("sentry.sqoop.provider.resource", ""),
        AUTHZ_PROVIDER_BACKEND("sentry.sqoop.provider.backend", "org.apache.sentry.provider.db.generic.SentryGenericProviderBackend"),
        AUTHZ_POLICY_ENGINE("sentry.sqoop.policy.engine", "org.apache.sentry.policy.sqoop.SimpleSqoopPolicyEngine"),
        AUTHZ_SERVER_NAME("sentry.sqoop.name", ""),
        AUTHZ_TESTING_MODE("sentry.sqoop.testing.mode", "false");

        private final String varName;
        private final String defaultVal;

        private AuthzConfVars(String varName, String defaultVal) {
            this.varName = varName;
            this.defaultVal = defaultVal;
        }

        public String getVar() {
            return this.varName;
        }

        public String getDefault() {
            return this.defaultVal;
        }

        public static String getDefault(String varName) {
            for (AuthzConfVars oneVar : AuthzConfVars.values()) {
                if (!oneVar.getVar().equalsIgnoreCase(varName)) continue;
                return oneVar.getDefault();
            }
            return null;
        }
    }
}

