/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.sqoop.binding;

import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.sentry.sqoop.binding.SqoopAuthBinding;
import org.apache.sentry.sqoop.conf.SqoopAuthConf;
import org.apache.sqoop.core.SqoopConfiguration;
import org.apache.sqoop.security.SecurityConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqoopAuthBindingSingleton {
    private static Logger log = LoggerFactory.getLogger(SqoopAuthBindingSingleton.class);
    private static SqoopAuthBindingSingleton instance = null;
    private SqoopAuthBinding binding;

    private SqoopAuthBindingSingleton() {
        SqoopAuthBinding tmpBinding = null;
        try {
            String serverName = SqoopConfiguration.getInstance().getContext().getString("org.apache.sqoop.security.authorization.server_name");
            if (Strings.isNullOrEmpty((String)serverName)) {
                throw new IllegalArgumentException("org.apache.sqoop.security.authorization.server_name can't be null or empty");
            }
            SqoopAuthConf conf = this.loadAuthzConf();
            this.validateSentrySqoopConfig(conf);
            tmpBinding = new SqoopAuthBinding(conf, serverName.trim());
            log.info("SqoopAuthBinding created successfully");
        }
        catch (Exception ex) {
            log.error("Unable to create SqoopAuthBinding", (Throwable)ex);
            throw new RuntimeException("Unable to create SqoopAuthBinding: " + ex.getMessage(), ex);
        }
        this.binding = tmpBinding;
    }

    private SqoopAuthConf loadAuthzConf() {
        String sentry_site = SqoopConfiguration.getInstance().getContext().getString("sentry.sqoop.site.url");
        if (Strings.isNullOrEmpty((String)sentry_site)) {
            throw new IllegalArgumentException("Configuration key sentry.sqoop.site.url value '" + sentry_site + "' is invalid.");
        }
        SqoopAuthConf sqoopAuthConf = null;
        try {
            sqoopAuthConf = new SqoopAuthConf(new URL(sentry_site));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Configuration key sentry.sqoop.site.url specifies a malformed URL '" + sentry_site + "'", e);
        }
        return sqoopAuthConf;
    }

    private void validateSentrySqoopConfig(SqoopAuthConf conf) {
        boolean isTestingMode = Boolean.parseBoolean(conf.get(SqoopAuthConf.AuthzConfVars.AUTHZ_TESTING_MODE.getVar(), SqoopAuthConf.AuthzConfVars.AUTHZ_TESTING_MODE.getDefault()));
        String authentication = SqoopConfiguration.getInstance().getContext().getString("org.apache.sqoop.security.authentication.type", SecurityConstants.TYPE.SIMPLE.name());
        String kerberos = SecurityConstants.TYPE.KERBEROS.name();
        if (!isTestingMode && !kerberos.equalsIgnoreCase(authentication)) {
            throw new IllegalArgumentException("org.apache.sqoop.security.authentication.typecan't be set simple mode in non-testing mode");
        }
    }

    public static SqoopAuthBindingSingleton getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new SqoopAuthBindingSingleton();
        return instance;
    }

    public SqoopAuthBinding getAuthBinding() {
        return this.binding;
    }
}

