/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.sqoop.binding;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.SentryUserException;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.BitFieldAction;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.core.model.sqoop.Server;
import org.apache.sentry.core.model.sqoop.SqoopActionFactory;
import org.apache.sentry.policy.common.PolicyEngine;
import org.apache.sentry.provider.common.AuthorizationProvider;
import org.apache.sentry.provider.common.ProviderBackend;
import org.apache.sentry.provider.db.generic.SentryGenericProviderBackend;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceClient;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceClientFactory;
import org.apache.sentry.provider.db.generic.service.thrift.TAuthorizable;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryGrantOption;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryRole;
import org.apache.sentry.sqoop.conf.SqoopAuthConf;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.MPrivilege;
import org.apache.sqoop.model.MResource;
import org.apache.sqoop.model.MRole;
import org.apache.sqoop.security.SecurityError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqoopAuthBinding {
    private static final Logger LOG = LoggerFactory.getLogger(SqoopAuthBinding.class);
    private static final String COMPONENT_TYPE = "sqoop";
    private final Configuration authConf;
    private final AuthorizationProvider authProvider;
    private final Server sqoopServer;
    private final Subject bindingSubject;
    private ProviderBackend providerBackend;
    private final SqoopActionFactory actionFactory = new SqoopActionFactory();

    public SqoopAuthBinding(Configuration authConf, String serverName) throws Exception {
        this.authConf = authConf;
        this.authConf.set(SqoopAuthConf.AuthzConfVars.AUTHZ_SERVER_NAME.getVar(), serverName);
        this.sqoopServer = new Server(serverName);
        this.authProvider = this.createAuthProvider();
        this.bindingSubject = new Subject(UserGroupInformation.getCurrentUser().getShortUserName());
    }

    private AuthorizationProvider createAuthProvider() throws Exception {
        String authProviderName = this.authConf.get(SqoopAuthConf.AuthzConfVars.AUTHZ_PROVIDER.getVar(), SqoopAuthConf.AuthzConfVars.AUTHZ_PROVIDER.getDefault());
        String resourceName = this.authConf.get(SqoopAuthConf.AuthzConfVars.AUTHZ_PROVIDER_RESOURCE.getVar(), SqoopAuthConf.AuthzConfVars.AUTHZ_PROVIDER_RESOURCE.getDefault());
        String providerBackendName = this.authConf.get(SqoopAuthConf.AuthzConfVars.AUTHZ_PROVIDER_BACKEND.getVar(), SqoopAuthConf.AuthzConfVars.AUTHZ_PROVIDER_BACKEND.getDefault());
        String policyEngineName = this.authConf.get(SqoopAuthConf.AuthzConfVars.AUTHZ_POLICY_ENGINE.getVar(), SqoopAuthConf.AuthzConfVars.AUTHZ_POLICY_ENGINE.getDefault());
        String serviceName = this.authConf.get(SqoopAuthConf.AuthzConfVars.AUTHZ_SERVER_NAME.getVar());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using authorization provider " + authProviderName + " with resource " + resourceName + ", policy engine " + policyEngineName + ", provider backend " + providerBackendName);
        }
        if ("org.apache.sentry.sqoop.binding.SqoopProviderBackend".equals(providerBackendName)) {
            providerBackendName = SentryGenericProviderBackend.class.getName();
        }
        Constructor<?> providerBackendConstructor = Class.forName(providerBackendName).getDeclaredConstructor(Configuration.class, String.class);
        providerBackendConstructor.setAccessible(true);
        this.providerBackend = (ProviderBackend)providerBackendConstructor.newInstance(this.authConf, resourceName);
        if (this.providerBackend instanceof SentryGenericProviderBackend) {
            ((SentryGenericProviderBackend)this.providerBackend).setComponentType(COMPONENT_TYPE);
            ((SentryGenericProviderBackend)this.providerBackend).setServiceName(serviceName);
        }
        Constructor<?> policyConstructor = Class.forName(policyEngineName).getDeclaredConstructor(String.class, ProviderBackend.class);
        policyConstructor.setAccessible(true);
        PolicyEngine policyEngine = (PolicyEngine)policyConstructor.newInstance(this.sqoopServer.getName(), this.providerBackend);
        Constructor<?> constrctor = Class.forName(authProviderName).getDeclaredConstructor(Configuration.class, String.class, PolicyEngine.class);
        constrctor.setAccessible(true);
        return (AuthorizationProvider)constrctor.newInstance(this.authConf, resourceName, policyEngine);
    }

    public boolean authorize(Subject subject, MPrivilege privilege) {
        List<Authorizable> authorizables = this.toAuthorizable(privilege.getResource());
        if (!this.hasServerInclude(authorizables)) {
            authorizables.add(0, (Authorizable)this.sqoopServer);
        }
        return this.authProvider.hasAccess(subject, authorizables, (Set)Sets.newHashSet((Object[])new BitFieldAction[]{this.actionFactory.getActionByName(privilege.getAction())}), ActiveRoleSet.ALL);
    }

    public boolean hasServerInclude(List<Authorizable> authorizables) {
        for (Authorizable authorizable : authorizables) {
            if (!authorizable.getTypeName().equalsIgnoreCase(this.sqoopServer.getTypeName())) continue;
            return true;
        }
        return false;
    }

    private SentryGenericServiceClient getClient() throws Exception {
        return SentryGenericServiceClientFactory.create((Configuration)this.authConf);
    }

    public void createRole(final Subject subject, final String role) throws SqoopException {
        this.execute(new Command<Void>(){

            @Override
            public Void run(SentryGenericServiceClient client) throws Exception {
                client.createRole(subject.getName(), role, SqoopAuthBinding.COMPONENT_TYPE);
                return null;
            }
        });
    }

    public void dropRole(final Subject subject, final String role) throws SqoopException {
        this.execute(new Command<Void>(){

            @Override
            public Void run(SentryGenericServiceClient client) throws Exception {
                client.dropRole(subject.getName(), role, SqoopAuthBinding.COMPONENT_TYPE);
                return null;
            }
        });
    }

    public List<MRole> listAllRoles(final Subject subject) throws SqoopException {
        Set<TSentryRole> tSentryRoles = this.execute(new Command<Set<TSentryRole>>(){

            @Override
            public Set<TSentryRole> run(SentryGenericServiceClient client) throws Exception {
                return client.listAllRoles(subject.getName(), SqoopAuthBinding.COMPONENT_TYPE);
            }
        });
        ArrayList roles = Lists.newArrayList();
        for (TSentryRole tRole : tSentryRoles) {
            roles.add(new MRole(tRole.getRoleName()));
        }
        return roles;
    }

    public List<MRole> listRolesByGroup(final Subject subject, final String groupName) throws SqoopException {
        Set<TSentryRole> tSentryRoles = this.execute(new Command<Set<TSentryRole>>(){

            @Override
            public Set<TSentryRole> run(SentryGenericServiceClient client) throws Exception {
                return client.listRolesByGroupName(subject.getName(), groupName, SqoopAuthBinding.COMPONENT_TYPE);
            }
        });
        ArrayList roles = Lists.newArrayList();
        for (TSentryRole tSentryRole : tSentryRoles) {
            roles.add(new MRole(tSentryRole.getRoleName()));
        }
        return roles;
    }

    public List<MPrivilege> listPrivilegeByRole(final Subject subject, final String role, final MResource resource) throws SqoopException {
        Set<TSentryPrivilege> tSentryPrivileges = this.execute(new Command<Set<TSentryPrivilege>>(){

            @Override
            public Set<TSentryPrivilege> run(SentryGenericServiceClient client) throws Exception {
                if (resource == null) {
                    return client.listPrivilegesByRoleName(subject.getName(), role, SqoopAuthBinding.COMPONENT_TYPE, SqoopAuthBinding.this.sqoopServer.getName());
                }
                if (resource.getType().equalsIgnoreCase(MResource.TYPE.SERVER.name())) {
                    return client.listPrivilegesByRoleName(subject.getName(), role, SqoopAuthBinding.COMPONENT_TYPE, resource.getName());
                }
                return client.listPrivilegesByRoleName(subject.getName(), role, SqoopAuthBinding.COMPONENT_TYPE, SqoopAuthBinding.this.sqoopServer.getName(), SqoopAuthBinding.this.toAuthorizable(resource));
            }
        });
        ArrayList privileges = Lists.newArrayList();
        for (TSentryPrivilege tSentryPrivilege : tSentryPrivileges) {
            privileges.add(this.toSqoopPrivilege(tSentryPrivilege));
        }
        return privileges;
    }

    public void grantPrivilege(final Subject subject, final String role, final MPrivilege privilege) throws SqoopException {
        this.execute(new Command<Void>(){

            @Override
            public Void run(SentryGenericServiceClient client) throws Exception {
                client.grantPrivilege(subject.getName(), role, SqoopAuthBinding.COMPONENT_TYPE, SqoopAuthBinding.this.toTSentryPrivilege(privilege));
                return null;
            }
        });
    }

    public void revokePrivilege(final Subject subject, final String role, final MPrivilege privilege) throws SqoopException {
        this.execute(new Command<Void>(){

            @Override
            public Void run(SentryGenericServiceClient client) throws Exception {
                client.revokePrivilege(subject.getName(), role, SqoopAuthBinding.COMPONENT_TYPE, SqoopAuthBinding.this.toTSentryPrivilege(privilege));
                return null;
            }
        });
    }

    public void grantGroupToRole(final Subject subject, final String group, final MRole role) throws SqoopException {
        this.execute(new Command<Void>(){

            @Override
            public Void run(SentryGenericServiceClient client) throws Exception {
                client.addRoleToGroups(subject.getName(), role.getName(), SqoopAuthBinding.COMPONENT_TYPE, (Set)Sets.newHashSet((Object[])new String[]{group}));
                return null;
            }
        });
    }

    public void revokeGroupfromRole(final Subject subject, final String group, final MRole role) throws SqoopException {
        this.execute(new Command<Void>(){

            @Override
            public Void run(SentryGenericServiceClient client) throws Exception {
                client.deleteRoleToGroups(subject.getName(), role.getName(), SqoopAuthBinding.COMPONENT_TYPE, (Set)Sets.newHashSet((Object[])new String[]{group}));
                return null;
            }
        });
    }

    public void renamePrivilege(final Subject subject, final MResource srcResource, final MResource dstResource) throws SqoopException {
        this.execute(new Command<Void>(){

            @Override
            public Void run(SentryGenericServiceClient client) throws Exception {
                client.renamePrivilege(subject.getName(), SqoopAuthBinding.COMPONENT_TYPE, SqoopAuthBinding.this.sqoopServer.getName(), SqoopAuthBinding.this.toAuthorizable(srcResource), SqoopAuthBinding.this.toAuthorizable(dstResource));
                return null;
            }
        });
    }

    public void dropPrivilege(final MResource resource) throws SqoopException {
        this.execute(new Command<Void>(){

            @Override
            public Void run(SentryGenericServiceClient client) throws Exception {
                TSentryPrivilege privilege = new TSentryPrivilege();
                privilege.setComponent(SqoopAuthBinding.COMPONENT_TYPE);
                privilege.setServiceName(SqoopAuthBinding.this.sqoopServer.getName());
                privilege.setAuthorizables(SqoopAuthBinding.this.toTSentryAuthorizable(resource));
                privilege.setAction("*");
                client.dropPrivilege(SqoopAuthBinding.this.bindingSubject.getName(), SqoopAuthBinding.COMPONENT_TYPE, privilege);
                return null;
            }
        });
    }

    private MPrivilege toSqoopPrivilege(TSentryPrivilege tPrivilege) {
        boolean grantOption = false;
        if (tPrivilege.getGrantOption() == TSentryGrantOption.TRUE) {
            grantOption = true;
        }
        return new MPrivilege(this.toSqoopResource(tPrivilege.getAuthorizables()), tPrivilege.getAction().equalsIgnoreCase("*") ? "ALL" : tPrivilege.getAction(), grantOption);
    }

    private MResource toSqoopResource(List<TAuthorizable> authorizables) {
        if (authorizables == null || authorizables.isEmpty()) {
            return new MResource(this.sqoopServer.getName(), MResource.TYPE.SERVER);
        }
        return new MResource(authorizables.get(0).getName(), authorizables.get(0).getType());
    }

    private TSentryPrivilege toTSentryPrivilege(MPrivilege privilege) {
        TSentryPrivilege tSentryPrivilege = new TSentryPrivilege();
        tSentryPrivilege.setComponent(COMPONENT_TYPE);
        tSentryPrivilege.setServiceName(this.sqoopServer.getName());
        tSentryPrivilege.setAction(privilege.getAction().equalsIgnoreCase("ALL") ? "*" : privilege.getAction());
        if (privilege.isWith_grant_option()) {
            tSentryPrivilege.setGrantOption(TSentryGrantOption.TRUE);
        } else {
            tSentryPrivilege.setGrantOption(TSentryGrantOption.FALSE);
        }
        tSentryPrivilege.setAuthorizables(this.toTSentryAuthorizable(privilege.getResource()));
        return tSentryPrivilege;
    }

    private List<TAuthorizable> toTSentryAuthorizable(MResource resource) {
        ArrayList tAuthorizables = Lists.newArrayList();
        if (resource.getType().equalsIgnoreCase(MResource.TYPE.SERVER.name())) {
            if (!resource.getName().equalsIgnoreCase(this.sqoopServer.getName())) {
                throw new IllegalArgumentException(resource.getName() + " must be equal to " + this.sqoopServer.getName() + "\n" + " Currently Sqoop supports grant/revoke privileges on server object, but the server name must be equal to the configuration " + "of org.apache.sqoop.security.authorization.server_name in the Sqoop.properties");
            }
        } else {
            tAuthorizables.add(new TAuthorizable(resource.getType(), resource.getName()));
        }
        return tAuthorizables;
    }

    private List<Authorizable> toAuthorizable(final MResource resource) {
        ArrayList authorizables = Lists.newArrayList();
        if (resource == null) {
            return authorizables;
        }
        authorizables.add(new Authorizable(){

            public String getTypeName() {
                return resource.getType();
            }

            public String getName() {
                return resource.getName();
            }
        });
        return authorizables;
    }

    private <T> T execute(Command<T> cmd) throws SqoopException {
        SentryGenericServiceClient client = null;
        try {
            client = this.getClient();
            T t = cmd.run(client);
            return t;
        }
        catch (SentryUserException ex) {
            String msg = "Unable to excute command on sentry server: " + ex.getMessage();
            LOG.error(msg, (Throwable)ex);
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0014, msg, (Throwable)ex);
        }
        catch (Exception ex) {
            String msg = "Unable to obtain client:" + ex.getMessage();
            LOG.error(msg, (Throwable)ex);
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0014, msg, (Throwable)ex);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    private static interface Command<T> {
        public T run(SentryGenericServiceClient var1) throws Exception;
    }
}

