/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.sqoop.authz;

import java.util.List;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.sqoop.PrincipalDesc;
import org.apache.sentry.sqoop.binding.SqoopAuthBinding;
import org.apache.sentry.sqoop.binding.SqoopAuthBindingSingleton;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.MPrincipal;
import org.apache.sqoop.model.MPrivilege;
import org.apache.sqoop.security.AuthorizationValidator;
import org.apache.sqoop.security.SecurityError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryAuthorizationValidator
extends AuthorizationValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SentryAuthorizationValidator.class);
    private final SqoopAuthBinding binding = SqoopAuthBindingSingleton.getInstance().getAuthBinding();

    public void checkPrivileges(MPrincipal principal, List<MPrivilege> privileges) throws SqoopException {
        if (privileges == null || privileges.isEmpty()) {
            return;
        }
        PrincipalDesc principalDesc = new PrincipalDesc(principal.getName(), principal.getType());
        if (principalDesc.getType() != PrincipalDesc.PrincipalType.USER) {
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0014, "Sentry does only support authorization check on user principal, not supported on ");
        }
        for (MPrivilege privilege : privileges) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Going to authorize check on privilege : " + privilege + " for principal: " + principal);
            }
            if (this.binding.authorize(new Subject(principalDesc.getName()), privilege)) continue;
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0014, "User " + principalDesc.getName() + " does not have privileges for : " + privilege.toString());
        }
    }
}

