/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.sqoop.authz;

import java.util.List;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.MPrincipal;
import org.apache.sqoop.model.MPrivilege;
import org.apache.sqoop.model.MResource;
import org.apache.sqoop.model.MRole;
import org.apache.sqoop.security.AuthenticationProvider;
import org.apache.sqoop.security.authorization.DefaultAuthorizationHandler;

public class SentryAuthorizationHander
extends DefaultAuthorizationHandler {
    private static AuthenticationProvider authenticator;

    public static AuthenticationProvider getAuthenticator() {
        if (authenticator == null) {
            throw new RuntimeException("authenticator can't be null");
        }
        return authenticator;
    }

    public void doInitialize(AuthenticationProvider authenticationProvider, String serverName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        super.doInitialize(authenticationProvider, serverName);
        authenticator = authenticationProvider;
    }

    public void checkPrivileges(MPrincipal principal, List<MPrivilege> privileges) throws SqoopException {
        this.authorizationValidator.checkPrivileges(principal, privileges);
    }

    public void createRole(MRole role) throws SqoopException {
        this.authorizationAccessController.createRole(role);
    }

    public void dropRole(MRole role) throws SqoopException {
        this.authorizationAccessController.dropRole(role);
    }

    public List<MRole> getAllRoles() throws SqoopException {
        return this.authorizationAccessController.getAllRoles();
    }

    public List<MPrincipal> getPrincipalsByRole(MRole role) throws SqoopException {
        return this.authorizationAccessController.getPrincipalsByRole(role);
    }

    public List<MPrivilege> getPrivilegesByPrincipal(MPrincipal principal, MResource resource) throws SqoopException {
        return this.authorizationAccessController.getPrivilegesByPrincipal(principal, resource);
    }

    public List<MRole> getRolesByPrincipal(MPrincipal principal) throws SqoopException {
        return this.authorizationAccessController.getRolesByPrincipal(principal);
    }

    public void grantPrivileges(List<MPrincipal> principals, List<MPrivilege> privileges) throws SqoopException {
        this.authorizationAccessController.grantPrivileges(principals, privileges);
    }

    public void grantRole(List<MPrincipal> principals, List<MRole> roles) throws SqoopException {
        this.authorizationAccessController.grantRole(principals, roles);
    }

    public void removeResource(MResource resource) throws SqoopException {
        this.authorizationAccessController.removeResource(resource);
    }

    public void revokePrivileges(List<MPrincipal> principals, List<MPrivilege> privileges) throws SqoopException {
        this.authorizationAccessController.revokePrivileges(principals, privileges);
    }

    public void revokeRole(List<MPrincipal> principals, List<MRole> roles) throws SqoopException {
        this.authorizationAccessController.revokeRole(principals, roles);
    }

    public void updateResource(MResource srcResource, MResource dstResource) throws SqoopException {
        this.authorizationAccessController.updateResource(srcResource, dstResource);
    }
}

