/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.sqoop.authz;

import java.util.List;
import org.apache.log4j.Logger;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.sqoop.PrincipalDesc;
import org.apache.sentry.sqoop.authz.SentryAuthorizationHander;
import org.apache.sentry.sqoop.binding.SqoopAuthBinding;
import org.apache.sentry.sqoop.binding.SqoopAuthBindingSingleton;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.MPrincipal;
import org.apache.sqoop.model.MPrivilege;
import org.apache.sqoop.model.MResource;
import org.apache.sqoop.model.MRole;
import org.apache.sqoop.security.AuthorizationAccessController;
import org.apache.sqoop.security.SecurityError;

public class SentryAccessController
extends AuthorizationAccessController {
    private static final Logger LOG = Logger.getLogger(SentryAccessController.class);
    private final SqoopAuthBinding binding = SqoopAuthBindingSingleton.getInstance().getAuthBinding();

    private Subject getSubject() {
        return new Subject(SentryAuthorizationHander.getAuthenticator().getUserName());
    }

    public void createRole(MRole role) throws SqoopException {
        this.binding.createRole(this.getSubject(), role.getName());
    }

    public void dropRole(MRole role) throws SqoopException {
        this.binding.dropRole(this.getSubject(), role.getName());
    }

    public List<MRole> getAllRoles() throws SqoopException {
        return this.binding.listAllRoles(this.getSubject());
    }

    public List<MPrincipal> getPrincipalsByRole(MRole role) throws SqoopException {
        throw new SqoopException((ErrorCode)SecurityError.AUTH_0014, "Sentry does not implement yet ");
    }

    public List<MPrivilege> getPrivilegesByPrincipal(MPrincipal principal, MResource resource) throws SqoopException {
        PrincipalDesc principalDesc = PrincipalDesc.fromStr(principal.getName(), principal.getType());
        if (principalDesc.getType() != PrincipalDesc.PrincipalType.ROLE) {
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0014, "Sentry does only support show privilege on role, not supported on " + principalDesc.getType().name());
        }
        return this.binding.listPrivilegeByRole(this.getSubject(), principalDesc.getName(), resource);
    }

    public List<MRole> getRolesByPrincipal(MPrincipal principal) throws SqoopException {
        PrincipalDesc principalDesc = PrincipalDesc.fromStr(principal.getName(), principal.getType());
        if (principalDesc.getType() != PrincipalDesc.PrincipalType.GROUP) {
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0014, "Sentry does only support show roles on group, not supported on " + principalDesc.getType().name());
        }
        return this.binding.listRolesByGroup(this.getSubject(), principalDesc.getName());
    }

    public void grantPrivileges(List<MPrincipal> principals, List<MPrivilege> privileges) throws SqoopException {
        for (MPrincipal principal : principals) {
            PrincipalDesc principalDesc = PrincipalDesc.fromStr(principal.getName(), principal.getType());
            if (principalDesc.getType() != PrincipalDesc.PrincipalType.ROLE) {
                throw new SqoopException((ErrorCode)SecurityError.AUTH_0014, "Sentry does only support grant/revoke privilege to/from role, not supported on " + principalDesc.getType().name());
            }
            for (MPrivilege privilege : privileges) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Going to grant privilege : " + privilege + " to principal: " + principal));
                }
                this.binding.grantPrivilege(this.getSubject(), principal.getName(), privilege);
            }
        }
    }

    public void grantRole(List<MPrincipal> principals, List<MRole> roles) throws SqoopException {
        for (MPrincipal principal : principals) {
            PrincipalDesc principalDesc = PrincipalDesc.fromStr(principal.getName(), principal.getType());
            if (principalDesc.getType() != PrincipalDesc.PrincipalType.GROUP) {
                throw new SqoopException((ErrorCode)SecurityError.AUTH_0014, "Sentry does only support grant/revoke role to/from group, not supported on " + principalDesc.getType().name());
            }
            for (MRole role : roles) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Going to grant role : " + role.getName() + " to principal: " + principal));
                }
                this.binding.grantGroupToRole(this.getSubject(), principal.getName(), role);
            }
        }
    }

    public void removeResource(MResource resource) throws SqoopException {
        this.binding.dropPrivilege(resource);
    }

    public void revokePrivileges(List<MPrincipal> principals, List<MPrivilege> privileges) throws SqoopException {
        for (MPrincipal principal : principals) {
            PrincipalDesc principalDesc = PrincipalDesc.fromStr(principal.getName(), principal.getType());
            if (principalDesc.getType() != PrincipalDesc.PrincipalType.ROLE) {
                throw new SqoopException((ErrorCode)SecurityError.AUTH_0014, "Sentry does only support grant/revoke privilege to/from role, not supported on " + principalDesc.getType().name());
            }
            for (MPrivilege privilege : privileges) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Going to revoke privilege : " + privilege + " from principal: " + principal));
                }
                this.binding.revokePrivilege(this.getSubject(), principal.getName(), privilege);
            }
        }
    }

    public void revokeRole(List<MPrincipal> principals, List<MRole> roles) throws SqoopException {
        for (MPrincipal principal : principals) {
            PrincipalDesc principalDesc = PrincipalDesc.fromStr(principal.getName(), principal.getType());
            if (principalDesc.getType() != PrincipalDesc.PrincipalType.GROUP) {
                throw new SqoopException((ErrorCode)SecurityError.AUTH_0014, "Sentry does only support grant/revoke role to/from group, not supported on " + principalDesc.getType().name());
            }
            for (MRole role : roles) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Going to revoke role : " + role.getName() + " from principal: " + principal));
                }
                this.binding.revokeGroupfromRole(this.getSubject(), principal.getName(), role);
            }
        }
    }

    public void updateResource(MResource srcResource, MResource dstResource) throws SqoopException {
        this.binding.renamePrivilege(this.getSubject(), srcResource, dstResource);
    }
}

