/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class QueueInfo {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static QueueInfo newInstance(String queueName, float capacity, float maximumCapacity, float currentCapacity, List<QueueInfo> childQueues, List<ApplicationReport> applications, QueueState queueState, Set<String> accessibleNodeLabels, String defaultNodeLabelExpression) {
        QueueInfo queueInfo = Records.newRecord(QueueInfo.class);
        queueInfo.setQueueName(queueName);
        queueInfo.setCapacity(capacity);
        queueInfo.setMaximumCapacity(maximumCapacity);
        queueInfo.setCurrentCapacity(currentCapacity);
        queueInfo.setChildQueues(childQueues);
        queueInfo.setApplications(applications);
        queueInfo.setQueueState(queueState);
        queueInfo.setAccessibleNodeLabels(accessibleNodeLabels);
        queueInfo.setDefaultNodeLabelExpression(defaultNodeLabelExpression);
        return queueInfo;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getQueueName();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setQueueName(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract float getCapacity();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setCapacity(float var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract float getMaximumCapacity();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setMaximumCapacity(float var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract float getCurrentCapacity();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setCurrentCapacity(float var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract List<QueueInfo> getChildQueues();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setChildQueues(List<QueueInfo> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract List<ApplicationReport> getApplications();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setApplications(List<ApplicationReport> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract QueueState getQueueState();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setQueueState(QueueState var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getQueueLabel();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setQueueLabel(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getQueueLabelPolicy();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setQueueLabelPolicy(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Set<String> getAccessibleNodeLabels();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setAccessibleNodeLabels(Set<String> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getDefaultNodeLabelExpression();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setDefaultNodeLabelExpression(String var1);
}

